/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="roadweaver")
public class ModEventHandler {
    private static final int THREAD_COUNT = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static ExecutorService executor = Executors.newFixedThreadPool(7);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();

    public static void register() {
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (!serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        ModEventHandler.restartExecutorIfNeeded();
        WorldDataHelper.StructureLocationsData locationsData = WorldDataHelper.structureLocations(serverLevel);
        ModEventHandler.restoreUnfinishedRoads(serverLevel);
        if (locationsData.getLocations().size() < ModConfig.initialLocatingCount) {
            for (int i = 0; i < ModConfig.initialLocatingCount; ++i) {
                StructureConnector.cacheNewConnection(serverLevel, false);
                ModEventHandler.tryGenerateNewRoads(serverLevel, true, 5000);
            }
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (!serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        Future<?> task = runningTasks.remove(serverLevel.m_46472_().m_135782_().toString());
        if (task != null && !task.isDone()) {
            task.cancel(true);
            LOGGER.debug("RoadWeaver: Aborted running road task for world {}", (Object)serverLevel.m_46472_().m_135782_());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        ModEventHandler.tryGenerateNewRoads(serverLevel, true, 5000);
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        RoadPathCalculator.heightCache.clear();
        runningTasks.values().forEach(future -> future.cancel(true));
        runningTasks.clear();
        executor.shutdownNow();
        LOGGER.debug("RoadWeaver: ExecutorService shut down.");
    }

    private static void tryGenerateNewRoads(ServerLevel serverWorld, boolean async, int steps) {
        runningTasks.entrySet().removeIf(entry -> ((Future)entry.getValue()).isDone());
        if (runningTasks.size() >= ModConfig.maxConcurrentRoadGeneration) {
            LOGGER.debug("RoadWeaver: Maximum concurrent road generation tasks reached. Skipping generation.");
            return;
        }
        if (StructureConnector.cachedStructureConnections.isEmpty()) {
            return;
        }
        Records.StructureConnection structureConnection = StructureConnector.cachedStructureConnections.poll();
        if (structureConnection == null) {
            return;
        }
        Holder featureHolder = serverWorld.m_9598_().m_175515_(Registries.f_256911_).m_203636_(RoadFeature.ROAD_FEATURE_KEY).orElse(null);
        if (featureHolder == null) {
            LOGGER.debug("RoadWeaver: road feature is not registered in this world.");
            return;
        }
        FeatureConfiguration featureConfiguration = ((ConfiguredFeature)featureHolder.m_203334_()).f_65378_();
        if (!(featureConfiguration instanceof RoadFeatureConfig)) {
            LOGGER.debug("RoadWeaver: road feature config type mismatch, skip generation.");
            return;
        }
        RoadFeatureConfig roadConfig = (RoadFeatureConfig)featureConfiguration;
        if (async) {
            String taskId = serverWorld.m_46472_().m_135782_().toString() + "_" + System.nanoTime();
            Future<?> future = executor.submit(() -> {
                try {
                    new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                }
                catch (Exception e) {
                    LOGGER.error("RoadWeaver: Error generating road asynchronously", (Throwable)e);
                }
                finally {
                    runningTasks.remove(taskId);
                }
            });
            runningTasks.put(taskId, future);
        } else {
            new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(7);
            LOGGER.debug("RoadWeaver: ExecutorService restarted.");
        }
    }

    private static void restoreUnfinishedRoads(ServerLevel serverWorld) {
        WorldDataHelper.StructureConnectionsData connectionsData = WorldDataHelper.structureConnections(serverWorld);
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(connectionsData.getConnections());
        int restoredCount = 0;
        for (int i = 0; i < connections.size(); ++i) {
            Records.StructureConnection connection = (Records.StructureConnection)connections.get(i);
            if (connection.status() != Records.ConnectionStatus.PLANNED && connection.status() != Records.ConnectionStatus.GENERATING) continue;
            Records.StructureConnection queuedConnection = connection;
            if (connection.status() == Records.ConnectionStatus.GENERATING) {
                queuedConnection = new Records.StructureConnection(connection.from(), connection.to(), Records.ConnectionStatus.PLANNED);
                connections.set(i, queuedConnection);
            }
            StructureConnector.cachedStructureConnections.add(queuedConnection);
            ++restoredCount;
        }
        connectionsData.setConnections(connections);
        if (restoredCount > 0) {
            LOGGER.info("RoadWeaver: \u6062\u590d\u4e86 {} \u4e2a\u672a\u5b8c\u6210\u7684\u9053\u8def\u751f\u6210\u4efb\u52a1", (Object)restoredCount);
        }
    }
}

