/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.NbtStructureDecoration;
import net.countered.settlementroads.features.decoration.RoadFenceDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.decoration.SwingDecoration;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    public static final Set<Block> DONT_PLACE_HERE = new HashSet<Block>();
    public static int chunksForLocatingCounter;
    public static final ResourceKey<PlacedFeature> ROAD_FEATURE_PLACED_KEY;
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROAD_FEATURE_KEY;
    public static final Feature<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> context) {
        try {
            ServerLevel serverLevel;
            WorldGenLevel level;
            if (RoadPathCalculator.heightCache.size() > 100000) {
                RoadPathCalculator.heightCache.clear();
            }
            if ((level = context.m_159774_()) == null) {
                LOGGER.warn("WorldGenLevel is null in RoadFeature.place()");
                return false;
            }
            if (level instanceof ServerLevel) {
                ServerLevel sl;
                serverLevel = sl = (ServerLevel)level;
            } else {
                try {
                    serverLevel = level.m_6018_();
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot get ServerLevel from WorldGenLevel: {}", (Object)e.getMessage());
                    return false;
                }
            }
            if (serverLevel == null) {
                LOGGER.warn("ServerLevel is null in RoadFeature.place()");
                return false;
            }
            WorldDataHelper.StructureLocationsData locationsData = WorldDataHelper.structureLocations(serverLevel);
            List<BlockPos> villageLocations = locationsData.getLocations();
            if (villageLocations.isEmpty()) {
                return false;
            }
            this.tryFindNewStructureConnection(villageLocations, serverLevel);
            HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
            this.runRoadLogic(level, context, roadDecorationCache);
            RoadStructures.tryPlaceDecorations(roadDecorationCache);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error in RoadFeature.place(): {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private void tryFindNewStructureConnection(List<BlockPos> villageLocations, ServerLevel serverWorld) {
        if (++chunksForLocatingCounter > 300) {
            WorldDataHelper.StructureConnectionsData connectionsData = WorldDataHelper.structureConnections(serverWorld);
            serverWorld.m_7654_().execute(() -> StructureConnector.cacheNewConnection(serverWorld, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(WorldGenLevel level, FeaturePlaceContext<RoadFeatureConfig> context, Set<Decoration> decorationPositions) {
        try {
            ServerLevel serverLevel;
            int averagingRadius = ModConfig.averagingRadius;
            if (level instanceof ServerLevel) {
                ServerLevel sl;
                serverLevel = sl = (ServerLevel)level;
            } else {
                try {
                    serverLevel = level.m_6018_();
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot get ServerLevel in runRoadLogic: {}", (Object)e.getMessage());
                    return;
                }
            }
            if (serverLevel == null) {
                LOGGER.warn("ServerLevel is null in runRoadLogic");
                return;
            }
            WorldDataHelper.RoadDataStorage roadDataStorage = WorldDataHelper.roadData(serverLevel);
            List<Records.RoadData> roadDataList = roadDataStorage.getRoadData();
            if (roadDataList.isEmpty()) {
                return;
            }
            ChunkPos currentChunkPos = new ChunkPos(context.m_159777_());
            RandomSource random = context.m_225041_();
            HashSet<BlockPos> occupied = new HashSet<BlockPos>();
            for (Records.RoadData data : roadDataList) {
                int roadType = data.roadType();
                List<BlockState> materials = data.materials();
                List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
                List<BlockPos> middles = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
                int segmentIndex = 0;
                for (int i = 2; i < segments.size() - 2; ++i) {
                    ChunkPos middleChunk;
                    BlockPos mid = middles.get(i);
                    if (occupied.contains(mid) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new ChunkPos(mid)).equals((Object)currentChunkPos)) continue;
                    Records.RoadSegmentPlacement segment = segments.get(i);
                    BlockPos prev = middles.get(i - 2);
                    BlockPos next = middles.get(i + 2);
                    ArrayList<Double> heights = new ArrayList<Double>();
                    for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                        if (j < 0 || j >= middles.size()) continue;
                        BlockPos sample = middles.get(j);
                        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, sample.m_123341_(), sample.m_123343_());
                        heights.add(Double.valueOf(y));
                    }
                    int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(mid.m_123342_()));
                    BlockPos averagedPos = new BlockPos(mid.m_123341_(), averageY, mid.m_123343_());
                    if (!ModConfig.placeWaypoints) {
                        for (BlockPos widthPos : segment.positions()) {
                            BlockPos corrected = new BlockPos(widthPos.m_123341_(), averageY, widthPos.m_123343_());
                            this.placeOnSurface(level, corrected, materials, roadType, random);
                        }
                    }
                    this.addDecoration(level, decorationPositions, averagedPos, segmentIndex, next, prev, middles, roadType, random);
                    occupied.add(mid);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in runRoadLogic: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addDecoration(WorldGenLevel level, Set<Decoration> decorationPositions, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middlePositions, int roadType, RandomSource random) {
        boolean isEnd;
        int dz;
        int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, placePos.m_123341_(), placePos.m_123343_());
        BlockPos surfacePos = new BlockPos(placePos.m_123341_(), surfaceY, placePos.m_123343_());
        if (ModConfig.placeWaypoints) {
            if (segmentIndex % 25 == 0) {
                decorationPositions.add(new FenceWaypointDecoration(surfacePos, level));
            }
            return;
        }
        int dx = nextPos.m_123341_() - prevPos.m_123341_();
        double length = Math.sqrt(dx * dx + (dz = nextPos.m_123343_() - prevPos.m_123343_()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        Vec3i directionVector = new Vec3i(normDx, 0, normDz);
        Vec3i orthogonalVector = new Vec3i(-directionVector.m_123343_(), 0, directionVector.m_123341_());
        boolean bl = isEnd = segmentIndex != middlePositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middlePositions.size() - 65) {
            BlockPos shiftedPos = isEnd ? placePos.m_121955_(orthogonalVector.m_142393_(2)) : placePos.m_121955_(orthogonalVector.m_142393_(-2));
            decorationPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, level, isEnd, String.valueOf(middlePositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftSide = random.m_188499_();
            BlockPos shiftedPos = leftSide ? placePos.m_121955_(orthogonalVector.m_142393_(2)) : placePos.m_121955_(orthogonalVector.m_142393_(-2));
            if (Math.abs((shiftedPos = this.withSurfaceY(level, shiftedPos)).m_123342_() - placePos.m_123342_()) > 1) {
                return;
            }
            if (roadType == 0) {
                decorationPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, level, leftSide));
            } else {
                decorationPositions.add(new FenceWaypointDecoration(shiftedPos, level));
            }
        } else if (ModConfig.placeRoadFences && segmentIndex % 15 == 0) {
            boolean leftSide = random.m_188499_();
            BlockPos shiftedPos = leftSide ? placePos.m_121955_(orthogonalVector.m_142393_(2)) : placePos.m_121955_(orthogonalVector.m_142393_(-2));
            if (Math.abs((shiftedPos = this.withSurfaceY(level, shiftedPos)).m_123342_() - placePos.m_123342_()) > 1) {
                return;
            }
            int fenceLength = random.m_216332_(1, 3);
            decorationPositions.add(new RoadFenceDecoration(shiftedPos, orthogonalVector, level, leftSide, fenceLength));
        } else if (segmentIndex % 80 == 0) {
            ArrayList<String> structures = new ArrayList<String>();
            if (ModConfig.placeSwings) {
                structures.add("swing");
            }
            if (ModConfig.placeBenches) {
                structures.add("bench");
            }
            if (ModConfig.placeGloriettes) {
                structures.add("gloriette");
            }
            if (structures.isEmpty()) {
                return;
            }
            String selected = (String)structures.get(random.m_188503_(structures.size()));
            boolean leftSide = random.m_188499_();
            BlockPos shiftedPos = leftSide ? placePos.m_121955_(orthogonalVector.m_142393_(ModConfig.structureDistanceFromRoad)) : placePos.m_121955_(orthogonalVector.m_142393_(-ModConfig.structureDistanceFromRoad));
            if (Math.abs((shiftedPos = this.withSurfaceY(level, shiftedPos)).m_123342_() - placePos.m_123342_()) > 1) {
                return;
            }
            switch (selected) {
                case "swing": {
                    decorationPositions.add(new SwingDecoration(shiftedPos, orthogonalVector, level));
                    break;
                }
                case "bench": {
                    decorationPositions.add(new NbtStructureDecoration(shiftedPos, orthogonalVector, level, "bench", new Vec3i(3, 3, 3)));
                    break;
                }
                case "gloriette": {
                    decorationPositions.add(new NbtStructureDecoration(shiftedPos, orthogonalVector, level, "gloriette", new Vec3i(5, 5, 5)));
                }
            }
        }
    }

    private BlockPos withSurfaceY(WorldGenLevel level, BlockPos pos) {
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        return new BlockPos(pos.m_123341_(), y, pos.m_123343_());
    }

    private void placeOnSurface(WorldGenLevel level, BlockPos placePos, List<BlockState> material, int roadType, RandomSource random) {
        BlockPos topPos;
        BlockState belowState;
        double naturalBlockChance = 0.5;
        BlockPos surfacePos = placePos;
        if (roadType == 1 || ModConfig.averagingRadius == 0) {
            surfacePos = this.withSurfaceY(level, placePos);
        }
        if ((belowState = level.m_8055_((topPos = this.withSurfaceY(level, surfacePos)).m_7495_())).m_60713_(Blocks.f_49990_)) {
            level.m_7731_(topPos, (BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (roadType == 0 || random.m_188500_() < naturalBlockChance) {
            this.placeRoadBlock(level, belowState, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(WorldGenLevel level, BlockState blockStateAtPos, BlockPos surfacePos, List<BlockState> materials, RandomSource random) {
        BlockPos abovePos;
        BlockState aboveState;
        boolean sturdyBelow = level.m_8055_(surfacePos.m_7495_()).m_60783_((BlockGetter)level, surfacePos.m_7495_(), Direction.UP);
        boolean sturdyBelow2 = level.m_8055_(surfacePos.m_6625_(2)).m_60783_((BlockGetter)level, surfacePos.m_6625_(2), Direction.UP);
        if (!this.placeAllowedCheck(blockStateAtPos.m_60734_()) || !sturdyBelow && !sturdyBelow2) {
            return;
        }
        BlockState material = materials.get(random.m_188503_(materials.size()));
        this.setBlockState(level, surfacePos.m_7495_(), material);
        for (int i = 0; !(i >= 3 || (aboveState = level.m_8055_(abovePos = surfacePos.m_6630_(i))).m_60795_() || aboveState.m_204336_(BlockTags.f_13106_) || aboveState.m_204336_(BlockTags.f_13039_)); ++i) {
            this.setBlockState(level, abovePos, Blocks.f_50016_.m_49966_());
        }
        BlockPos belowPos = surfacePos.m_6625_(2);
        BlockState belowState = level.m_8055_(belowPos);
        if (belowState.m_60713_(Blocks.f_50440_)) {
            this.setBlockState(level, belowPos, Blocks.f_50493_.m_49966_());
        }
    }

    private boolean placeAllowedCheck(Block blockToCheck) {
        return !DONT_PLACE_HERE.contains(blockToCheck) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13035_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13106_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13050_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13098_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13090_);
    }

    private void setBlockState(WorldGenLevel level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, state, 3);
    }

    static {
        DONT_PLACE_HERE.add(Blocks.f_50354_);
        DONT_PLACE_HERE.add(Blocks.f_50126_);
        DONT_PLACE_HERE.add(Blocks.f_50568_);
        DONT_PLACE_HERE.add(Blocks.f_50038_);
        DONT_PLACE_HERE.add(Blocks.f_220833_);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_PLACED_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("roadweaver", "road_feature_placed"));
        ROAD_FEATURE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("roadweaver", "road_feature"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

