/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isEnd;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, Boolean isEnd, String distanceText) {
        super(pos, direction, world);
        this.isEnd = isEnd;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isEnd);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos signPos = basePos.m_6630_(2).m_121945_(props.offsetDirection.m_122424_());
        this.setBlock(signPos, (BlockState)((BlockState)this.wood.hangingSign().m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(true)));
        this.updateSignText(world, signPos);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        this.setBlock(pos.m_6630_(3).m_121945_(props.offsetDirection.m_122424_()), (BlockState)this.wood.fence().m_49966_().m_61124_(props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)));
        this.setBlock(pos.m_6630_(0), this.wood.fence().m_49966_());
        this.setBlock(pos.m_6630_(1), this.wood.fence().m_49966_());
        this.setBlock(pos.m_6630_(2), this.wood.fence().m_49966_());
        this.setBlock(pos.m_6630_(3), (BlockState)this.wood.fence().m_49966_().m_61124_(props.directionProperty, (Comparable)Boolean.valueOf(true)));
    }

    private void updateSignText(WorldGenLevel world, BlockPos signPos) {
        Block block = world.m_8055_(signPos).m_60734_();
        if (!block.m_5456_().toString().contains("hanging_sign") && !block.m_7705_().contains("hanging_sign")) {
            return;
        }
        if (world.m_7654_() != null) {
            world.m_7654_().execute(() -> {
                BlockEntity blockEntity = world.m_7702_(signPos);
                if (blockEntity instanceof HangingSignBlockEntity) {
                    HangingSignBlockEntity hangingSign = (HangingSignBlockEntity)blockEntity;
                    SignText frontText = hangingSign.m_277157_(true);
                    frontText = frontText.m_276913_(0, (Component)Component.m_237113_((String)"----------"));
                    frontText = frontText.m_276913_(1, (Component)Component.m_237113_((String)"Next Village"));
                    frontText = frontText.m_276913_(2, (Component)Component.m_237113_((String)(this.signText + "m")));
                    frontText = frontText.m_276913_(3, (Component)Component.m_237113_((String)"----------"));
                    hangingSign.m_276956_(frontText, true);
                    SignText backText = hangingSign.m_277157_(false);
                    backText = backText.m_276913_(0, (Component)Component.m_237113_((String)"----------"));
                    backText = backText.m_276913_(1, (Component)Component.m_237113_((String)"Welcome"));
                    backText = backText.m_276913_(2, (Component)Component.m_237113_((String)"Traveller"));
                    backText = backText.m_276913_(3, (Component)Component.m_237113_((String)"----------"));
                    hangingSign.m_276956_(backText, false);
                    hangingSign.m_6596_();
                }
            });
        }
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

