/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.io.InputStream;
import java.util.List;
import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructureDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadWeaver");
    protected Records.WoodAssets wood;
    private final String structureName;
    private final Vec3i structureSize;

    public StructureDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, String structureName, Vec3i structureSize) {
        super(pos, direction, world);
        this.structureName = structureName;
        this.structureSize = structureSize;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        if (!this.hasEnoughSpace()) {
            return;
        }
        StructureTemplate template = this.loadStructureTemplate();
        if (template != null) {
            this.placeStructure(template);
        } else {
            this.placeFallbackStructure();
        }
    }

    protected boolean hasEnoughSpace() {
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int x = 0; x < this.structureSize.m_123341_(); ++x) {
            for (int z = 0; z < this.structureSize.m_123343_(); ++z) {
                BlockPos checkPos = basePos.m_7918_(x, 0, z);
                int groundY = this.getSurfaceY(checkPos.m_123341_(), checkPos.m_123343_());
                minY = Math.min(minY, groundY);
                maxY = Math.max(maxY, groundY);
            }
        }
        return maxY - minY <= 2;
    }

    protected StructureTemplate loadStructureTemplate() {
        try {
            ResourceLocation structureId = new ResourceLocation("roadweaver", "structures/" + this.structureName);
            StructureTemplate template = new StructureTemplate();
            String path = "/assets/roadweaver/structures/" + this.structureName + ".nbt";
            InputStream inputStream = this.getClass().getResourceAsStream(path);
            if (inputStream != null) {
                CompoundTag nbt = NbtIo.m_128939_((InputStream)inputStream);
                template.m_246595_((HolderGetter)this.getWorld().m_6018_().m_9598_().m_255025_(ForgeRegistries.Keys.BLOCKS), nbt);
                return template;
            }
            String dataPath = "/data/roadweaver/structures/" + this.structureName + ".nbt";
            inputStream = this.getClass().getResourceAsStream(dataPath);
            if (inputStream != null) {
                CompoundTag nbt = NbtIo.m_128939_((InputStream)inputStream);
                template.m_246595_((HolderGetter)this.getWorld().m_6018_().m_9598_().m_255025_(ForgeRegistries.Keys.BLOCKS), nbt);
                return template;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load structure: " + this.structureName + ", using fallback. Error: " + e.getMessage());
        }
        return null;
    }

    protected void placeStructure(StructureTemplate template) {
        BlockPos placePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos groundLevel = this.findGroundLevel(placePos, world);
        StructurePlaceSettings placementData = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(this.getRotationFromDirection()).m_74392_(true);
        template.m_230328_((ServerLevelAccessor)world, groundLevel, groundLevel, placementData, world.m_213780_(), 2);
        this.cleanupAirBlocks(template, groundLevel, placementData);
    }

    protected BlockPos findGroundLevel(BlockPos basePos, WorldGenLevel world) {
        int minY = Integer.MAX_VALUE;
        Vec3i size = this.structureSize;
        for (int x = 0; x < size.m_123341_(); ++x) {
            for (int z = 0; z < size.m_123343_(); ++z) {
                BlockPos checkPos = basePos.m_7918_(x - size.m_123341_() / 2, 0, z - size.m_123343_() / 2);
                int groundY = this.getSurfaceY(checkPos.m_123341_(), checkPos.m_123343_());
                minY = Math.min(minY, groundY);
            }
        }
        return new BlockPos(basePos.m_123341_(), minY - 1, basePos.m_123343_());
    }

    protected void cleanupAirBlocks(StructureTemplate template, BlockPos basePos, StructurePlaceSettings placementData) {
        List blocks = template.m_74603_(basePos, placementData, Blocks.f_50016_);
        for (StructureTemplate.StructureBlockInfo blockInfo : blocks) {
            BlockPos airPos = new BlockPos((Vec3i)blockInfo.f_74675_());
            BlockState currentState = this.getWorld().m_8055_(airPos);
            if (!this.shouldReplaceWithAir(currentState)) continue;
            this.setBlock(airPos, Blocks.f_50016_.m_49966_());
        }
    }

    protected boolean shouldReplaceWithAir(BlockState state) {
        return state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13104_);
    }

    protected Rotation getRotationFromDirection() {
        Vec3i roadDirection = this.getRoadDirection();
        if (Math.abs(roadDirection.m_123341_()) > Math.abs(roadDirection.m_123343_())) {
            return roadDirection.m_123341_() > 0 ? Rotation.NONE : Rotation.CLOCKWISE_180;
        }
        return roadDirection.m_123343_() > 0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    protected Vec3i getRoadDirection() {
        Vec3i orthogonal = this.getOrthogonalVector();
        return new Vec3i(-orthogonal.m_123343_(), 0, orthogonal.m_123341_());
    }

    protected abstract void placeFallbackStructure();

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }

    public Vec3i getStructureSize() {
        return this.structureSize;
    }
}

