/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration.util;

import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodSelector {
    public static Records.WoodAssets forBiome(WorldGenLevel world, BlockPos pos) {
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        ResourceKey biomeKey = world.m_204166_(pos).m_203543_().orElse(null);
        if (biomeKey != null) {
            if (biomeKey == Biomes.f_48197_) {
                return new Records.WoodAssets(Blocks.f_244641_, Blocks.f_244091_, Blocks.f_244477_);
            }
            if (WoodSelector.isBiomeTagged(biome, "is_jungle")) {
                return new Records.WoodAssets(Blocks.f_50481_, Blocks.f_244263_, Blocks.f_50743_);
            }
            if (WoodSelector.isBiomeTagged(biome, "is_savanna")) {
                return new Records.WoodAssets(Blocks.f_50482_, Blocks.f_243716_, Blocks.f_50744_);
            }
            if (biomeKey == Biomes.f_48151_) {
                return new Records.WoodAssets(Blocks.f_50483_, Blocks.f_243960_, Blocks.f_50745_);
            }
            if (biomeKey == Biomes.f_271432_) {
                return new Records.WoodAssets(Blocks.f_271219_, Blocks.f_271116_, Blocks.f_271304_);
            }
            if (biomeKey == Biomes.f_48149_ || biomeKey == Biomes.f_186762_) {
                return new Records.WoodAssets(Blocks.f_50480_, Blocks.f_243890_, Blocks.f_50742_);
            }
            if (WoodSelector.isBiomeTagged(biome, "is_taiga")) {
                return new Records.WoodAssets(Blocks.f_50479_, Blocks.f_244633_, Blocks.f_50741_);
            }
            return new Records.WoodAssets(Blocks.f_50132_, Blocks.f_244319_, Blocks.f_50705_);
        }
        return new Records.WoodAssets(Blocks.f_50132_, Blocks.f_244319_, Blocks.f_50705_);
    }

    private static boolean isBiomeTagged(Biome biome, String tag) {
        ResourceLocation biomeResLoc = ForgeRegistries.BIOMES.getKey((Object)biome);
        if (biomeResLoc == null) {
            return false;
        }
        String biomePath = biomeResLoc.m_135815_();
        switch (tag) {
            case "is_jungle": {
                return biomePath.contains("jungle");
            }
            case "is_savanna": {
                return biomePath.contains("savanna") || biomePath.contains("plains");
            }
            case "is_taiga": {
                return biomePath.contains("taiga") || biomePath.contains("grove");
            }
        }
        return false;
    }
}

