/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Records {

    public static enum ConnectionStatus {
        PLANNED,
        GENERATING,
        COMPLETED,
        FAILED;

    }

    public record StructureConnection(BlockPos from, BlockPos to, ConnectionStatus status) {
        public static final Codec<StructureConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("from").forGetter(StructureConnection::from), (App)BlockPos.f_121852_.fieldOf("to").forGetter(StructureConnection::to), (App)Codec.STRING.optionalFieldOf("status", (Object)"PLANNED").xmap(ConnectionStatus::valueOf, Enum::name).forGetter(StructureConnection::status)).apply((Applicative)instance, StructureConnection::new));

        public StructureConnection(BlockPos from, BlockPos to) {
            this(from, to, ConnectionStatus.PLANNED);
        }
    }

    public record StructureLocationData(List<BlockPos> structureLocations) {
        public static final Codec<StructureLocationData> CODEC = BlockPos.f_121852_.listOf().xmap(StructureLocationData::new, StructureLocationData::structureLocations);

        public StructureLocationData(List<BlockPos> structureLocations) {
            this.structureLocations = new ArrayList<BlockPos>(structureLocations);
        }

        public void addStructure(BlockPos pos) {
            this.structureLocations.add(pos);
        }
    }

    public record RoadSegmentPlacement(BlockPos middlePos, List<BlockPos> positions) {
        public static final Codec<RoadSegmentPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("middle_pos").forGetter(RoadSegmentPlacement::middlePos), (App)BlockPos.f_121852_.listOf().fieldOf("positions").forGetter(RoadSegmentPlacement::positions)).apply((Applicative)instance, RoadSegmentPlacement::new));
    }

    public record RoadData(int width, int roadType, List<BlockState> materials, List<RoadSegmentPlacement> roadSegmentList) {
        public static final Codec<RoadData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(RoadData::width), (App)Codec.INT.fieldOf("road_type").forGetter(RoadData::roadType), (App)BlockState.f_61039_.listOf().fieldOf("materials").forGetter(RoadData::materials), (App)RoadSegmentPlacement.CODEC.listOf().fieldOf("placements").forGetter(RoadData::roadSegmentList)).apply((Applicative)instance, RoadData::new));
    }

    public record RoadDecoration(BlockPos placePos, Vec3i vector, int centerBlockCount, String signText, boolean isStart) {
    }

    public record WoodAssets(Block fence, Block hangingSign, Block planks) {
    }
}

