/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureLocator;
import net.countered.settlementroads.persistence.attachments.WorldDataHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    public static Queue<Records.StructureConnection> cachedStructureConnections = new ArrayDeque<Records.StructureConnection>();

    public static void cacheNewConnection(ServerLevel serverWorld, boolean locateAtPlayer) {
        StructureLocator.locateConfiguredStructure(serverWorld, 1, locateAtPlayer);
        WorldDataHelper.StructureLocationsData locationsData = WorldDataHelper.structureLocations(serverWorld);
        List<BlockPos> villagePosList = locationsData.getLocations();
        if (villagePosList == null || villagePosList.size() < 2) {
            return;
        }
        StructureConnector.createNewStructureConnection(serverWorld);
    }

    private static void createNewStructureConnection(ServerLevel serverWorld) {
        WorldDataHelper.StructureConnectionsData connectionsData;
        ArrayList<Records.StructureConnection> connections;
        List<BlockPos> worldStructureLocations;
        WorldDataHelper.StructureLocationsData locationsData = WorldDataHelper.structureLocations(serverWorld);
        List<BlockPos> villagePosList = locationsData.getLocations();
        BlockPos latestVillagePos = villagePosList.get(villagePosList.size() - 1);
        BlockPos closestVillage = StructureConnector.findClosestStructure(latestVillagePos, worldStructureLocations = locationsData.getLocations());
        if (closestVillage != null && !StructureConnector.connectionExists(connections = new ArrayList<Records.StructureConnection>((connectionsData = WorldDataHelper.structureConnections(serverWorld)).getConnections()), latestVillagePos, closestVillage)) {
            Records.StructureConnection structureConnection = new Records.StructureConnection(latestVillagePos, closestVillage);
            connections.add(structureConnection);
            connectionsData.setConnections(connections);
            cachedStructureConnections.add(structureConnection);
            LOGGER.debug("Created connection between {} and {} (distance: {} blocks)", new Object[]{latestVillagePos, closestVillage, Math.sqrt(latestVillagePos.m_123331_((Vec3i)closestVillage))});
        }
    }

    private static boolean connectionExists(List<Records.StructureConnection> existingConnections, BlockPos a, BlockPos b) {
        for (Records.StructureConnection connection : existingConnections) {
            if ((!connection.from().equals((Object)a) || !connection.to().equals((Object)b)) && (!connection.to().equals((Object)b) || !connection.from().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findClosestStructure(BlockPos currentVillage, List<BlockPos> allVillages) {
        BlockPos closestVillage = null;
        double minDistance = Double.MAX_VALUE;
        for (BlockPos village : allVillages) {
            double distance;
            if (village.equals((Object)currentVillage) || !((distance = currentVillage.m_123331_((Vec3i)village)) < minDistance)) continue;
            minDistance = distance;
            closestVillage = village;
        }
        return closestVillage;
    }
}

