/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.persistence.attachments.WorldDataHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public static void locateConfiguredStructure(ServerLevel serverWorld, int locateCount, boolean locateAtPlayer) {
        LOGGER.debug("Locating " + locateCount + " " + ModConfig.structureToLocate);
        HolderSet<Structure> targets = StructureLocator.resolveTargets(serverWorld);
        if (targets == null) {
            return;
        }
        for (int x = 0; x < locateCount; ++x) {
            if (locateAtPlayer) {
                for (ServerPlayer player : serverWorld.m_6907_()) {
                    StructureLocator.executeLocateStructure(player.m_20183_(), serverWorld, targets);
                }
                continue;
            }
            StructureLocator.executeLocateStructure(serverWorld.m_220360_(), serverWorld, targets);
        }
    }

    private static void executeLocateStructure(BlockPos locatePos, ServerLevel serverWorld, HolderSet<Structure> targets) {
        Pair pair = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, targets, locatePos, ModConfig.structureSearchRadius, true);
        if (pair == null) {
            LOGGER.debug("No structure found for {} near {}", (Object)ModConfig.structureToLocate, (Object)locatePos);
            return;
        }
        BlockPos structureLocation = (BlockPos)pair.getFirst();
        LOGGER.debug("Structure found at {}", (Object)structureLocation);
        WorldDataHelper.StructureLocationsData data = WorldDataHelper.structureLocations(serverWorld);
        data.add(structureLocation);
    }

    private static HolderSet<Structure> resolveTargets(ServerLevel level) {
        String id = ModConfig.structureToLocate.trim();
        if (id.isEmpty()) {
            LOGGER.warn("Structure selector in config is empty");
            return null;
        }
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        if (id.startsWith("#")) {
            ResourceLocation tagId = ResourceLocation.m_135820_((String)id.substring(1));
            if (tagId == null) {
                LOGGER.warn("Invalid structure tag identifier: {}", (Object)id);
                return null;
            }
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)tagId);
            Optional holders = registry.m_203431_(tagKey);
            if (holders.isEmpty()) {
                LOGGER.warn("Structure tag {} not found", (Object)tagId);
                return null;
            }
            return (HolderSet)holders.get();
        }
        ResourceLocation keyId = ResourceLocation.m_135820_((String)id);
        if (keyId == null) {
            LOGGER.warn("Invalid structure identifier: {}", (Object)id);
            return null;
        }
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)keyId);
        Optional holder = registry.m_203636_(structureKey);
        if (holder.isEmpty()) {
            LOGGER.warn("Structure {} not found", (Object)keyId);
            return null;
        }
        return HolderSet.m_205809_((Holder[])new Holder[]{(Holder)holder.get()});
    }
}

