/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.persistence.attachments;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorldDataHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    private WorldDataHelper() {
    }

    public static StructureLocationsData structureLocations(ServerLevel level) {
        return StructureLocationsData.get(level);
    }

    public static StructureConnectionsData structureConnections(ServerLevel level) {
        return StructureConnectionsData.get(level);
    }

    public static RoadDataStorage roadData(ServerLevel level) {
        return RoadDataStorage.get(level);
    }

    private static <T> void encodeList(CompoundTag tag, String key, Codec<List<T>> codec, List<T> value) {
        codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).resultOrPartial(message -> LOGGER.error("Failed to encode {} for {}: {}", new Object[]{key, "roadweaver", message})).ifPresent(encodedTag -> {
            if (encodedTag instanceof ListTag) {
                ListTag listTag = (ListTag)encodedTag;
                tag.m_128365_(key, (Tag)listTag);
            } else {
                LOGGER.error("Encoded tag for {} is not ListTag ({}).", (Object)key, (Object)encodedTag.getClass());
            }
        });
    }

    private static <T> List<T> decodeList(CompoundTag tag, String key, Codec<List<T>> codec) {
        if (!tag.m_128425_(key, 9)) {
            return new ArrayList();
        }
        return codec.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(key)).resultOrPartial(message -> LOGGER.error("Failed to decode {} for {}: {}", new Object[]{key, "roadweaver", message})).orElseGet(ArrayList::new);
    }

    public static class StructureLocationsData
    extends SavedData {
        private static final String STORAGE_KEY = "roadweaver_structure_locations";
        private static final String TAG_LOCATIONS = "locations";
        private static final Codec<List<BlockPos>> LOCATIONS_CODEC = BlockPos.f_121852_.listOf();
        private final List<BlockPos> locations = new ArrayList<BlockPos>();

        private StructureLocationsData() {
        }

        private StructureLocationsData(List<BlockPos> stored) {
            this.locations.addAll(stored);
        }

        public static StructureLocationsData get(ServerLevel level) {
            DimensionDataStorage storage = level.m_8895_();
            return (StructureLocationsData)storage.m_164861_(StructureLocationsData::load, StructureLocationsData::new, STORAGE_KEY);
        }

        private static StructureLocationsData load(CompoundTag tag) {
            return new StructureLocationsData(WorldDataHelper.decodeList(tag, TAG_LOCATIONS, LOCATIONS_CODEC));
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            WorldDataHelper.encodeList(tag, TAG_LOCATIONS, LOCATIONS_CODEC, this.locations);
            return tag;
        }

        public List<BlockPos> getLocations() {
            return this.locations;
        }

        public void add(BlockPos pos) {
            this.locations.add(pos);
            this.m_77762_();
        }

        public void setLocations(List<BlockPos> newLocations) {
            this.locations.clear();
            this.locations.addAll(newLocations);
            this.m_77762_();
        }
    }

    public static class StructureConnectionsData
    extends SavedData {
        private static final String STORAGE_KEY = "roadweaver_structure_connections";
        private static final String TAG_CONNECTIONS = "connections";
        private static final Codec<List<Records.StructureConnection>> CONNECTION_CODEC = Records.StructureConnection.CODEC.listOf();
        private final List<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>();

        private StructureConnectionsData() {
        }

        private StructureConnectionsData(List<Records.StructureConnection> stored) {
            this.connections.addAll(stored);
        }

        public static StructureConnectionsData get(ServerLevel level) {
            DimensionDataStorage storage = level.m_8895_();
            return (StructureConnectionsData)storage.m_164861_(StructureConnectionsData::load, StructureConnectionsData::new, STORAGE_KEY);
        }

        private static StructureConnectionsData load(CompoundTag tag) {
            return new StructureConnectionsData(WorldDataHelper.decodeList(tag, TAG_CONNECTIONS, CONNECTION_CODEC));
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            WorldDataHelper.encodeList(tag, TAG_CONNECTIONS, CONNECTION_CODEC, this.connections);
            return tag;
        }

        public List<Records.StructureConnection> getConnections() {
            return this.connections;
        }

        public void setConnections(List<Records.StructureConnection> newConnections) {
            this.connections.clear();
            this.connections.addAll(newConnections);
            this.m_77762_();
        }

        public void addConnection(Records.StructureConnection connection) {
            this.connections.add(connection);
            this.m_77762_();
        }
    }

    public static class RoadDataStorage
    extends SavedData {
        private static final String STORAGE_KEY = "roadweaver_road_data";
        private static final String TAG_ROADS = "roads";
        private static final Codec<List<Records.RoadData>> ROAD_CODEC = Records.RoadData.CODEC.listOf();
        private final List<Records.RoadData> roadData = new ArrayList<Records.RoadData>();

        private RoadDataStorage() {
        }

        private RoadDataStorage(List<Records.RoadData> stored) {
            this.roadData.addAll(stored);
        }

        public static RoadDataStorage get(ServerLevel level) {
            DimensionDataStorage storage = level.m_8895_();
            return (RoadDataStorage)storage.m_164861_(RoadDataStorage::load, RoadDataStorage::new, STORAGE_KEY);
        }

        private static RoadDataStorage load(CompoundTag tag) {
            return new RoadDataStorage(WorldDataHelper.decodeList(tag, TAG_ROADS, ROAD_CODEC));
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            WorldDataHelper.encodeList(tag, TAG_ROADS, ROAD_CODEC, this.roadData);
            return tag;
        }

        public List<Records.RoadData> getRoadData() {
            return this.roadData;
        }

        public void setRoadData(List<Records.RoadData> newData) {
            this.roadData.clear();
            this.roadData.addAll(newData);
            this.m_77762_();
        }

        public void addRoad(Records.RoadData data) {
            this.roadData.add(data);
            this.m_77762_();
        }
    }
}

