/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.bridge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.system.AboveColumnClearer;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeBuilder {
    private static final BlockState DECK = Blocks.f_50222_.m_49966_();
    private static final BlockState PIER = Blocks.f_50222_.m_49966_();

    private BridgeBuilder() {
    }

    public static void placeSegment(WorldGenLevel world, Records.RoadSegmentPlacement seg, BlockPos middle, BlockPos prev, BlockPos next, int roadWidth, int deckY, int segmentIndex, RandomSource random, ModConfig cfg, boolean placePier, boolean placeRail) {
        int interval;
        for (BlockPos widthPos : seg.positions()) {
            BlockPos deckPos = new BlockPos(widthPos.m_123341_(), deckY, widthPos.m_123343_());
            world.m_7731_(deckPos, DECK, 3);
            AboveColumnClearer.clearAboveColumn(world, deckPos.m_7494_(), cfg);
        }
        if (placePier && segmentIndex % (interval = Math.max(3, cfg.bridgePierInterval())) == 0) {
            BridgeBuilder.placePierUnder(world, middle.m_123341_(), middle.m_123343_(), deckY - 1, cfg.bridgePierMaxHeight(), cfg.bridgePierWidth());
        }
    }

    private static void placePierUnder(WorldGenLevel world, int x, int z, int fromY, int maxHeight, int pierWidth) {
        int minY = world.m_141937_();
        int half = Math.max(0, pierWidth - 1);
        for (int dx = -half; dx <= half; ++dx) {
            for (int dz = -half; dz <= half; ++dz) {
                BlockPos cur;
                int y = fromY;
                for (int h = 0; y >= minY && h < maxHeight && !world.m_8055_(cur = new BlockPos(x + dx, y, z + dz)).m_60783_((BlockGetter)world, cur, Direction.UP); --y, ++h) {
                    world.m_7731_(cur, PIER, 3);
                }
            }
        }
    }
}

