/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.shiroha233.roadweaver.features.decoration.base.Decoration;

public abstract class OrientedDecoration
extends Decoration {
    private final Vec3i orthogonalVector;

    public OrientedDecoration(BlockPos placePos, Vec3i orthogonalVector, WorldGenLevel world) {
        super(placePos, world);
        this.orthogonalVector = orthogonalVector;
    }

    protected final int getCardinalRotationFromVector(Vec3i vec, boolean start) {
        if (start) {
            if (Math.abs(vec.m_123341_()) > Math.abs(vec.m_123343_())) {
                return vec.m_123341_() > 0 ? 0 : 8;
            }
            return vec.m_123343_() > 0 ? 4 : 12;
        }
        if (Math.abs(vec.m_123341_()) > Math.abs(vec.m_123343_())) {
            return vec.m_123341_() > 0 ? 8 : 0;
        }
        return vec.m_123343_() > 0 ? 12 : 4;
    }

    public Vec3i getOrthogonalVector() {
        return this.orthogonalVector;
    }

    protected DirectionProperties getDirectionProperties(int rotation) {
        return switch (rotation) {
            case 12 -> new DirectionProperties(Direction.NORTH, BlockStateProperties.f_61370_, BlockStateProperties.f_61368_);
            case 0 -> new DirectionProperties(Direction.EAST, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_);
            case 4 -> new DirectionProperties(Direction.SOUTH, BlockStateProperties.f_61368_, BlockStateProperties.f_61370_);
            default -> new DirectionProperties(Direction.WEST, BlockStateProperties.f_61369_, BlockStateProperties.f_61371_);
        };
    }

    public static class DirectionProperties {
        public final Direction offsetDirection;
        public final BooleanProperty reverseDirectionProperty;
        public final BooleanProperty directionProperty;

        public DirectionProperties(Direction offset, BooleanProperty reverse, BooleanProperty direction) {
            this.offsetDirection = offset;
            this.reverseDirectionProperty = reverse;
            this.directionProperty = direction;
        }
    }
}

