/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.bridge;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeRangeCalculator {
    private BridgeRangeCalculator() {
    }

    public static RangeResult compute(List<BlockPos> middlePositions, List<Records.RoadSpan> spans) {
        int n = middlePositions.size();
        boolean[] isBridge = new boolean[n];
        ArrayList<Object> bridgeRanges = new ArrayList<int[]>();
        if (spans != null) {
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < n; ++i) {
                indexMap.put(middlePositions.get(i).m_121878_(), i);
            }
            for (Records.RoadSpan sp : spans) {
                if (sp.type() != Records.SpanType.BRIDGE) continue;
                Integer si = (Integer)indexMap.get(sp.start().m_121878_());
                Integer ei = (Integer)indexMap.get(sp.end().m_121878_());
                if (si == null || ei == null) continue;
                int a = Math.max(0, Math.min(si, ei));
                int b = Math.min(n - 1, Math.max(si, ei));
                for (int k = a; k <= b; ++k) {
                    isBridge[k] = true;
                }
                bridgeRanges.add(new int[]{a, b});
            }
        }
        if (!bridgeRanges.isEmpty()) {
            bridgeRanges.sort(Comparator.comparingInt(o -> o[0]));
            ArrayList<int[]> merged = new ArrayList<int[]>();
            int[] cur = (int[])bridgeRanges.get(0);
            for (int idx = 1; idx < bridgeRanges.size(); ++idx) {
                int[] nxt = (int[])bridgeRanges.get(idx);
                if (nxt[0] <= cur[1] + 1) {
                    cur[1] = Math.max(cur[1], nxt[1]);
                    continue;
                }
                merged.add(cur);
                cur = nxt;
            }
            merged.add(cur);
            bridgeRanges = merged;
        }
        return new RangeResult(isBridge, bridgeRanges);
    }

    public record RangeResult(boolean[] isBridge, List<int[]> mergedRanges) {
    }
}

