/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

public final class PathPostProcessor {
    private PathPostProcessor() {
    }

    public static List<Records.RoadSegmentPlacement> process(List<BlockPos> rawPath, int width, ServerLevel level, TerrainSamplingCache cache) {
        if (rawPath == null || rawPath.size() < 2) {
            return new ArrayList<Records.RoadSegmentPlacement>();
        }
        List<BlockPos> controlPoints = PathPostProcessor.simplifyPath(rawPath);
        if (controlPoints.size() < 2) {
            return new ArrayList<Records.RoadSegmentPlacement>();
        }
        ArrayList<BlockPos> extendedPoints = new ArrayList<BlockPos>();
        extendedPoints.add(controlPoints.get(0));
        extendedPoints.addAll(controlPoints);
        extendedPoints.add(controlPoints.get(controlPoints.size() - 1));
        ArrayList<Vec2d> splinePoints = new ArrayList<Vec2d>();
        for (int i = 0; i < controlPoints.size() - 1; ++i) {
            BlockPos p0 = (BlockPos)extendedPoints.get(i);
            BlockPos p1 = (BlockPos)extendedPoints.get(i + 1);
            BlockPos p2 = (BlockPos)extendedPoints.get(i + 2);
            BlockPos p3 = (BlockPos)extendedPoints.get(i + 3);
            double dist = Math.sqrt(p1.m_123331_((Vec3i)p2));
            int steps = (int)Math.ceil(dist * 4.0);
            if (steps < 1) {
                steps = 1;
            }
            for (int s = 0; s < steps; ++s) {
                double t = (double)s / (double)steps;
                Vec2d pt = PathPostProcessor.catmullRomSplineDouble(p0, p1, p2, p3, t);
                splinePoints.add(pt);
            }
        }
        BlockPos lastBP = controlPoints.get(controlPoints.size() - 1);
        Vec2d lastPt = new Vec2d(lastBP.m_123341_(), lastBP.m_123343_());
        splinePoints.add(lastPt);
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>();
        ArrayList<Double> centerDists = new ArrayList<Double>();
        double currentDist = 0.0;
        double nextCenterDist = 0.0;
        for (int i = 0; i < splinePoints.size(); ++i) {
            Vec2d p = (Vec2d)splinePoints.get(i);
            if (i > 0) {
                currentDist += p.dist((Vec2d)splinePoints.get(i - 1));
            }
            if (!(currentDist >= nextCenterDist) && i != splinePoints.size() - 1) continue;
            int y = RoadPathCalculator.heightSampler(cache, (int)Math.round(p.x), (int)Math.round(p.z), level);
            BlockPos centerPos = new BlockPos((int)Math.round(p.x), y, (int)Math.round(p.z));
            if (!centers.isEmpty() && ((BlockPos)centers.get(centers.size() - 1)).equals((Object)centerPos)) continue;
            centers.add(centerPos);
            centerDists.add(currentDist);
            nextCenterDist = currentDist + 1.0;
        }
        HashMap segmentedBlocks = new HashMap();
        for (int i = 0; i < centers.size(); ++i) {
            segmentedBlocks.put(i, new HashSet());
        }
        double halfWidth = (double)width / 2.0;
        double halfWidthSq = halfWidth * halfWidth;
        double pathDist = 0.0;
        int currentCenterIdx = 0;
        for (int i = 0; i < splinePoints.size() - 1; ++i) {
            Vec2d pStart = (Vec2d)splinePoints.get(i);
            Vec2d pEnd = (Vec2d)splinePoints.get(i + 1);
            double segLen = pStart.dist(pEnd);
            pathDist += segLen;
            while (currentCenterIdx < centerDists.size() - 1 && (Double)centerDists.get(currentCenterIdx + 1) < pathDist) {
                ++currentCenterIdx;
            }
            int minX = (int)Math.floor(Math.min(pStart.x, pEnd.x) - halfWidth - 1.0);
            int maxX = (int)Math.ceil(Math.max(pStart.x, pEnd.x) + halfWidth + 1.0);
            int minZ = (int)Math.floor(Math.min(pStart.z, pEnd.z) - halfWidth - 1.0);
            int maxZ = (int)Math.ceil(Math.max(pStart.z, pEnd.z) + halfWidth + 1.0);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double dSq = PathPostProcessor.distToSegmentSq(x, z, pStart, pEnd);
                    if (!(dSq <= halfWidthSq)) continue;
                    BlockPos blockPos = new BlockPos(x, 0, z);
                    int bestIdx = currentCenterIdx;
                    double bestDistSq = Double.MAX_VALUE;
                    int searchStart = Math.max(0, currentCenterIdx - 5);
                    int searchEnd = Math.min(centers.size() - 1, currentCenterIdx + 5);
                    for (int k = searchStart; k <= searchEnd; ++k) {
                        double dz;
                        BlockPos c = (BlockPos)centers.get(k);
                        double dx = x - c.m_123341_();
                        double cDistSq = dx * dx + (dz = (double)(z - c.m_123343_())) * dz;
                        if (!(cDistSq < bestDistSq)) continue;
                        bestDistSq = cDistSq;
                        bestIdx = k;
                    }
                    ((Set)segmentedBlocks.get(bestIdx)).add(blockPos);
                }
            }
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (int i = 0; i < centers.size(); ++i) {
            BlockPos center = (BlockPos)centers.get(i);
            Set blocks = (Set)segmentedBlocks.get(i);
            if (blocks.isEmpty()) {
                blocks.add(new BlockPos(center.m_123341_(), 0, center.m_123343_()));
            }
            out.add(new Records.RoadSegmentPlacement(center, new ArrayList<BlockPos>(blocks)));
        }
        return out;
    }

    private static double distToSegmentSq(double px, double pz, Vec2d v, Vec2d w) {
        double l2 = v.distSqr(w);
        if (l2 == 0.0) {
            return (px - v.x) * (px - v.x) + (pz - v.z) * (pz - v.z);
        }
        double t = ((px - v.x) * (w.x - v.x) + (pz - v.z) * (w.z - v.z)) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        double projX = v.x + t * (w.x - v.x);
        double projZ = v.z + t * (w.z - v.z);
        return (px - projX) * (px - projX) + (pz - projZ) * (pz - projZ);
    }

    private static Vec2d catmullRomSplineDouble(BlockPos p0, BlockPos p1, BlockPos p2, BlockPos p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double f0 = -0.5 * t3 + t2 - 0.5 * t;
        double f1 = 1.5 * t3 - 2.5 * t2 + 1.0;
        double f2 = -1.5 * t3 + 2.0 * t2 + 0.5 * t;
        double f3 = 0.5 * t3 - 0.5 * t2;
        double x = (double)p0.m_123341_() * f0 + (double)p1.m_123341_() * f1 + (double)p2.m_123341_() * f2 + (double)p3.m_123341_() * f3;
        double z = (double)p0.m_123343_() * f0 + (double)p1.m_123343_() * f1 + (double)p2.m_123343_() * f2 + (double)p3.m_123343_() * f3;
        return new Vec2d(x, z);
    }

    private static List<BlockPos> simplifyPath(List<BlockPos> nodes) {
        if (nodes.size() < 3) {
            return new ArrayList<BlockPos>(nodes);
        }
        ArrayList<BlockPos> simplified = new ArrayList<BlockPos>();
        simplified.add(nodes.get(0));
        for (int i = 1; i < nodes.size() - 1; ++i) {
            BlockPos prev = (BlockPos)simplified.get(simplified.size() - 1);
            BlockPos curr = nodes.get(i);
            BlockPos next = nodes.get(i + 1);
            long dx1 = (long)curr.m_123341_() - (long)prev.m_123341_();
            long dz1 = (long)curr.m_123343_() - (long)prev.m_123343_();
            long dx2 = (long)next.m_123341_() - (long)curr.m_123341_();
            long dz2 = (long)next.m_123343_() - (long)curr.m_123343_();
            long crossProduct = dx1 * dz2 - dz1 * dx2;
            if (Math.abs(crossProduct) <= 16L) continue;
            simplified.add(curr);
        }
        simplified.add(nodes.get(nodes.size() - 1));
        return simplified;
    }

    private record Vec2d(double x, double z) {
        double dist(Vec2d o) {
            return Math.sqrt(this.distSqr(o));
        }

        double distSqr(Vec2d o) {
            return (this.x - o.x) * (this.x - o.x) + (this.z - o.z) * (this.z - o.z);
        }
    }
}

