/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.generation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.roadlogic.core.Road;
import net.shiroha233.roadweaver.generation.InitialGenManager;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.planning.PlanningUtils;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

public final class RoadGenerationService {
    private static final ConcurrentHashMap<ServerLevel, ConcurrentLinkedQueue<Records.StructureConnection>> QUEUES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServerLevel, ConcurrentHashMap<Long, Boolean>> PROCESSED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServerLevel, AtomicInteger> RUNNING_COUNT = new ConcurrentHashMap();
    private static final Set<Future<?>> ALL_RUNNING = ConcurrentHashMap.newKeySet();
    private static final ResourceLocation ROAD_CF_ID = new ResourceLocation("roadweaver", "road_feature");

    private RoadGenerationService() {
    }

    public static void onServerStopping() {
        ALL_RUNNING.forEach(f -> f.cancel(true));
        ALL_RUNNING.clear();
        QUEUES.clear();
        PROCESSED.clear();
        RUNNING_COUNT.clear();
        RoadPlanningService.resetAll();
    }

    public static void generateInline(ServerLevel level, Records.StructureConnection conn) {
        block12: {
            if (level == null || conn == null) {
                return;
            }
            WorldDataProvider provider = WorldDataProvider.getInstance();
            try {
                RoadFeatureConfig rfc;
                FeatureConfiguration featureConfiguration;
                RoadFeatureConfig cfg;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                List<Records.StructureConnection> origin0 = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all0 = origin0 != null ? new ArrayList<Records.StructureConnection>(origin0) : new ArrayList();
                for (int i = 0; i < all0.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all0.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all0.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.GENERATING));
                }
                if (!all0.isEmpty()) {
                    provider.setStructureConnections(level, all0);
                }
                InitialGenManager.update(level);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                Registry reg = level.m_9598_().m_175515_(Registries.f_256911_);
                ConfiguredFeature cf = (ConfiguredFeature)reg.m_7745_(ROAD_CF_ID);
                RoadFeatureConfig roadFeatureConfig = cfg = cf != null && (featureConfiguration = cf.f_65378_()) instanceof RoadFeatureConfig ? (rfc = (RoadFeatureConfig)featureConfiguration) : RoadGenerationService.defaultConfig();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                new Road(level, conn, cfg).generateRoad(ConfigService.get().aStarMaxSteps());
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                for (int i = 0; i < all.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                }
                provider.setStructureConnections(level, all);
                long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                if (proc != null) {
                    proc.remove(k);
                }
            }
            catch (Throwable t) {
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                for (int i = 0; i < all.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                }
                provider.setStructureConnections(level, all);
                long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                if (proc == null) break block12;
                proc.remove(k);
            }
        }
    }

    public static void onServerStarted() {
        ALL_RUNNING.clear();
        QUEUES.clear();
        PROCESSED.clear();
        RUNNING_COUNT.clear();
    }

    public static void tick(ServerLevel level) {
        Records.StructureConnection conn;
        RoadGenerationService.refreshQueue(level);
        ALL_RUNNING.removeIf(f -> f == null || f.isDone() || f.isCancelled());
        ConcurrentLinkedQueue q = QUEUES.computeIfAbsent(level, l -> new ConcurrentLinkedQueue());
        if (q.isEmpty()) {
            return;
        }
        int limit = Math.max(1, ConfigService.get().maxConcurrentGenerations());
        AtomicInteger cnt = RUNNING_COUNT.computeIfAbsent(level, l -> new AtomicInteger(0));
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
            if (p == null || p.m_284548_() != level) continue;
            players.add(p);
        }
        int sample = Math.max(64, limit * 8);
        while (cnt.get() < limit && (conn = RoadGenerationService.pollNearest(q, players, sample)) != null) {
            WorldDataProvider provider = WorldDataProvider.getInstance();
            List<Records.StructureConnection> origin = provider.getStructureConnections(level);
            ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
            for (int i = 0; i < all.size(); ++i) {
                Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                if (!RoadGenerationService.sameEdge(c, conn)) continue;
                all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.GENERATING));
            }
            if (!all.isEmpty()) {
                provider.setStructureConnections(level, all);
            }
            Records.StructureConnection task = conn;
            cnt.incrementAndGet();
            long epoch = ThreadPoolManager.currentEpoch();
            Future<?> fut = ThreadPoolManager.generationExecutor().submit(() -> {
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!ThreadPoolManager.isEpoch(epoch)) {
                        return;
                    }
                    RoadGenerationService.safeGenerate(level, task, epoch);
                }
                finally {
                    cnt.decrementAndGet();
                }
            });
            ALL_RUNNING.add(fut);
        }
    }

    private static void refreshQueue(ServerLevel level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> list = provider.getStructureConnections(level);
        if (list == null) {
            return;
        }
        ConcurrentLinkedQueue q = QUEUES.computeIfAbsent(level, l -> new ConcurrentLinkedQueue());
        ConcurrentHashMap proc = PROCESSED.computeIfAbsent(level, l -> new ConcurrentHashMap());
        for (Records.StructureConnection c : list) {
            long key = PlanningUtils.edgeKey(c.from(), c.to());
            if (proc.putIfAbsent(key, Boolean.TRUE) != null || c.status() != Records.ConnectionStatus.PLANNED && c.status() != Records.ConnectionStatus.GENERATING) continue;
            q.add(c);
        }
    }

    private static void safeGenerate(ServerLevel level, Records.StructureConnection conn, long epoch) {
        block12: {
            try {
                RoadFeatureConfig rfc;
                FeatureConfiguration featureConfiguration;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (!ThreadPoolManager.isEpoch(epoch)) {
                    return;
                }
                WorldDataProvider provider = WorldDataProvider.getInstance();
                Registry reg = level.m_9598_().m_175515_(Registries.f_256911_);
                ConfiguredFeature cf = (ConfiguredFeature)reg.m_7745_(ROAD_CF_ID);
                RoadFeatureConfig cfg = cf != null && (featureConfiguration = cf.f_65378_()) instanceof RoadFeatureConfig ? (rfc = (RoadFeatureConfig)featureConfiguration) : RoadGenerationService.defaultConfig();
                new Road(level, conn, cfg).generateRoad(ConfigService.get().aStarMaxSteps());
                MinecraftServer server = level.m_7654_();
                if (server != null) {
                    server.execute(() -> {
                        if (!ThreadPoolManager.isEpoch(epoch)) {
                            return;
                        }
                        List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                        ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                        for (int i = 0; i < all.size(); ++i) {
                            Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                            if (!RoadGenerationService.sameEdge(c, conn)) continue;
                            all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                        }
                        provider.setStructureConnections(level, all);
                        long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                        ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                        if (proc != null) {
                            proc.remove(k);
                        }
                    });
                } else {
                    if (!ThreadPoolManager.isEpoch(epoch)) {
                        return;
                    }
                    List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                    ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                    for (int i = 0; i < all.size(); ++i) {
                        Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                        if (!RoadGenerationService.sameEdge(c, conn)) continue;
                        all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                    }
                    provider.setStructureConnections(level, all);
                    long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                    ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                    if (proc != null) {
                        proc.remove(k);
                    }
                }
            }
            catch (Throwable t) {
                WorldDataProvider provider = WorldDataProvider.getInstance();
                MinecraftServer server = level.m_7654_();
                if (server != null) {
                    server.execute(() -> {
                        if (!ThreadPoolManager.isEpoch(epoch)) {
                            return;
                        }
                        List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                        ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                        for (int i = 0; i < all.size(); ++i) {
                            Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                            if (!RoadGenerationService.sameEdge(c, conn)) continue;
                            all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                        }
                        provider.setStructureConnections(level, all);
                        long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                        ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                        if (proc != null) {
                            proc.remove(k);
                        }
                    });
                }
                if (!ThreadPoolManager.isEpoch(epoch)) {
                    return;
                }
                List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                for (int i = 0; i < all.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                }
                provider.setStructureConnections(level, all);
                long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                if (proc == null) break block12;
                proc.remove(k);
            }
        }
    }

    private static RoadFeatureConfig defaultConfig() {
        return new RoadFeatureConfig();
    }

    private static boolean sameEdge(Records.StructureConnection a, Records.StructureConnection b) {
        BlockPos af = a.from();
        BlockPos at = a.to();
        BlockPos bf = b.from();
        BlockPos bt = b.to();
        return af.equals((Object)bf) && at.equals((Object)bt) || af.equals((Object)bt) && at.equals((Object)bf);
    }

    private static long dist2XZ(BlockPos a, BlockPos b) {
        long dx = (long)a.m_123341_() - (long)b.m_123341_();
        long dz = (long)a.m_123343_() - (long)b.m_123343_();
        return dx * dx + dz * dz;
    }

    private static long playerDistance2(Records.StructureConnection c, List<ServerPlayer> players) {
        if (players == null || players.isEmpty()) {
            return Long.MAX_VALUE;
        }
        long best = Long.MAX_VALUE;
        int mx = c.from().m_123341_() + c.to().m_123341_() >> 1;
        int mz = c.from().m_123343_() + c.to().m_123343_() >> 1;
        BlockPos mid = new BlockPos(mx, 0, mz);
        for (ServerPlayer p : players) {
            BlockPos pb = p.m_20183_();
            long d = RoadGenerationService.dist2XZ(pb, c.from());
            if (d < best) {
                best = d;
            }
            if ((d = RoadGenerationService.dist2XZ(pb, c.to())) < best) {
                best = d;
            }
            if ((d = RoadGenerationService.dist2XZ(pb, mid)) >= best) continue;
            best = d;
        }
        return best;
    }

    private static Records.StructureConnection pollNearest(ConcurrentLinkedQueue<Records.StructureConnection> q, List<ServerPlayer> players, int sample) {
        if (q.isEmpty()) {
            return null;
        }
        if (players == null || players.isEmpty()) {
            return q.poll();
        }
        Iterator<Records.StructureConnection> it = q.iterator();
        Records.StructureConnection best = null;
        long bestd = Long.MAX_VALUE;
        while (it.hasNext()) {
            Records.StructureConnection e = it.next();
            long d = RoadGenerationService.playerDistance2(e, players);
            if (d >= bestd) continue;
            bestd = d;
            best = e;
        }
        if (best != null && q.remove(best)) {
            return best;
        }
        return q.poll();
    }
}

