/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructurePredictor {
    private StructurePredictor() {
    }

    public static List<Records.StructureInfo> predictOverworldVillagesAroundSpawn(ServerLevel level, int radiusChunks, boolean biomePrefilter) {
        RegistryAccess registryAccess = level.m_9598_();
        Registry setRegistry = registryAccess.m_175515_(Registries.f_256998_);
        Optional optVillages = setRegistry.m_203636_(BuiltinStructureSets.f_209820_);
        if (optVillages.isEmpty()) {
            return List.of();
        }
        StructureSet set = (StructureSet)((Holder.Reference)optVillages.get()).m_203334_();
        StructurePlacement placement = set.f_210004_();
        if (!(placement instanceof RandomSpreadStructurePlacement)) {
            return List.of();
        }
        RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
        BlockPos spawn = level.m_220360_();
        int cx = spawn.m_123341_() >> 4;
        int cz = spawn.m_123343_() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        ChunkGeneratorStructureState state = level.m_7726_().m_255415_();
        RandomState randomState = state.m_255046_();
        BiomeSource biomeSource = level.m_7726_().m_8481_().m_62218_();
        HashSet<Holder> allowedBiomes = null;
        if (biomePrefilter) {
            allowedBiomes = new HashSet<Holder>();
            for (StructureSet.StructureSelectionEntry entry : set.f_210003_()) {
                Structure structure = (Structure)entry.f_210026_().m_203334_();
                for (Holder b : structure.m_226559_()) {
                    allowedBiomes.add(b);
                }
            }
        }
        int spacing = rssp.m_205003_();
        int startI = Math.floorDiv(minX, spacing);
        int endI = Math.floorDiv(maxX, spacing);
        int startJ = Math.floorDiv(minZ, spacing);
        int endJ = Math.floorDiv(maxZ, spacing);
        long seed = level.m_7328_();
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (int i = startI; i <= endI; ++i) {
            for (int j = startJ; j <= endJ; ++j) {
                int qz;
                int qy;
                int qx;
                Holder sample;
                int baseX = i * spacing;
                int baseZ = j * spacing;
                ChunkPos candidate = rssp.m_227008_(seed, baseX, baseZ);
                int x = candidate.f_45578_;
                int z = candidate.f_45579_;
                if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.m_255071_(state, x, z)) continue;
                BlockPos locatePos = placement.m_227039_(candidate);
                if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample = biomeSource.m_203407_(qx = QuartPos.m_175400_((int)locatePos.m_123341_()), qy = QuartPos.m_175400_((int)64), qz = QuartPos.m_175400_((int)locatePos.m_123343_()), randomState.m_224579_()))) continue;
                result.add(new Records.StructureInfo(locatePos, "village"));
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresInRect(ServerLevel level, int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        RegistryAccess access = level.m_9598_();
        Registry setRegistry = access.m_175515_(Registries.f_256998_);
        ChunkGeneratorStructureState state = level.m_7726_().m_255415_();
        RandomState randomState = state.m_255046_();
        BiomeSource biomeSource = level.m_7726_().m_8481_().m_62218_();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Holder.Reference holder : setRegistry.m_203611_().toList()) {
            ResourceLocation id;
            Object key;
            Holder structureHolder;
            StructureSet set = (StructureSet)holder.m_203334_();
            StructurePlacement placement = set.f_210004_();
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
            ArrayList<Holder> matchedStructures = new ArrayList<Holder>();
            for (Object entry : set.f_210003_()) {
                structureHolder = entry.f_210026_();
                key = structureHolder.m_203543_();
                if (((Optional)key).isEmpty() || !filters.matches((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).m_135782_())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.f_210003_()) {
                    structureHolder = entry.f_210026_();
                    key = structureHolder.m_203543_();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).m_135782_())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<Holder> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<Holder>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    Holder h2 = (Holder)entry.next();
                    for (Holder b : ((Structure)h2.m_203334_()).m_226559_()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.m_205003_();
            int startI = Math.floorDiv(minChunkX, spacing);
            int endI = Math.floorDiv(maxChunkX, spacing);
            int startJ = Math.floorDiv(minChunkZ, spacing);
            int endJ = Math.floorDiv(maxChunkZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    ChunkPos candidate = rssp.m_227008_(level.m_7328_(), baseX, baseZ);
                    int x = candidate.f_45578_;
                    int z = candidate.f_45579_;
                    if (x < minChunkX || x > maxChunkX || z < minChunkZ || z > maxChunkZ || !placement.m_255071_(state, x, z)) continue;
                    BlockPos locatePos = placement.m_227039_(candidate);
                    int qx = QuartPos.m_175400_((int)locatePos.m_123341_());
                    int qy = QuartPos.m_175400_((int)64);
                    int qz = QuartPos.m_175400_((int)locatePos.m_123343_());
                    Holder sample = biomeSource.m_203407_(qx, qy, qz, randomState.m_224579_());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (Holder h3 : matchedStructures) {
                        if (!((Structure)h3.m_203334_()).m_226559_().m_203333_(sample)) continue;
                        chosenId = h3.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresAroundSpawn(ServerLevel level, int radiusChunks, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        RegistryAccess access = level.m_9598_();
        Registry setRegistry = access.m_175515_(Registries.f_256998_);
        BlockPos spawn = level.m_220360_();
        int cx = spawn.m_123341_() >> 4;
        int cz = spawn.m_123343_() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        ChunkGeneratorStructureState state = level.m_7726_().m_255415_();
        RandomState randomState = state.m_255046_();
        BiomeSource biomeSource = level.m_7726_().m_8481_().m_62218_();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Holder.Reference holder : setRegistry.m_203611_().toList()) {
            ResourceLocation id;
            Object key;
            Holder structureHolder;
            StructureSet set = (StructureSet)holder.m_203334_();
            StructurePlacement placement = set.f_210004_();
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
            ArrayList<Holder> matchedStructures = new ArrayList<Holder>();
            for (Object entry : set.f_210003_()) {
                structureHolder = entry.f_210026_();
                key = structureHolder.m_203543_();
                if (((Optional)key).isEmpty() || !filters.matches((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).m_135782_())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.f_210003_()) {
                    structureHolder = entry.f_210026_();
                    key = structureHolder.m_203543_();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).m_135782_())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<Holder> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<Holder>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    Holder h2 = (Holder)entry.next();
                    for (Holder b : ((Structure)h2.m_203334_()).m_226559_()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.m_205003_();
            int startI = Math.floorDiv(minX, spacing);
            int endI = Math.floorDiv(maxX, spacing);
            int startJ = Math.floorDiv(minZ, spacing);
            int endJ = Math.floorDiv(maxZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    ChunkPos candidate = rssp.m_227008_(level.m_7328_(), baseX, baseZ);
                    int x = candidate.f_45578_;
                    int z = candidate.f_45579_;
                    if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.m_255071_(state, x, z)) continue;
                    BlockPos locatePos = placement.m_227039_(candidate);
                    int qx = QuartPos.m_175400_((int)locatePos.m_123341_());
                    int qy = QuartPos.m_175400_((int)64);
                    int qz = QuartPos.m_175400_((int)locatePos.m_123343_());
                    Holder sample = biomeSource.m_203407_(qx, qy, qz, randomState.m_224579_());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (Holder h3 : matchedStructures) {
                        if (!((Structure)h3.m_203334_()).m_226559_().m_203333_(sample)) continue;
                        chosenId = h3.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    private static final class Filters {
        private final List<String> whitelist;
        private final List<String> blacklist;

        private Filters(List<String> whitelist, List<String> blacklist) {
            this.whitelist = Filters.normalize(whitelist);
            this.blacklist = Filters.normalize(blacklist);
        }

        static Filters of(List<String> whitelist, List<String> blacklist) {
            return new Filters(whitelist, blacklist);
        }

        boolean hasWhitelist() {
            return !this.whitelist.isEmpty();
        }

        boolean matches(Holder<Structure> holder, ResourceLocation id) {
            boolean whiteOk = this.whitelist.isEmpty() || this.whitelist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            boolean blackHit = this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            return whiteOk && !blackHit;
        }

        boolean isBlacklisted(Holder<Structure> holder, ResourceLocation id) {
            return this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
        }

        private boolean matchesPattern(Holder<Structure> holder, ResourceLocation id, String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                return false;
            }
            String p = pattern.trim().toLowerCase(Locale.ROOT);
            String idStr = id.toString().toLowerCase(Locale.ROOT);
            if (p.startsWith("#")) {
                String raw = p.substring(1);
                ResourceLocation tagId = ResourceLocation.m_135820_((String)raw);
                if (tagId == null) {
                    return false;
                }
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)tagId);
                return holder.m_203656_(tag);
            }
            if (p.endsWith("/*")) {
                String base = p.substring(0, p.length() - 2);
                if (idStr.startsWith(base + "/")) {
                    return true;
                }
                if (idStr.startsWith(base + "_")) {
                    return true;
                }
                if (idStr.startsWith(base + "-")) {
                    return true;
                }
                return idStr.startsWith(base + ".");
            }
            if (p.endsWith(":*")) {
                String ns = p.substring(0, p.length() - 2);
                int idx = ns.indexOf(58);
                if (idx > 0) {
                    ns = ns.substring(0, idx);
                }
                return id.m_135827_().equalsIgnoreCase(ns);
            }
            return idStr.equals(p);
        }

        private static List<String> normalize(List<String> src) {
            ArrayList<String> out = new ArrayList<String>();
            if (src == null) {
                return out;
            }
            for (String s : src) {
                String v;
                if (s == null || (v = s.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
                out.add(v);
            }
            return out;
        }
    }
}

