/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.structures.index.StructureIndex;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public final class ChunkStructureIndex
implements StructureIndex {
    private final Map<Long, Set<StructureInstance>> byChunk = new ConcurrentHashMap<Long, Set<StructureInstance>>();

    private static long key(ChunkPos cp) {
        return (long)cp.f_45578_ << 32 ^ (long)cp.f_45579_ & 0xFFFFFFFFL;
    }

    @Override
    public void add(StructureInstance inst) {
        AABB b = inst.bounds();
        if (b == null) {
            return;
        }
        int minCX = (int)Math.floor(b.f_82288_ / 16.0);
        int maxCX = (int)Math.floor(b.f_82291_ / 16.0);
        int minCZ = (int)Math.floor(b.f_82290_ / 16.0);
        int maxCZ = (int)Math.floor(b.f_82293_ / 16.0);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                this.byChunk.computeIfAbsent(ChunkStructureIndex.key(new ChunkPos(cx, cz)), k -> ConcurrentHashMap.newKeySet()).add(inst);
            }
        }
    }

    @Override
    public void remove(StructureInstance inst) {
        for (Set<StructureInstance> set : this.byChunk.values()) {
            set.remove(inst);
        }
    }

    @Override
    public Collection<StructureInstance> query(AABB box) {
        if (box == null) {
            return Collections.emptyList();
        }
        int minCX = (int)Math.floor(box.f_82288_ / 16.0);
        int maxCX = (int)Math.floor(box.f_82291_ / 16.0);
        int minCZ = (int)Math.floor(box.f_82290_ / 16.0);
        int maxCZ = (int)Math.floor(box.f_82293_ / 16.0);
        HashSet<StructureInstance> result = new HashSet<StructureInstance>();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                Set<StructureInstance> set = this.byChunk.get(ChunkStructureIndex.key(new ChunkPos(cx, cz)));
                if (set == null) continue;
                for (StructureInstance s : set) {
                    if (s.bounds() == null || !s.bounds().m_82381_(box)) continue;
                    result.add(s);
                }
            }
        }
        return result;
    }

    @Override
    public boolean existsNear(BlockPos pos, int radius) {
        AABB box = new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - radius), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + radius), (double)(pos.m_123343_() + radius));
        return !this.query(box).isEmpty();
    }

    @Override
    public void clear() {
        this.byChunk.clear();
    }
}

