/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class MapRenderer {
    private static final int RADIUS = 5;
    private static final int TARGET_GRID_PX = 80;
    private static final double ROAD_LOD_FINEST = 300.0;
    private static final double ROAD_LOD_128TH = 500.0;
    private static final double ROAD_LOD_256TH = 1000.0;
    private static final double ROAD_LOD_512TH = 2000.0;
    private static final double ROAD_LOD_1024TH = 5000.0;
    private static final double ROAD_LOD_NONE = 10000.0;
    private final Map<String, Integer> statusColors;
    private final RoadDebugScreen.ScreenBounds bounds;

    public MapRenderer(Map<String, Integer> statusColors, RoadDebugScreen.ScreenBounds bounds) {
        this.statusColors = statusColors;
        this.bounds = bounds;
    }

    public LODLevel getLODLevel(double zoom) {
        if (zoom > 3.0) {
            return LODLevel.HIGH;
        }
        if (zoom > 1.0) {
            return LODLevel.MEDIUM;
        }
        if (zoom > 0.3) {
            return LODLevel.LOW;
        }
        return LODLevel.MINIMAL;
    }

    public RoadLODLevel getRoadLODLevel(double baseScale, double zoom) {
        double blocksPerPixel = 1.0 / (baseScale * zoom);
        double blocksPerGrid = blocksPerPixel * 80.0;
        if (blocksPerGrid < 300.0) {
            return RoadLODLevel.FINEST;
        }
        if (blocksPerGrid < 500.0) {
            return RoadLODLevel.SIXTY_FOURTH;
        }
        if (blocksPerGrid < 1000.0) {
            return RoadLODLevel.ONE_TWENTY_EIGHTH;
        }
        if (blocksPerGrid < 2000.0) {
            return RoadLODLevel.TWO_FIFTY_SIXTH;
        }
        if (blocksPerGrid < 5000.0) {
            return RoadLODLevel.FIVE_TWELVE;
        }
        if (blocksPerGrid < 10000.0) {
            return RoadLODLevel.ONE_THOUSAND_TWENTY_FOURTH;
        }
        return RoadLODLevel.NONE;
    }

    public void drawRoadPaths(class_332 ctx, List<Records.RoadData> roads, LODLevel lod, double baseScale, double zoom, WorldToScreenConverter converter) {
        if (roads == null || roads.isEmpty() || lod == LODLevel.MINIMAL) {
            return;
        }
        RoadLODLevel roadLOD = this.getRoadLODLevel(baseScale, zoom);
        if (roadLOD == RoadLODLevel.NONE) {
            return;
        }
        int roadColor = this.statusColors.get("road") & 0xFFFFFF | Integer.MIN_VALUE;
        boolean needsRoughCheck = roadLOD == RoadLODLevel.FIVE_TWELVE || roadLOD == RoadLODLevel.ONE_THOUSAND_TWENTY_FOURTH;
        for (Records.RoadData roadData : roads) {
            List<Records.RoadSegmentPlacement> segments = roadData.roadSegmentList();
            if (segments == null || segments.size() < 2) continue;
            if (needsRoughCheck && segments.size() > 1) {
                class_2338 start = segments.get(0).middlePos();
                class_2338 end = segments.get(segments.size() - 1).middlePos();
                RoadDebugScreen.ScreenPos startScreen = converter.worldToScreen(start.method_10263(), start.method_10260());
                RoadDebugScreen.ScreenPos endScreen = converter.worldToScreen(end.method_10263(), end.method_10260());
                if (!this.bounds.isInBounds(startScreen.x(), startScreen.y(), 200) && !this.bounds.isInBounds(endScreen.x(), endScreen.y(), 200)) continue;
            }
            this.drawRoadPathWithLOD(ctx, segments, roadColor, roadLOD, converter);
        }
    }

    private void drawRoadPathWithLOD(class_332 ctx, List<Records.RoadSegmentPlacement> segments, int color, RoadLODLevel roadLOD, WorldToScreenConverter converter) {
        int step;
        switch (roadLOD.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 64;
                break;
            }
            case 2: {
                int n = 128;
                break;
            }
            case 3: {
                int n = 256;
                break;
            }
            case 4: {
                int n = 512;
                break;
            }
            case 5: {
                int n = 1024;
                break;
            }
            case 6: {
                int n = step = Integer.MAX_VALUE;
            }
        }
        if (step >= segments.size()) {
            return;
        }
        RoadDebugScreen.ScreenPos prevPos = null;
        int drawnSegments = 0;
        int maxSegments = 10000;
        for (int i = 0; i < segments.size() && drawnSegments < maxSegments; i += step) {
            class_2338 pos = segments.get(i).middlePos();
            RoadDebugScreen.ScreenPos currentPos = converter.worldToScreen(pos.method_10263(), pos.method_10260());
            if (!this.bounds.isInBounds(currentPos.x(), currentPos.y(), 100)) {
                prevPos = currentPos;
                continue;
            }
            if (prevPos != null && i > 0 && this.bounds.isLineInBounds(prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y())) {
                RenderUtils.drawLine(ctx, prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y(), color);
                ++drawnSegments;
            }
            prevPos = currentPos;
        }
    }

    public void drawConnections(class_332 ctx, List<Records.StructureConnection> connections, LODLevel lod, WorldToScreenConverter converter) {
        if (connections == null || connections.isEmpty() || lod == LODLevel.MINIMAL) {
            return;
        }
        for (Records.StructureConnection conn : connections) {
            if (conn.status() == Records.ConnectionStatus.COMPLETED) continue;
            RoadDebugScreen.ScreenPos fromPos = converter.worldToScreen(conn.from().method_10263(), conn.from().method_10260());
            RoadDebugScreen.ScreenPos toPos = converter.worldToScreen(conn.to().method_10263(), conn.to().method_10260());
            if (!this.bounds.isLineInBounds(fromPos.x(), fromPos.y(), toPos.x(), toPos.y())) continue;
            int color = this.getConnectionColor(conn);
            RenderUtils.drawLine(ctx, fromPos.x(), fromPos.y(), toPos.x(), toPos.y(), color);
        }
    }

    private int getConnectionColor(Records.StructureConnection conn) {
        return switch (conn.status()) {
            case Records.ConnectionStatus.PLANNED -> -10496;
            case Records.ConnectionStatus.GENERATING -> -29696;
            case Records.ConnectionStatus.FAILED -> -48060;
            default -> this.statusColors.get("completed");
        };
    }

    public void drawStructures(class_332 ctx, List<class_2338> structures, class_2338 hoveredStructure, LODLevel lod, WorldToScreenConverter converter) {
        if (structures == null || structures.isEmpty()) {
            return;
        }
        int adaptiveRadius = this.getAdaptiveNodeRadius(lod, 3.0);
        for (class_2338 structure : structures) {
            int radius;
            RoadDebugScreen.ScreenPos pos = converter.worldToScreen(structure.method_10263(), structure.method_10260());
            if (!this.bounds.isInBounds(pos.x(), pos.y(), adaptiveRadius + 6)) continue;
            boolean isHovered = structure.equals((Object)hoveredStructure);
            int n = radius = isHovered ? adaptiveRadius + 2 : adaptiveRadius;
            if (radius < 2) {
                ctx.method_25294(pos.x() - 1, pos.y() - 1, pos.x() + 2, pos.y() + 2, -13710223);
                continue;
            }
            switch (lod.ordinal()) {
                case 0: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 1, 816047669);
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -13710223);
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14777271);
                    int highlightSize = Math.max(1, radius / 4);
                    ctx.method_25294(pos.x() - highlightSize, pos.y() - highlightSize, pos.x() + highlightSize + 1, pos.y() + highlightSize + 1, -1426063361);
                    break;
                }
                case 1: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -13710223);
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14777271);
                    ctx.method_25294(pos.x() - 1, pos.y() - 1, pos.x() + 1, pos.y() + 1, -1996488705);
                    break;
                }
                case 2: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -13710223);
                    if (radius < 3) break;
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14777271);
                    break;
                }
                case 3: {
                    if (radius <= 2) {
                        ctx.method_25294(pos.x() - 1, pos.y() - 1, pos.x() + 2, pos.y() + 2, -13710223);
                        break;
                    }
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -13710223);
                }
            }
        }
    }

    public void drawPlayerMarker(class_332 ctx, LODLevel lod, double zoom, WorldToScreenConverter converter) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        double px = mc.field_1724.method_23317();
        double pz = mc.field_1724.method_23321();
        RoadDebugScreen.ScreenPos p = converter.worldToScreen(px, pz);
        int playerRadius = Math.max(3, this.getAdaptiveNodeRadius(lod, zoom) + 1);
        if (!this.bounds.isInBounds(p.x(), p.y(), playerRadius + 10)) {
            return;
        }
        int fill = -1618884;
        int glow = 1088900156;
        int outline = -7131873;
        float yaw = mc.field_1724.method_36454();
        double angle = Math.toRadians(yaw) + 1.5707963267948966;
        int arrowLength = playerRadius + Math.max(3, (int)(4.0 * Math.min(zoom / 3.0, 1.5)));
        double tx = (double)p.x() + Math.cos(angle) * (double)arrowLength;
        double ty = (double)p.y() + Math.sin(angle) * (double)arrowLength;
        switch (lod.ordinal()) {
            case 0: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius + 1, 1088900156);
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                int highlightSize = Math.max(1, playerRadius / 4);
                ctx.method_25294(p.x() - highlightSize, p.y() - highlightSize, p.x() + highlightSize + 1, p.y() + highlightSize + 1, -1426063361);
                RenderUtils.drawLine(ctx, p.x(), p.y(), (int)tx, (int)ty, -1);
                break;
            }
            case 1: 
            case 2: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                RenderUtils.drawLine(ctx, p.x(), p.y(), (int)tx, (int)ty, -1);
                break;
            }
            case 3: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), Math.max(2, playerRadius), -1618884);
                int shortArrow = playerRadius + 2;
                double stx = (double)p.x() + Math.cos(angle) * (double)shortArrow;
                double sty = (double)p.y() + Math.sin(angle) * (double)shortArrow;
                RenderUtils.drawLine(ctx, p.x(), p.y(), (int)stx, (int)sty, -1);
            }
        }
    }

    private int getAdaptiveNodeRadius(LODLevel lod, double zoom) {
        double baseRadius = 5.0;
        double zoomFactor = Math.max(0.3, Math.min(1.2, 1.0 + Math.log10(zoom) * 0.15));
        double scaledRadius = baseRadius * zoomFactor;
        double lodMultiplier = switch (lod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.9;
            case 1 -> 1.0;
            case 2 -> 0.8;
            case 3 -> 0.6;
        };
        return Math.max(2, (int)Math.round(scaledRadius * lodMultiplier));
    }

    public static enum LODLevel {
        HIGH,
        MEDIUM,
        LOW,
        MINIMAL;

    }

    public static enum RoadLODLevel {
        FINEST,
        SIXTY_FOURTH,
        ONE_TWENTY_EIGHTH,
        TWO_FIFTY_SIXTH,
        FIVE_TWELVE,
        ONE_THOUSAND_TWENTY_FOURTH,
        NONE;

    }

    public static interface WorldToScreenConverter {
        public RoadDebugScreen.ScreenPos worldToScreen(double var1, double var3);
    }
}

