/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.GridRenderer;
import net.countered.settlementroads.client.gui.MapRenderer;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.UIRenderer;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class RoadDebugScreen
extends class_437 {
    private static final int PADDING = 20;
    private final List<class_2338> structures;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;
    private final Map<String, Integer> statusColors = Map.of("structure", -14176672, "planned", -865972, "generating", -1671646, "completed", -14176672, "failed", -1618884, "road", -13330213);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 3.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private double lastZoom = 1.0;
    private double lastOffsetX = 0.0;
    private double lastOffsetY = 0.0;
    private class_2338 hoveredStructure = null;
    private boolean manualLinkMode = false;
    private class_2338 selectedStart = null;
    private class_2338 selectedEnd = null;
    private int manualBtnX;
    private int manualBtnY;
    private int manualBtnW = 150;
    private int manualBtnH = 22;
    private final MapRenderer mapRenderer;
    private final GridRenderer gridRenderer;
    private final UIRenderer uiRenderer;
    private final ScreenBounds bounds;

    public RoadDebugScreen(List<class_2338> structures, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.debug_map.title"));
        this.structures = structures != null ? new ArrayList<class_2338>(structures) : new ArrayList();
        this.connections = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        List<Records.RoadData> list = this.roads = roads != null ? new ArrayList<Records.RoadData>(roads) : new ArrayList();
        if (!this.structures.isEmpty()) {
            this.minX = this.structures.stream().mapToInt(class_2382::method_10263).min().orElse(0);
            this.maxX = this.structures.stream().mapToInt(class_2382::method_10263).max().orElse(0);
            this.minZ = this.structures.stream().mapToInt(class_2382::method_10260).min().orElse(0);
            this.maxZ = this.structures.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        }
        this.bounds = new ScreenBounds();
        this.mapRenderer = new MapRenderer(this.statusColors, this.bounds);
        this.gridRenderer = new GridRenderer();
        this.uiRenderer = new UIRenderer(this.statusColors);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.layoutDirty || this.lastWidth != this.field_22789 || this.lastHeight != this.field_22790 || this.lastZoom != this.zoom || this.lastOffsetX != this.offsetX || this.lastOffsetY != this.offsetY) {
            this.computeLayout();
            this.updateUIBounds();
            this.lastWidth = this.field_22789;
            this.lastHeight = this.field_22790;
            this.lastZoom = this.zoom;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.layoutDirty = false;
        }
        this.renderCustomBackground(ctx);
        MapRenderer.LODLevel lod = this.mapRenderer.getLODLevel(this.zoom);
        MapRenderer.WorldToScreenConverter converter = this::worldToScreen;
        if (lod != MapRenderer.LODLevel.MINIMAL) {
            this.gridRenderer.drawGrid(ctx, lod, this.field_22789, this.field_22790, 20, this.baseScale, this.zoom, this.offsetX, this.offsetY, this.minX, this.minZ, this.bounds);
        }
        this.mapRenderer.drawRoadPaths(ctx, this.roads, lod, this.baseScale, this.zoom, converter);
        this.mapRenderer.drawConnections(ctx, this.connections, lod, converter);
        this.mapRenderer.drawStructures(ctx, this.structures, this.hoveredStructure, lod, converter);
        this.mapRenderer.drawPlayerMarker(ctx, lod, this.zoom, converter);
        if (this.manualLinkMode) {
            this.drawManualSelectionOverlay(ctx, converter);
        }
        this.uiRenderer.drawTitle(ctx, this.field_22789);
        this.uiRenderer.drawStatsPanel(ctx, this.field_22789, this.structures, this.connections, this.roads, this.zoom);
        this.uiRenderer.drawLegendPanel(ctx, this.field_22790);
        int spacing = this.computeGridSpacing();
        this.uiRenderer.drawScalePanel(ctx, this.field_22789, this.field_22790, this.baseScale, this.zoom, spacing);
        this.drawManualLinkButton(ctx, mouseX, mouseY);
        super.method_25394(ctx, mouseX, mouseY, delta);
        if (this.hoveredStructure != null) {
            this.uiRenderer.drawTooltip(ctx, this.hoveredStructure, mouseX, mouseY, this.field_22789, this.field_22790);
        }
        this.updateHoveredStructure(mouseX, mouseY);
    }

    private void renderCustomBackground(class_332 ctx) {
        ctx.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
    }

    private void updateUIBounds() {
        this.bounds.update(20, this.field_22789 - 20, 20, this.field_22790 - 20);
    }

    private void updateHoveredStructure(int mouseX, int mouseY) {
        this.hoveredStructure = this.findClickedStructure(mouseX, mouseY);
    }

    public boolean method_25422() {
        return true;
    }

    protected void method_57734(float delta) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (this.isOverManualButton((int)mouseX, (int)mouseY)) {
            this.toggleManualLinkMode();
            return true;
        }
        class_2338 clicked = this.findClickedStructure(mouseX, mouseY);
        if (this.manualLinkMode) {
            if (clicked != null) {
                this.handleManualSelection(clicked);
                return true;
            }
            return true;
        }
        if (clicked != null) {
            this.teleportTo(clicked);
            return true;
        }
        this.dragging = true;
        return true;
    }

    private boolean isOverManualButton(int mx, int my) {
        this.manualBtnW = 150;
        this.manualBtnH = 22;
        this.manualBtnX = 25;
        int legendItems = 5;
        int legendTopY = this.field_22790 - legendItems * 16 - 20 - 16;
        this.manualBtnY = Math.max(30, legendTopY - this.manualBtnH - 6);
        return mx >= this.manualBtnX && mx <= this.manualBtnX + this.manualBtnW && my >= this.manualBtnY && my <= this.manualBtnY + this.manualBtnH;
    }

    private void drawManualLinkButton(class_332 ctx, int mouseX, int mouseY) {
        String label = class_2561.method_43471((String)(this.manualLinkMode ? "gui.roadweaver.debug_map.manual_link_on" : "gui.roadweaver.debug_map.manual_link_off")).getString();
        boolean hovered = this.isOverManualButton(mouseX, mouseY);
        int bg = this.manualLinkMode ? -1071741879 : -1073741824;
        int border = hovered ? -11890462 : -13350562;
        RenderUtils.drawPanel(ctx, this.manualBtnX, this.manualBtnY, this.manualBtnX + this.manualBtnW, this.manualBtnY + this.manualBtnH, bg, border);
        int tx = this.manualBtnX + 8;
        int ty = this.manualBtnY + 7;
        ctx.method_51433(class_310.method_1551().field_1772, label, tx, ty, -1, true);
    }

    private void toggleManualLinkMode() {
        boolean bl = this.manualLinkMode = !this.manualLinkMode;
        if (!this.manualLinkMode) {
            this.selectedStart = null;
            this.selectedEnd = null;
        }
    }

    private void handleManualSelection(class_2338 clicked) {
        if (this.selectedStart == null) {
            this.selectedStart = clicked;
        } else if (this.selectedEnd == null && !clicked.equals((Object)this.selectedStart)) {
            this.selectedEnd = clicked;
            this.enqueueManualConnection(this.selectedStart, this.selectedEnd);
            this.selectedStart = null;
            this.selectedEnd = null;
        }
    }

    private void drawManualSelectionOverlay(class_332 ctx, MapRenderer.WorldToScreenConverter converter) {
        ScreenPos a;
        if (this.selectedStart != null) {
            a = converter.worldToScreen(this.selectedStart.method_10263(), this.selectedStart.method_10260());
            RenderUtils.drawCircleOutline(ctx, a.x(), a.y(), 7, -1);
        }
        if (this.selectedEnd != null) {
            ScreenPos b = converter.worldToScreen(this.selectedEnd.method_10263(), this.selectedEnd.method_10260());
            RenderUtils.drawCircleOutline(ctx, b.x(), b.y(), 7, -1);
        }
        if (this.selectedStart != null && this.selectedEnd != null) {
            a = converter.worldToScreen(this.selectedStart.method_10263(), this.selectedStart.method_10260());
            ScreenPos b = converter.worldToScreen(this.selectedEnd.method_10263(), this.selectedEnd.method_10260());
            RenderUtils.drawLine(ctx, a.x(), a.y(), b.x(), b.y(), -1);
        }
    }

    private void enqueueManualConnection(class_2338 a, class_2338 b) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1576() == null) {
            return;
        }
        class_3218 world = mc.method_1576().method_30002();
        if (world == null) {
            return;
        }
        mc.method_1576().execute(() -> {
            List original = (List)world.getAttachedOrCreate(WorldDataAttachment.CONNECTED_STRUCTURES, ArrayList::new);
            ArrayList<Records.StructureConnection> list = new ArrayList<Records.StructureConnection>(original.size());
            for (Records.StructureConnection c : original) {
                boolean samePair = c.from().equals((Object)a) && c.to().equals((Object)b) || c.from().equals((Object)b) && c.to().equals((Object)a);
                if (samePair) continue;
                list.add(c);
            }
            Records.StructureConnection updated = new Records.StructureConnection(a, b, Records.ConnectionStatus.PLANNED, true);
            list.add(updated);
            world.setAttached(WorldDataAttachment.CONNECTED_STRUCTURES, list);
            StructureConnector.cachedStructureConnections.add(updated);
            class_310.method_1551().execute(() -> {
                this.connections.removeIf(c -> c.from().equals((Object)a) && c.to().equals((Object)b) || c.from().equals((Object)b) && c.to().equals((Object)a));
                this.connections.add(updated);
            });
        });
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            this.layoutDirty = true;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        double old = this.zoom;
        this.zoom = vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.zoom = Math.max(0.1, Math.min(10.0, this.zoom));
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.layoutDirty = true;
        return true;
    }

    private void computeLayout() {
        if (this.structures.isEmpty()) {
            this.baseScale = 1.0;
            return;
        }
        int w = this.field_22789 - 40;
        int h = this.field_22790 - 40;
        if (w <= 0 || h <= 0) {
            return;
        }
        int worldW = this.maxX - this.minX;
        int worldH = this.maxZ - this.minZ;
        if (worldW <= 0 || worldH <= 0) {
            this.baseScale = 1.0;
            return;
        }
        double scaleX = (double)w / (double)worldW;
        double scaleY = (double)h / (double)worldH;
        this.baseScale = Math.min(scaleX, scaleY) * 0.8;
        if (this.firstLayout) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                double playerX = mc.field_1724.method_23317();
                double playerZ = mc.field_1724.method_23321();
                double playerScreenX = (playerX - (double)this.minX) * this.baseScale * this.zoom;
                double playerScreenZ = (playerZ - (double)this.minZ) * this.baseScale * this.zoom;
                this.offsetX = (double)w / 2.0 - playerScreenX;
                this.offsetY = (double)h / 2.0 - playerScreenZ;
            } else {
                this.offsetX = ((double)w - (double)worldW * this.baseScale * this.zoom) / 2.0;
                this.offsetY = ((double)h - (double)worldH * this.baseScale * this.zoom) / 2.0;
            }
            this.firstLayout = false;
        }
        this.layoutDirty = false;
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private class_2338 findClickedStructure(double mouseX, double mouseY) {
        for (class_2338 structure : this.structures) {
            double dy;
            ScreenPos pos = this.worldToScreen(structure.method_10263(), structure.method_10260());
            double dx = (double)pos.x() - mouseX;
            if (!(Math.sqrt(dx * dx + (dy = (double)pos.y() - mouseY) * dy) <= 7.0)) continue;
            return structure;
        }
        return null;
    }

    private void teleportTo(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.method_1576() != null) {
            mc.method_1576().execute(() -> {
                class_3222 sp = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667());
                if (sp != null) {
                    sp.method_5859((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
                }
            });
        }
    }

    private ScreenPos worldToScreen(double wx, double wz) {
        int sx = 20 + (int)((wx - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int sy = 20 + (int)((wz - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(sx, sy);
    }

    public boolean method_25421() {
        return false;
    }

    public static class ScreenBounds {
        private int left;
        private int right;
        private int top;
        private int bottom;

        public void update(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isInBounds(int x, int y, int margin) {
            return x >= this.left - margin && x <= this.right + margin && y >= this.top - margin && y <= this.bottom + margin;
        }

        public boolean isLineInBounds(int x1, int y1, int x2, int y2) {
            return !(x1 < this.left && x2 < this.left || x1 > this.right && x2 > this.right || y1 < this.top && y2 < this.top) && (y1 <= this.bottom || y2 <= this.bottom);
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public int top() {
            return this.top;
        }

        public int bottom() {
            return this.bottom;
        }
    }

    public record ScreenPos(int x, int y) {
    }
}

