/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UIRenderer {
    private static final int PADDING = 20;
    private final Map<String, Integer> statusColors;

    public UIRenderer(Map<String, Integer> statusColors) {
        this.statusColors = statusColors;
    }

    public void drawTitle(class_332 ctx, int width) {
        class_327 font = class_310.method_1551().field_1772;
        class_5250 title = class_2561.method_43471((String)"gui.roadweaver.debug_map.title");
        int tw = font.method_27525((class_5348)title);
        int x = (width - tw) / 2;
        int y = 28;
        RenderUtils.drawPanel(ctx, x - 10, y - 5, x + tw + 10, y + 14, -1073741824, -11890462);
        ctx.method_51439(font, (class_2561)title, x, y, -1, true);
    }

    public void drawStatsPanel(class_332 ctx, int width, List<class_2338> structures, List<Records.StructureConnection> connections, List<Records.RoadData> roads, double zoom) {
        class_327 font = class_310.method_1551().field_1772;
        int planned = 0;
        int generating = 0;
        int completed = 0;
        int failed = 0;
        for (Records.StructureConnection conn : connections) {
            switch (conn.status()) {
                case PLANNED: {
                    ++planned;
                    break;
                }
                case GENERATING: {
                    ++generating;
                    break;
                }
                case COMPLETED: {
                    ++completed;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        class_2561[] labels = new class_2561[]{class_2561.method_43469((String)"gui.roadweaver.debug_map.structures", (Object[])new Object[]{structures.size()}), class_2561.method_43469((String)"gui.roadweaver.debug_map.planned", (Object[])new Object[]{planned}), class_2561.method_43469((String)"gui.roadweaver.debug_map.generating", (Object[])new Object[]{generating}), class_2561.method_43469((String)"gui.roadweaver.debug_map.completed", (Object[])new Object[]{completed}), class_2561.method_43469((String)"gui.roadweaver.debug_map.failed", (Object[])new Object[]{failed}), class_2561.method_43469((String)"gui.roadweaver.debug_map.roads", (Object[])new Object[]{roads.size()}), class_2561.method_43469((String)"gui.roadweaver.debug_map.zoom", (Object[])new Object[]{String.format("%.1f", zoom)})};
        int[] colors = new int[]{-1, -10496, -29696, -13710223, -48060, -13330213, -4340793};
        int maxWidth = 0;
        for (class_2561 label : labels) {
            maxWidth = Math.max(maxWidth, font.method_27525((class_5348)label));
        }
        int panelWidth = maxWidth + 20;
        int panelHeight = labels.length * 14 + 10;
        int x = width - 20 - panelWidth - 5;
        int y = 50;
        RenderUtils.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int textY = y + 5;
        for (int i = 0; i < labels.length; ++i) {
            ctx.method_25294(x + 5, textY + 2, x + 10, textY + 7, colors[i]);
            ctx.method_49601(x + 5, textY + 2, 5, 5, -2130706433);
            ctx.method_51439(font, labels[i], x + 13, textY, colors[i], true);
            textY += 14;
        }
    }

    public void drawLegendPanel(class_332 ctx, int height) {
        class_327 font = class_310.method_1551().field_1772;
        class_2561[] labels = new class_2561[]{class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.structures"), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.planned"), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.generating"), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.failed"), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.roads")};
        int[] colors = new int[]{-13710223, -10496, -29696, -48060, -13330213};
        int maxWidth = 0;
        for (class_2561 label : labels) {
            maxWidth = Math.max(maxWidth, font.method_27525((class_5348)label));
        }
        int panelWidth = maxWidth + 30;
        int panelHeight = labels.length * 16 + 10;
        int x = 25;
        int y = height - labels.length * 16 - 20 - 16;
        RenderUtils.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int itemY = y + 5;
        for (int i = 0; i < labels.length; ++i) {
            RenderUtils.fillCircle(ctx, x + 10, itemY + 4, 4, colors[i]);
            RenderUtils.drawCircleOutline(ctx, x + 10, itemY + 4, 4, -2130706433);
            ctx.method_51439(font, labels[i], x + 20, itemY, -1, true);
            itemY += 16;
        }
    }

    public void drawScalePanel(class_332 ctx, int width, int height, double baseScale, double zoom, int spacing) {
        class_327 font = class_310.method_1551().field_1772;
        int lengthPx = (int)((double)spacing * baseScale * zoom);
        class_5250 text = class_2561.method_43469((String)"gui.roadweaver.debug_map.blocks", (Object[])new Object[]{spacing});
        int textWidth = font.method_27525((class_5348)text);
        int panelWidth = Math.max(lengthPx + 20, textWidth + 20);
        int panelHeight = 35;
        int x = width - 20 - panelWidth - 5;
        int y = height - 20 - panelHeight - 5;
        RenderUtils.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int scaleX = x + (panelWidth - lengthPx) / 2;
        int scaleY = y + panelHeight - 10;
        RenderUtils.fillH(ctx, scaleX, scaleX + lengthPx, scaleY, -1);
        RenderUtils.fillV(ctx, scaleX, scaleY - 4, scaleY + 4, -1);
        RenderUtils.fillV(ctx, scaleX + lengthPx, scaleY - 4, scaleY + 4, -1);
        ctx.method_51439(font, (class_2561)text, x + (panelWidth - textWidth) / 2, y + 8, -1, true);
    }

    public void drawTooltip(class_332 ctx, class_2338 pos, int mouseX, int mouseY, int width, int height) {
        class_327 font = class_310.method_1551().field_1772;
        class_2561[] lines = new class_2561[]{class_2561.method_43469((String)"gui.roadweaver.debug_map.tooltip.coord", (Object[])new Object[]{pos.method_10263(), pos.method_10260()}), class_2561.method_43469((String)"gui.roadweaver.debug_map.tooltip.height", (Object[])new Object[]{pos.method_10264()}), class_2561.method_43471((String)"gui.roadweaver.debug_map.tooltip.teleport")};
        int maxWidth = 0;
        for (class_2561 line : lines) {
            maxWidth = Math.max(maxWidth, font.method_27525((class_5348)line));
        }
        int tooltipWidth = maxWidth + 12;
        int tooltipHeight = lines.length * 11 + 6;
        int tx = mouseX + 10;
        int ty = mouseY + 10;
        if (tx + tooltipWidth > width - 5) {
            tx = mouseX - tooltipWidth - 10;
        }
        if (ty + tooltipHeight > height - 5) {
            ty = mouseY - tooltipHeight - 10;
        }
        RenderUtils.drawPanel(ctx, tx, ty, tx + tooltipWidth, ty + tooltipHeight, -268435456, -11890462);
        int textY = ty + 3;
        for (class_2561 line : lines) {
            ctx.method_51439(font, line, tx + 6, textY, -1, false);
            textY += 11;
        }
    }
}

