/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import net.minecraft.class_5281;

public class RoadFenceDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean leftRoadSide;
    private final int fenceLength;
    private Records.WoodAssets wood;

    public RoadFenceDecoration(class_2338 pos, class_2382 direction, class_5281 world, boolean leftRoadSide, int fenceLength) {
        super(pos, direction, world);
        this.leftRoadSide = leftRoadSide;
        this.fenceLength = Math.min(3, Math.max(1, fenceLength));
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        class_2338 basePos = this.getPos();
        class_5281 world = this.getWorld();
        class_2382 roadDirection = this.getOrthogonalVector();
        class_2382 fenceDirection = new class_2382(roadDirection.method_10260(), 0, -roadDirection.method_10263());
        for (int i = 0; i < this.fenceLength; ++i) {
            class_2338 fencePos = basePos.method_10081(fenceDirection.method_35862(i));
            class_2338 surfacePos = fencePos.method_33096(world.method_8624(class_2902.class_2903.field_13194, fencePos.method_10263(), fencePos.method_10260()));
            if (Math.abs(surfacePos.method_10264() - basePos.method_10264()) > 1) continue;
            world.method_8652(surfacePos, this.wood.fence().method_9564(), 3);
        }
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

