/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class Road {
    class_3218 serverWorld;
    Records.StructureConnection structureConnection;
    RoadFeatureConfig context;

    public Road(class_3218 serverWorld, Records.StructureConnection structureConnection, RoadFeatureConfig config) {
        this.serverWorld = serverWorld;
        this.structureConnection = structureConnection;
        this.context = config;
    }

    public void generateRoad(int maxSteps) {
        int maxStability;
        int maxHeightDiff;
        class_2338 end;
        this.updateConnectionStatus(Records.ConnectionStatus.GENERATING);
        class_5819 random = class_5819.method_43047();
        int width = Road.getRandomWidth(random, this.context);
        int type = Road.allowedRoadTypes(random);
        if (type == -1) {
            this.updateConnectionStatus(Records.ConnectionStatus.FAILED);
            return;
        }
        List<class_2680> material = type == 1 ? Road.getRandomNaturalRoadMaterials(random, this.context) : Road.getRandomArtificialRoadMaterials(random, this.context);
        class_2338 start = this.structureConnection.from();
        List<Records.RoadSegmentPlacement> roadSegmentPlacementList = RoadPathCalculator.calculateAStarRoadPath(start, end = this.structureConnection.to(), width, this.serverWorld, maxSteps, maxHeightDiff = this.structureConnection.manual() ? ModConfig.manualMaxHeightDifference : ModConfig.maxHeightDifference, maxStability = this.structureConnection.manual() ? ModConfig.manualMaxTerrainStability : ModConfig.maxTerrainStability);
        if (roadSegmentPlacementList.isEmpty()) {
            this.updateConnectionStatus(Records.ConnectionStatus.FAILED);
            return;
        }
        ArrayList<Records.RoadData> roadDataList = new ArrayList<Records.RoadData>((Collection)this.serverWorld.getAttachedOrCreate(WorldDataAttachment.ROAD_DATA_LIST, ArrayList::new));
        roadDataList.add(new Records.RoadData(width, type, material, roadSegmentPlacementList));
        this.serverWorld.setAttached(WorldDataAttachment.ROAD_DATA_LIST, roadDataList);
        this.updateConnectionStatus(Records.ConnectionStatus.COMPLETED);
    }

    private void updateConnectionStatus(Records.ConnectionStatus newStatus) {
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>((Collection)this.serverWorld.getAttachedOrCreate(WorldDataAttachment.CONNECTED_STRUCTURES, ArrayList::new));
        for (int i = 0; i < connections.size(); ++i) {
            Records.StructureConnection conn = (Records.StructureConnection)connections.get(i);
            if ((!conn.from().equals((Object)this.structureConnection.from()) || !conn.to().equals((Object)this.structureConnection.to())) && (!conn.from().equals((Object)this.structureConnection.to()) || !conn.to().equals((Object)this.structureConnection.from()))) continue;
            connections.set(i, new Records.StructureConnection(conn.from(), conn.to(), newStatus, conn.manual()));
            this.serverWorld.setAttached(WorldDataAttachment.CONNECTED_STRUCTURES, connections);
            break;
        }
    }

    private static int allowedRoadTypes(class_5819 deterministicRandom) {
        if (ModConfig.allowArtificial && ModConfig.allowNatural) {
            return Road.getRandomRoadType(deterministicRandom);
        }
        if (ModConfig.allowArtificial) {
            return 0;
        }
        if (ModConfig.allowNatural) {
            return 1;
        }
        return -1;
    }

    private static int getRandomRoadType(class_5819 random) {
        return random.method_39332(0, 1);
    }

    private static List<class_2680> getRandomNaturalRoadMaterials(class_5819 random, RoadFeatureConfig config) {
        List<List<class_2680>> materialsList = config.getNaturalMaterials();
        return materialsList.get(random.method_43048(materialsList.size()));
    }

    private static List<class_2680> getRandomArtificialRoadMaterials(class_5819 random, RoadFeatureConfig config) {
        List<List<class_2680>> materialsList = config.getArtificialMaterials();
        return materialsList.get(random.method_43048(materialsList.size()));
    }

    private static int getRandomWidth(class_5819 random, RoadFeatureConfig config) {
        List<Integer> widthList = config.getWidths();
        return widthList.get(random.method_43048(widthList.size()));
    }
}

