/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureLocator;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    public static Queue<Records.StructureConnection> cachedStructureConnections = new ArrayDeque<Records.StructureConnection>();

    public static void cacheNewConnection(class_3218 serverWorld, boolean locateAtPlayer) {
        StructureLocator.locateConfiguredStructure(serverWorld, 1, locateAtPlayer);
        List<class_2338> villagePosList = ((Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS)).structureLocations();
        if (villagePosList == null || villagePosList.size() < 2) {
            return;
        }
        StructureConnector.createNewStructureConnection(serverWorld);
    }

    private static void createNewStructureConnection(class_3218 serverWorld) {
        ArrayList<Records.StructureConnection> connections;
        Records.StructureLocationData structureLocationData;
        List<class_2338> worldStructureLocations;
        List<class_2338> villagePosList = ((Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS)).structureLocations();
        class_2338 latestVillagePos = villagePosList.get(villagePosList.size() - 1);
        class_2338 closestVillage = StructureConnector.findClosestStructure(latestVillagePos, worldStructureLocations = (structureLocationData = (Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS)).structureLocations());
        if (closestVillage != null && !StructureConnector.connectionExists(connections = new ArrayList<Records.StructureConnection>((Collection)serverWorld.getAttachedOrCreate(WorldDataAttachment.CONNECTED_STRUCTURES, ArrayList::new)), latestVillagePos, closestVillage)) {
            Records.StructureConnection structureConnection = new Records.StructureConnection(latestVillagePos, closestVillage);
            connections.add(structureConnection);
            serverWorld.setAttached(WorldDataAttachment.CONNECTED_STRUCTURES, connections);
            cachedStructureConnections.add(structureConnection);
            LOGGER.debug("Created connection between {} and {} (distance: {} blocks)", new Object[]{latestVillagePos, closestVillage, Math.sqrt(latestVillagePos.method_10262((class_2382)closestVillage))});
        }
    }

    private static boolean connectionExists(List<Records.StructureConnection> existingConnections, class_2338 a, class_2338 b) {
        for (Records.StructureConnection connection : existingConnections) {
            if ((!connection.from().equals((Object)a) || !connection.to().equals((Object)b)) && (!connection.to().equals((Object)b) || !connection.from().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static class_2338 findClosestStructure(class_2338 currentVillage, List<class_2338> allVillages) {
        class_2338 closestVillage = null;
        double minDistance = Double.MAX_VALUE;
        for (class_2338 village : allVillages) {
            double distance;
            if (village.equals((Object)currentVillage) || !((distance = currentVillage.method_10262((class_2382)village)) < minDistance)) continue;
            minDistance = distance;
            closestVillage = village;
        }
        return closestVillage;
    }
}

