/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final DynamicCommandExceptionType STRUCTURE_INVALID_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.locate.structure.invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType STRUCTURE_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.locate.structure.not_found", (Object[])new Object[]{id}));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void locateConfiguredStructure(class_3218 serverWorld, int locateCount, boolean locateAtPlayer) {
        LOGGER.debug("Locating " + locateCount + " " + ModConfig.structureToLocate);
        try {
            int x = 0;
            while (x < locateCount) {
                if (locateAtPlayer) {
                    for (class_3222 player : serverWorld.method_18456()) {
                        StructureLocator.executeLocateStructure(player.method_24515(), serverWorld, (class_7066.class_7068<class_3195>)new class_7066(class_7924.field_41246).method_41164(new StringReader(ModConfig.structureToLocate)));
                    }
                } else {
                    StructureLocator.executeLocateStructure(serverWorld.method_43126(), serverWorld, (class_7066.class_7068<class_3195>)new class_7066(class_7924.field_41246).method_41164(new StringReader(ModConfig.structureToLocate)));
                }
                ++x;
            }
            return;
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("Failed to locate structure: " + ModConfig.structureToLocate + " in dimension " + String.valueOf(serverWorld.method_27983().method_29177()) + " with exception: " + e.getMessage());
        }
    }

    private static void executeLocateStructure(class_2338 locatePos, class_3218 serverWorld, class_7066.class_7068<class_3195> predicate) throws CommandSyntaxException {
        class_2378 registry = serverWorld.method_30349().method_30530(class_7924.field_41246);
        class_6885 registryEntryList = (class_6885)StructureLocator.getStructureListForPredicate(predicate, (class_2378<class_3195>)registry).orElseThrow(() -> STRUCTURE_INVALID_EXCEPTION.create((Object)predicate.method_41176()));
        Pair pair = serverWorld.method_14178().method_12129().method_12103(serverWorld, registryEntryList, locatePos, ModConfig.structureSearchRadius, true);
        if (pair == null) {
            throw STRUCTURE_NOT_FOUND_EXCEPTION.create((Object)predicate.method_41176());
        }
        class_2338 structureLocation = (class_2338)pair.getFirst();
        LOGGER.debug("Structure found at " + String.valueOf(structureLocation));
        ((Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS)).addStructure(structureLocation);
    }

    private static Optional<? extends class_6885.class_6887<class_3195>> getStructureListForPredicate(class_7066.class_7068<class_3195> predicate, class_2378<class_3195> structureRegistry) {
        return (Optional)predicate.method_41173().map(key -> structureRegistry.method_40264(key).map(entry -> class_6885.method_40246((class_6880[])new class_6880[]{entry})), arg_0 -> structureRegistry.method_40266(arg_0));
    }
}

