/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.network.DebugDataPacket;
import net.countered.settlementroads.network.PacketHandler;
import net.countered.settlementroads.network.RoadWeaverNetworkManager;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementRoadsClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static class_304 debugMapKey;

    public void onInitializeClient() {
        LOGGER.info("Initializing RoadWeaver Client (Fabric)...");
        debugMapKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.roadweaver.debug_map", 72, "category.roadweaver"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (debugMapKey.method_1436()) {
                SettlementRoadsClient.handleDebugMapKey(client);
            }
        });
    }

    private static void handleDebugMapKey(class_310 client) {
        if (client == null) {
            return;
        }
        if (client.field_1755 instanceof RoadDebugScreen) {
            client.method_1507(null);
            PacketHandler.clearCachedDebugData();
            return;
        }
        if (client.method_1576() != null) {
            class_3218 world = client.method_1576().method_30002();
            if (world == null) {
                return;
            }
            try {
                Records.StructureLocationData data = WorldDataProvider.getInstance().getStructureLocations(world);
                List<Records.StructureConnection> connections = WorldDataProvider.getInstance().getStructureConnections(world);
                List<Records.RoadData> roads = WorldDataProvider.getInstance().getRoadDataList(world);
                ArrayList<Records.StructureInfo> structureInfos = data != null ? new ArrayList<Records.StructureInfo>(data.structureInfos()) : new ArrayList();
                client.method_1507((class_437)new RoadDebugScreen(structureInfos, connections, roads));
            }
            catch (Exception e) {
                client.method_1507((class_437)new RoadDebugScreen(new ArrayList<Records.StructureInfo>(), new ArrayList<Records.StructureConnection>(), new ArrayList<Records.RoadData>()));
            }
        } else if (client.field_1724 != null && client.method_1562() != null) {
            if (!client.field_1724.method_5687(2)) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"roadweaver.debug_map.no_permission"), true);
                return;
            }
            RoadWeaverNetworkManager.requestDebugData();
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"roadweaver.debug_map.loading"), true);
            new Thread(() -> {
                try {
                    for (int i = 0; i < 50; ++i) {
                        Thread.sleep(100L);
                        DebugDataPacket cachedData = PacketHandler.getCachedDebugData();
                        if (cachedData == null) continue;
                        client.execute(() -> client.method_1507((class_437)new RoadDebugScreen(cachedData.getStructureInfos(), cachedData.getConnections(), cachedData.getRoads())));
                        return;
                    }
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"roadweaver.debug_map.timeout"), false);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }
}

