/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.helpers.async.ThrottledStructureLocator;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModEventHandler {
    private static final int THREAD_COUNT = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static ExecutorService executor = Executors.newFixedThreadPool(128);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> worldInitDelay = new ConcurrentHashMap();
    private static final int INIT_DELAY_TICKS = 100;

    public static void register() {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        LifecycleEvent.SERVER_LEVEL_LOAD.register(ModEventHandler::onWorldLoad);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(level -> {
            if (!level.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            String worldKey = level.method_27983().method_29177().toString();
            Future<?> task = runningTasks.remove(worldKey);
            if (task != null && !task.isDone()) {
                task.cancel(true);
                LOGGER.debug("Aborted running road task for world: {}", (Object)level.method_27983().method_29177());
            }
            worldInitDelay.remove(worldKey);
            StructureConnector.clearQueueForWorld(level);
        });
        TickEvent.SERVER_PRE.register(server -> {
            for (class_3218 level : server.method_3738()) {
                if (!level.method_27983().equals(class_1937.field_25179)) continue;
                ThrottledStructureLocator.tickProcess(level);
                ModEventHandler.tryGenerateNewRoads(level, true, 5000);
            }
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            LOGGER.info("RoadWeaver: Shutting down...");
            ThrottledStructureLocator.shutdown();
            RoadPathCalculator.heightCache.clear();
            runningTasks.values().forEach(future -> future.cancel(true));
            runningTasks.clear();
            executor.shutdownNow();
            LOGGER.info("RoadWeaver: Shutdown completed");
        });
    }

    private static void onWorldLoad(class_3218 level) {
        ModEventHandler.restartExecutorIfNeeded();
        if (!level.method_27983().equals(class_1937.field_25179)) {
            return;
        }
        String worldKey = level.method_27983().method_29177().toString();
        worldInitDelay.put(worldKey, 100);
        LOGGER.info("RoadWeaver: \u4e16\u754c {} \u5df2\u52a0\u8f7d\uff0c\u5c06\u5728 {} ticks \u540e\u5f00\u59cb\u9053\u8def\u751f\u6210", (Object)worldKey, (Object)100);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(level);
        ModEventHandler.restoreUnfinishedRoads(level);
        IModConfig config = ConfigProvider.get();
        int currentCount = structureLocationData.structureLocations().size();
        int targetCount = config.initialLocatingCount();
        if (currentCount < targetCount) {
            int toLocate = targetCount - currentCount;
            LOGGER.info("\ud83c\udf0d Initializing world with {} structures (current: {}, target: {})", new Object[]{toLocate, currentCount, targetCount});
            LOGGER.info("Using throttled search (max 1 per tick) to avoid server lag");
            for (int i = 0; i < toLocate; ++i) {
                StructureConnector.cacheNewConnectionAsync(level, false);
            }
            LOGGER.info("\u2705 Initial structure search requests submitted (async)");
        }
    }

    private static void tryGenerateNewRoads(class_3218 level, Boolean async, int steps) {
        String worldKey = level.method_27983().method_29177().toString();
        Integer delayTicks = worldInitDelay.get(worldKey);
        if (delayTicks != null) {
            if (delayTicks > 0) {
                worldInitDelay.put(worldKey, delayTicks - 1);
                return;
            }
            worldInitDelay.remove(worldKey);
            LOGGER.info("RoadWeaver: \u4e16\u754c {} \u521d\u59cb\u5316\u5ef6\u8fdf\u7ed3\u675f\uff0c\u5f00\u59cb\u9053\u8def\u751f\u6210", (Object)worldKey);
        }
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        runningTasks.entrySet().removeIf(entry -> {
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.warn("Task {} completed with error: {}", entry.getKey(), (Object)e.getMessage());
                }
                return true;
            }
            return false;
        });
        int currentRunning = runningTasks.size();
        if (currentRunning >= config.maxConcurrentRoadGeneration()) {
            return;
        }
        Queue<Records.StructureConnection> queue = StructureConnector.getQueueForWorld(level);
        if (!queue.isEmpty()) {
            Records.StructureConnection structureConnection = queue.peek();
            if (structureConnection == null) {
                return;
            }
            RoadFeatureConfig roadConfig = ModEventHandler.getRoadFeatureConfig(level);
            if (roadConfig == null) {
                LOGGER.debug("RoadWeaver: \u6ce8\u518c\u8868\u672a\u5c31\u7eea\uff0c\u7b49\u5f85\u4e0b\u4e00\u4e2a tick\uff08\u961f\u5217\u5927\u5c0f: {}\uff09", (Object)queue.size());
                return;
            }
            queue.poll();
            LOGGER.info("\ud83d\udea7 Starting road generation: {} -> {} (running: {}/{}, queue: {})", new Object[]{structureConnection.from(), structureConnection.to(), currentRunning + 1, config.maxConcurrentRoadGeneration(), queue.size()});
            if (async.booleanValue()) {
                String taskId = level.method_27983().method_29177().toString() + "_" + System.nanoTime();
                Future<?> future = executor.submit(() -> {
                    try {
                        LOGGER.debug("\ud83d\udd28 Generating road: {} -> {}", (Object)structureConnection.from(), (Object)structureConnection.to());
                        new Road(level, structureConnection, roadConfig).generateRoad(steps);
                        LOGGER.info("\u2705 Road generation completed: {} -> {}", (Object)structureConnection.from(), (Object)structureConnection.to());
                    }
                    catch (Exception e) {
                        LOGGER.error("\u274c Error generating road {} -> {}: {}", new Object[]{structureConnection.from(), structureConnection.to(), e.getMessage(), e});
                        try {
                            ModEventHandler.markConnectionAsFailed(level, structureConnection);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to mark connection as failed", (Throwable)ex);
                        }
                    }
                    finally {
                        runningTasks.remove(taskId);
                    }
                });
                runningTasks.put(taskId, future);
            } else {
                try {
                    new Road(level, structureConnection, roadConfig).generateRoad(steps);
                }
                catch (Exception e) {
                    LOGGER.error("\u274c Error generating road: {}", (Object)e.getMessage(), (Object)e);
                    ModEventHandler.markConnectionAsFailed(level, structureConnection);
                }
            }
        }
    }

    private static RoadFeatureConfig getRoadFeatureConfig(class_3218 level) {
        try {
            class_3037 class_30372;
            if (level.method_30349() == null) {
                LOGGER.debug("RoadWeaver: RegistryAccess is null");
                return null;
            }
            Optional registry = level.method_30349().method_33310(class_7924.field_41239);
            if (registry.isEmpty()) {
                LOGGER.debug("RoadWeaver: ConfiguredFeature registry is not available");
                return null;
            }
            class_2975 feature = (class_2975)((class_2378)registry.get()).method_29107(RoadFeature.ROAD_FEATURE_KEY);
            if (feature != null && (class_30372 = feature.comp_333()) instanceof RoadFeatureConfig) {
                RoadFeatureConfig cfg = (RoadFeatureConfig)class_30372;
                LOGGER.debug("RoadWeaver: Using registered RoadFeatureConfig");
                return cfg;
            }
            LOGGER.debug("RoadWeaver: ConfiguredFeature {} missing or invalid, using fallback", (Object)RoadFeature.ROAD_FEATURE_KEY.method_29177());
            return ModEventHandler.defaultRoadConfig();
        }
        catch (Exception e) {
            LOGGER.debug("RoadWeaver: Exception while getting RoadFeatureConfig: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static RoadFeatureConfig defaultRoadConfig() {
        List<List<class_2680>> artificialMaterials = List.of(List.of(class_2246.field_37557.method_9564(), class_2246.field_37556.method_9564()), List.of(class_2246.field_10093.method_9564(), class_2246.field_10056.method_9564()), List.of(class_2246.field_10056.method_9564(), class_2246.field_10065.method_9564(), class_2246.field_10416.method_9564()));
        List<List<class_2680>> naturalMaterials = List.of(List.of(class_2246.field_10253.method_9564(), class_2246.field_28685.method_9564(), class_2246.field_37556.method_9564()), List.of(class_2246.field_10445.method_9564(), class_2246.field_9989.method_9564(), class_2246.field_10416.method_9564()), List.of(class_2246.field_10194.method_9564(), class_2246.field_10253.method_9564(), class_2246.field_37556.method_9564()));
        List<Integer> widths = List.of(Integer.valueOf(3));
        List<Integer> qualities = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9));
        return new RoadFeatureConfig(artificialMaterials, naturalMaterials, widths, qualities);
    }

    private static void markConnectionAsFailed(class_3218 level, Records.StructureConnection structureConnection) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        ArrayList connections = dataProvider.getStructureConnections(level);
        ArrayList<Records.StructureConnection> mutableConnections = new ArrayList<Records.StructureConnection>(connections != null ? connections : new ArrayList());
        for (int i = 0; i < mutableConnections.size(); ++i) {
            Records.StructureConnection conn = (Records.StructureConnection)mutableConnections.get(i);
            if ((!conn.from().equals((Object)structureConnection.from()) || !conn.to().equals((Object)structureConnection.to())) && (!conn.from().equals((Object)structureConnection.to()) || !conn.to().equals((Object)structureConnection.from()))) continue;
            mutableConnections.set(i, new Records.StructureConnection(conn.from(), conn.to(), Records.ConnectionStatus.FAILED, conn.manual()));
            dataProvider.setStructureConnections(level, mutableConnections);
            LOGGER.info("Marked connection as FAILED: {} -> {}", (Object)conn.from(), (Object)conn.to());
            break;
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(128);
            LOGGER.debug("RoadWeaver: ExecutorService restarted.");
        }
    }

    private static void restoreUnfinishedRoads(class_3218 level) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> connections = dataProvider.getStructureConnections(level);
        int restoredCount = 0;
        ArrayList<Records.StructureConnection> updatedConnections = new ArrayList<Records.StructureConnection>(connections);
        boolean needsUpdate = false;
        for (int i = 0; i < updatedConnections.size(); ++i) {
            Records.StructureConnection connection = (Records.StructureConnection)updatedConnections.get(i);
            if (connection.status() != Records.ConnectionStatus.PLANNED && connection.status() != Records.ConnectionStatus.GENERATING) continue;
            if (connection.status() == Records.ConnectionStatus.GENERATING) {
                Records.StructureConnection resetConnection = new Records.StructureConnection(connection.from(), connection.to(), Records.ConnectionStatus.PLANNED, connection.manual());
                updatedConnections.set(i, resetConnection);
                StructureConnector.getQueueForWorld(level).add(resetConnection);
                needsUpdate = true;
            } else {
                StructureConnector.getQueueForWorld(level).add(connection);
            }
            ++restoredCount;
        }
        if (needsUpdate) {
            dataProvider.setStructureConnections(level, updatedConnections);
        }
        if (restoredCount > 0) {
            LOGGER.info("RoadWeaver: \u6062\u590d\u4e86 {} \u4e2a\u672a\u5b8c\u6210\u7684\u9053\u8def\u751f\u6210\u4efb\u52a1\uff08\u961f\u5217\u5927\u5c0f: {}\uff09", (Object)restoredCount, (Object)StructureConnector.getQueueForWorld(level).size());
        }
    }
}

