/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureLocator;
import net.countered.settlementroads.helpers.async.ThrottledStructureLocator;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final ConcurrentHashMap<String, Queue<Records.StructureConnection>> worldQueues = new ConcurrentHashMap();

    public static Queue<Records.StructureConnection> getQueueForWorld(class_3218 level) {
        String worldKey = level.method_27983().method_29177().toString();
        return worldQueues.computeIfAbsent(worldKey, k -> new ConcurrentLinkedQueue());
    }

    public static void clearQueueForWorld(class_3218 level) {
        String worldKey = level.method_27983().method_29177().toString();
        Queue<Records.StructureConnection> queue = worldQueues.remove(worldKey);
        if (queue != null) {
            queue.clear();
            LOGGER.debug("Cleared queue for world: {}", (Object)worldKey);
        }
    }

    @Deprecated
    public static void cacheNewConnection(class_3218 serverWorld, boolean locateAtPlayer) {
        LOGGER.warn("\u26a0\ufe0f Using deprecated synchronous structure search - this may cause lag!");
        LOGGER.warn("\u26a0\ufe0f Consider using cacheNewConnectionAsync() instead");
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        int beforeCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        StructureLocator.locateConfiguredStructure(serverWorld, 1, locateAtPlayer);
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverWorld);
        if (structureLocationData == null) {
            LOGGER.warn(" structureLocationData is null");
            return;
        }
        List<class_2338> locations = structureLocationData.structureLocations();
        int afterCount = locations.size();
        LOGGER.debug("Structure count: before={}, after={}", (Object)beforeCount, (Object)afterCount);
        if (locations == null || locations.size() < 2) {
            LOGGER.debug(" Not enough structures to create connection (need 2, have {})", (Object)locations.size());
            return;
        }
        StructureConnector.createNewStructureConnection(serverWorld);
    }

    public static void cacheNewConnectionAsync(class_3218 serverWorld, boolean locateAtPlayer) {
        LOGGER.debug("\ud83d\udd0d Queuing structure search request, locateAtPlayer={}", (Object)locateAtPlayer);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        int beforeCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        ThrottledStructureLocator.locateAsync(serverWorld, 1, locateAtPlayer, results -> {
            if (results.isEmpty()) {
                LOGGER.debug("Structure search found no new structures");
                return;
            }
            Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverWorld);
            if (structureLocationData == null) {
                LOGGER.warn("structureLocationData is null after search");
                return;
            }
            List<class_2338> locations = structureLocationData.structureLocations();
            int afterCount = locations.size();
            LOGGER.debug("\u2705 Structure search completed: before={}, after={}, found={}", new Object[]{beforeCount, afterCount, results.size()});
            if (locations.size() >= 2) {
                StructureConnector.createNewStructureConnection(serverWorld);
            } else {
                LOGGER.debug("Not enough structures to create connection (need 2, have {})", (Object)locations.size());
            }
        });
    }

    private static void createNewStructureConnection(class_3218 serverWorld) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverWorld);
        if (structureLocationData == null) {
            return;
        }
        List<class_2338> worldStructureLocations = structureLocationData.structureLocations();
        if (worldStructureLocations == null || worldStructureLocations.size() < 2) {
            return;
        }
        class_2338 latestVillagePos = worldStructureLocations.get(worldStructureLocations.size() - 1);
        class_2338 closestVillage = StructureConnector.findClosestStructure(latestVillagePos, worldStructureLocations);
        if (closestVillage != null) {
            ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(Optional.ofNullable(dataProvider.getStructureConnections(serverWorld)).orElseGet(ArrayList::new));
            if (!StructureConnector.connectionExists(connections, latestVillagePos, closestVillage)) {
                Records.StructureConnection structureConnection = new Records.StructureConnection(latestVillagePos, closestVillage);
                connections.add(structureConnection);
                dataProvider.setStructureConnections(serverWorld, connections);
                Queue<Records.StructureConnection> queue = StructureConnector.getQueueForWorld(serverWorld);
                queue.add(structureConnection);
                double distance = Math.sqrt(latestVillagePos.method_10262((class_2382)closestVillage));
                LOGGER.info(" Created connection between {} and {} (distance: {} blocks, queue size: {})", new Object[]{latestVillagePos, closestVillage, (int)Math.round(distance), queue.size()});
            } else {
                LOGGER.debug("Connection already exists between {} and {}", (Object)latestVillagePos, (Object)closestVillage);
            }
        } else {
            LOGGER.warn(" Could not find closest structure for {}", (Object)latestVillagePos);
        }
    }

    private static boolean connectionExists(List<Records.StructureConnection> existingConnections, class_2338 a, class_2338 b) {
        for (Records.StructureConnection connection : existingConnections) {
            if ((!connection.from().equals((Object)a) || !connection.to().equals((Object)b)) && (!connection.from().equals((Object)b) || !connection.to().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static class_2338 findClosestStructure(class_2338 currentVillage, List<class_2338> allVillages) {
        class_2338 closestVillage = null;
        double minDistance = Double.MAX_VALUE;
        for (class_2338 village : allVillages) {
            double distance;
            if (village.equals((Object)currentVillage) || !((distance = currentVillage.method_10262((class_2382)village)) < minDistance)) continue;
            minDistance = distance;
            closestVillage = village;
        }
        return closestVillage;
    }
}

