/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers.async;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledStructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final int MAX_SEARCHES_PER_TICK = 1;
    private static final ConcurrentHashMap<String, Queue<LocateRequest>> pendingRequests = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, LocateStats> stats = new ConcurrentHashMap();

    public static void locateAsync(class_3218 level, int locateCount, boolean locateAtPlayer, Consumer<List<LocateResult>> callback) {
        if (locateCount <= 0) {
            if (callback != null) {
                callback.accept(Collections.emptyList());
            }
            return;
        }
        String worldKey = level.method_27983().method_29177().toString();
        LocateRequest request = new LocateRequest(level, locateCount, locateAtPlayer, callback);
        Queue queue = pendingRequests.computeIfAbsent(worldKey, k -> new ConcurrentLinkedQueue());
        queue.add(request);
        LocateStats stat = stats.computeIfAbsent(worldKey, k -> new LocateStats());
        ++stat.queuedRequests;
        LOGGER.debug("\ud83d\udd0d Queued structure search request: world={}, count={}, queueSize={}", new Object[]{worldKey, locateCount, queue.size()});
    }

    public static void tickProcess(class_3218 level) {
        String worldKey = level.method_27983().method_29177().toString();
        Queue<LocateRequest> queue = pendingRequests.get(worldKey);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        int processed = 0;
        while (processed < 1 && !queue.isEmpty()) {
            LocateRequest request = queue.poll();
            if (request == null) continue;
            try {
                ThrottledStructureLocator.processRequest(request);
                ++processed;
            }
            catch (Exception e) {
                LOGGER.error("\u274c Error processing locate request: {}", (Object)e.getMessage(), (Object)e);
                if (request.callback == null) continue;
                request.callback.accept(Collections.emptyList());
            }
        }
        if (processed > 0) {
            LocateStats stat = stats.get(worldKey);
            if (stat != null) {
                stat.processedRequests += processed;
            }
            LOGGER.trace("Processed {} structure search requests, {} remaining in queue", (Object)processed, (Object)queue.size());
        }
    }

    private static void processRequest(LocateRequest request) {
        class_3218 level = request.level;
        int locateCount = request.locateCount;
        boolean locateAtPlayer = request.locateAtPlayer;
        ArrayList<LocateResult> results = new ArrayList<LocateResult>();
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData locationData = dataProvider.getStructureLocations(level);
        if (locationData == null) {
            locationData = new Records.StructureLocationData(new ArrayList<class_2338>());
        }
        ArrayList<class_2338> knownLocations = new ArrayList<class_2338>(locationData.structureLocations());
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>(locationData.structureInfos());
        Optional<class_6885<class_3195>> targetStructures = ThrottledStructureLocator.resolveStructureTargets(level, config.structuresToLocate());
        if (targetStructures.isEmpty()) {
            LOGGER.warn("\u65e0\u6cd5\u89e3\u6790\u7ed3\u6784\u76ee\u6807\u5217\u8868\uff0c\u8df3\u8fc7\u641c\u5bfb");
            if (request.callback != null) {
                request.callback.accept(results);
            }
            return;
        }
        List<class_2338> centers = ThrottledStructureLocator.collectSearchCenters(level, locateAtPlayer);
        int radius = Math.max(config.structureSearchRadius(), 1);
        for (class_2338 center : centers) {
            if (locateCount <= 0) break;
            try {
                Pair result = level.method_14178().method_12129().method_12103(level, targetStructures.get(), center, radius, true);
                if (result == null) continue;
                class_2338 structurePos = (class_2338)result.getFirst();
                class_6880 structureHolder = (class_6880)result.getSecond();
                if (ThrottledStructureLocator.containsBlockPos(knownLocations, structurePos)) continue;
                knownLocations.add(structurePos);
                String structureId = structureHolder.method_40230().map(key -> key.method_29177().toString()).orElse("unknown");
                Records.StructureInfo info = new Records.StructureInfo(structurePos, structureId);
                structureInfos.add(info);
                results.add(new LocateResult(structurePos, structureId, true));
                --locateCount;
                LOGGER.debug("\u2705 Found structure {} at {}", (Object)structureId, (Object)structurePos);
            }
            catch (Exception e) {
                LOGGER.error("Error finding structure at {}: {}", (Object)center, (Object)e.getMessage());
            }
        }
        if (!results.isEmpty()) {
            dataProvider.setStructureLocations(level, new Records.StructureLocationData(knownLocations, structureInfos));
            LOGGER.info("Located {} new structures", (Object)results.size());
        }
        if (request.callback != null) {
            request.callback.accept(results);
        }
    }

    public static int getPendingCount(class_3218 level) {
        String worldKey = level.method_27983().method_29177().toString();
        Queue<LocateRequest> queue = pendingRequests.get(worldKey);
        return queue != null ? queue.size() : 0;
    }

    public static void clearQueue(class_3218 level) {
        String worldKey = level.method_27983().method_29177().toString();
        Queue<LocateRequest> queue = pendingRequests.remove(worldKey);
        if (queue != null) {
            queue.clear();
            LOGGER.debug("Cleared structure search queue for world: {}", (Object)worldKey);
        }
        stats.remove(worldKey);
    }

    public static void shutdown() {
        pendingRequests.clear();
        stats.clear();
        LOGGER.info("ThrottledStructureLocator shut down");
    }

    private static Optional<class_6885<class_3195>> resolveStructureTargets(class_3218 level, List<String> identifiersList) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        ArrayList holders = new ArrayList();
        if (identifiersList == null || identifiersList.isEmpty()) {
            return Optional.empty();
        }
        for (String line : identifiersList) {
            String[] tokens;
            String norm;
            if (line == null || (norm = line.replace('\r', ' ').replace('\n', ' ').trim()).isEmpty()) continue;
            for (String raw : tokens = norm.split("[;,\\s]+")) {
                String token;
                if (raw == null || (token = raw.trim()).isEmpty()) continue;
                token = token.replace("\r", "").replace("\n", "");
                token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
                if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                    token = token.substring(1);
                }
                if ((token = token.replace('\uff03', '#').trim()).isEmpty()) continue;
                int hashIdx = token.indexOf(35);
                if (hashIdx >= 0) {
                    String tagToken = token.substring(hashIdx + 1).trim();
                    try {
                        class_2960 tagId = new class_2960(tagToken);
                        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagId);
                        registry.method_40266(tag).ifPresent(named -> {
                            for (class_6880 h : named) {
                                holders.add(h);
                            }
                        });
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Invalid structure tag: #{}", (Object)tagToken);
                    }
                    continue;
                }
                try {
                    String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                    if (cleaned.contains("*")) {
                        String pattern = cleaned.replace("*", "");
                        for (Map.Entry entry : registry.method_29722()) {
                            String structureId = ((class_5321)entry.getKey()).method_29177().toString();
                            if (!structureId.startsWith(pattern)) continue;
                            registry.method_40264((class_5321)entry.getKey()).ifPresent(holders::add);
                        }
                        continue;
                    }
                    class_2960 id = new class_2960(cleaned);
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)id);
                    registry.method_40264(key).ifPresent(holders::add);
                }
                catch (Exception ex) {
                    LOGGER.warn("Invalid structure id: {}", (Object)token);
                }
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(class_6885.method_40242(holders));
    }

    private static List<class_2338> collectSearchCenters(class_3218 level, boolean locateAtPlayer) {
        ArrayList<class_2338> centers = new ArrayList<class_2338>();
        if (locateAtPlayer) {
            for (class_3222 player : level.method_18456()) {
                centers.add(player.method_24515());
            }
        }
        class_2338 spawn = level.method_43126();
        if (centers.isEmpty()) {
            int[] muls;
            centers.add(spawn);
            int r = Math.max(ConfigProvider.get().structureSearchRadius(), 1);
            for (int m : muls = new int[]{3, 6}) {
                int d = r * m;
                centers.add(spawn.method_10069(d, 0, 0));
                centers.add(spawn.method_10069(-d, 0, 0));
                centers.add(spawn.method_10069(0, 0, d));
                centers.add(spawn.method_10069(0, 0, -d));
                centers.add(spawn.method_10069(d, 0, d));
                centers.add(spawn.method_10069(-d, 0, d));
                centers.add(spawn.method_10069(d, 0, -d));
                centers.add(spawn.method_10069(-d, 0, -d));
            }
        }
        return centers;
    }

    private static boolean containsBlockPos(List<class_2338> list, class_2338 pos) {
        for (class_2338 existing : list) {
            if (!existing.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private static class LocateRequest {
        final class_3218 level;
        final int locateCount;
        final boolean locateAtPlayer;
        final Consumer<List<LocateResult>> callback;

        LocateRequest(class_3218 level, int locateCount, boolean locateAtPlayer, Consumer<List<LocateResult>> callback) {
            this.level = level;
            this.locateCount = locateCount;
            this.locateAtPlayer = locateAtPlayer;
            this.callback = callback;
        }
    }

    private static class LocateStats {
        int queuedRequests = 0;
        int processedRequests = 0;

        private LocateStats() {
        }
    }

    public static class LocateResult {
        public final class_2338 position;
        public final String structureId;
        public final boolean success;

        public LocateResult(class_2338 position, String structureId, boolean success) {
            this.position = position;
            this.structureId = structureId;
            this.success = success;
        }
    }
}

