/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class DebugDataPacket {
    private final List<Records.StructureInfo> structureInfos;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;

    public DebugDataPacket(List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        this.structureInfos = structureInfos != null ? structureInfos : new ArrayList();
        this.connections = connections != null ? connections : new ArrayList();
        this.roads = roads != null ? roads : new ArrayList();
    }

    public List<Records.StructureInfo> getStructureInfos() {
        return this.structureInfos;
    }

    public List<Records.StructureConnection> getConnections() {
        return this.connections;
    }

    public List<Records.RoadData> getRoads() {
        return this.roads;
    }

    public class_2540 encode() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(this.structureInfos.size());
        for (Records.StructureInfo info : this.structureInfos) {
            buf.method_10807(info.pos());
            buf.method_10814(info.structureId());
        }
        buf.writeInt(this.connections.size());
        for (Records.StructureConnection conn : this.connections) {
            buf.method_10807(conn.from());
            buf.method_10807(conn.to());
            buf.method_10814(conn.status().name());
            buf.writeBoolean(conn.manual());
        }
        buf.writeInt(this.roads.size());
        for (Records.RoadData road : this.roads) {
            buf.writeInt(road.width());
            buf.writeInt(road.roadType());
            List<Records.RoadSegmentPlacement> segments = road.roadSegmentList();
            buf.writeInt(segments.size());
            for (Records.RoadSegmentPlacement segment : segments) {
                buf.method_10807(segment.middlePos());
            }
        }
        return buf;
    }

    public static DebugDataPacket decode(class_2540 buf) {
        int structureCount = buf.readInt();
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>();
        for (int i = 0; i < structureCount; ++i) {
            class_2338 pos = buf.method_10811();
            String structureId = buf.method_19772();
            structureInfos.add(new Records.StructureInfo(pos, structureId));
        }
        int connectionCount = buf.readInt();
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>();
        for (int i = 0; i < connectionCount; ++i) {
            class_2338 from = buf.method_10811();
            class_2338 to = buf.method_10811();
            String statusStr = buf.method_19772();
            boolean manual = buf.readBoolean();
            Records.ConnectionStatus status = Records.ConnectionStatus.valueOf(statusStr);
            connections.add(new Records.StructureConnection(from, to, status, manual));
        }
        int roadCount = buf.readInt();
        ArrayList<Records.RoadData> roads = new ArrayList<Records.RoadData>();
        for (int i = 0; i < roadCount; ++i) {
            int width = buf.readInt();
            int roadType = buf.readInt();
            int segmentCount = buf.readInt();
            ArrayList<Records.RoadSegmentPlacement> segments = new ArrayList<Records.RoadSegmentPlacement>();
            for (int j = 0; j < segmentCount; ++j) {
                class_2338 middlePos = buf.method_10811();
                segments.add(new Records.RoadSegmentPlacement(middlePos, new ArrayList<class_2338>()));
            }
            roads.add(new Records.RoadData(width, roadType, new ArrayList<class_2680>(), segments));
        }
        return new DebugDataPacket(structureInfos, connections, roads);
    }
}

