/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.shiroha233.roadweaver.config.PresetService;

public class MaterialPresetEditorScreen
extends class_437 {
    private static final int MAX_MATERIALS = 16;
    private static final int LEFT_COLS = 4;
    private static final int LEFT_ROWS = 4;
    private static final int RIGHT_COLS = 25;
    private static final int RIGHT_ROWS = 20;
    private static final int SLOT_SIZE = 18;
    private final class_437 parent;
    private class_342 searchBox;
    private class_342 presetNameBox;
    private final List<String> materialIds = new ArrayList<String>();
    private final List<class_2248> allBlocks = new ArrayList<class_2248>();
    private final List<class_2248> filteredBlocks = new ArrayList<class_2248>();
    private int blockScrollOffset = 0;
    private int visibleRightRows = 20;
    private int visibleRightCols = 25;
    private final List<UiPreset> presets = new ArrayList<UiPreset>();
    private final List<String> originalPresetIds = new ArrayList<String>();
    private int activePresetIndex = 0;
    private final List<class_4185> presetButtons = new ArrayList<class_4185>();
    private boolean loadedFromConfig = false;

    public MaterialPresetEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        if (!this.loadedFromConfig) {
            this.loadPresetsFromJson();
            this.loadedFromConfig = true;
        }
        if (this.allBlocks.isEmpty()) {
            this.buildCandidateBlocksFromCreativeTabs();
        }
        int centerX = this.field_22789 / 2;
        int top = 40;
        int gridTop = 70;
        int actionY = this.field_22790 - 60;
        int availableHeight = Math.max(0, actionY - gridTop);
        this.visibleRightRows = Math.max(3, Math.min(20, availableHeight / 18));
        if (this.visibleRightRows <= 0) {
            this.visibleRightRows = 1;
        }
        int rightAreaX = centerX - 10;
        int marginRight = 20;
        int availableWidth = Math.max(1, this.field_22789 - marginRight - rightAreaX);
        int colsByWidth = Math.max(1, availableWidth / 18);
        this.visibleRightCols = Math.min(25, colsByWidth);
        this.searchBox = new class_342(this.field_22793, centerX - 80, top, 160, 20, (class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.search"));
        this.searchBox.method_1880(64);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        int presetWidth = 120;
        int presetsLeftX = centerX - 260;
        this.presetNameBox = new class_342(this.field_22793, presetsLeftX, top, presetWidth, 20, (class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.name"));
        this.presetNameBox.method_1880(32);
        this.presetNameBox.method_1852(this.getActivePresetName());
        this.method_37063((class_364)this.presetNameBox);
        this.presetButtons.clear();
        for (int i = 0; i < this.presets.size(); ++i) {
            int idx = i;
            UiPreset p = this.presets.get(i);
            class_4185 btn2 = class_4185.method_46430((class_2561)class_2561.method_43470((String)p.name), b -> this.selectPreset(idx)).method_46434(presetsLeftX, gridTop + i * 22, presetWidth, 20).method_46431();
            this.presetButtons.add(btn2);
            this.method_37063((class_364)btn2);
        }
        this.updatePresetButtonStates();
        int smallWidth = 50;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.new"), b -> this.onNewPreset()).method_46434(presetsLeftX, actionY, smallWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.rename"), b -> this.onRenamePreset()).method_46434(presetsLeftX + smallWidth + 4, actionY, smallWidth + 10, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.preset_editor.delete"), b -> this.onDeletePreset()).method_46434(presetsLeftX + smallWidth * 2 + 8 + 10, actionY, smallWidth + 10, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.common.save"), btn -> this.onSave()).method_46434(centerX - 80, this.field_22790 - 30, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.common.cancel"), btn -> this.onCancel()).method_46434(centerX + 10, this.field_22790 - 30, 70, 20).method_46431());
        this.rebuildFilteredList();
    }

    private void onSearchChanged(String text) {
        this.blockScrollOffset = 0;
        this.rebuildFilteredList();
    }

    private void rebuildFilteredList() {
        this.filteredBlocks.clear();
        String q = this.searchBox == null ? "" : this.searchBox.method_1882().trim().toLowerCase();
        for (class_2248 b : this.allBlocks) {
            class_2960 id = class_7923.field_41175.method_10221((Object)b);
            if (id == null || !q.isEmpty() && !id.toString().toLowerCase().contains(q)) continue;
            this.filteredBlocks.add(b);
        }
    }

    private void loadPresetsFromJson() {
        this.presets.clear();
        this.originalPresetIds.clear();
        PresetService.reload();
        List<PresetService.PresetDef> defs = PresetService.getAllPresets();
        for (PresetService.PresetDef def : defs) {
            UiPreset p = new UiPreset();
            p.id = def.id();
            p.name = def.name();
            p.materials = new ArrayList<String>(def.materials());
            p.weight = def.weight();
            this.presets.add(p);
            this.originalPresetIds.add(p.id);
        }
        if (this.presets.isEmpty()) {
            UiPreset p = new UiPreset();
            p.id = "custom_1";
            p.name = "Custom 1";
            p.materials = new ArrayList<String>();
            p.weight = 1;
            this.presets.add(p);
        }
        if (this.activePresetIndex < 0 || this.activePresetIndex >= this.presets.size()) {
            this.activePresetIndex = 0;
        }
        this.materialIds.clear();
        this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
        if (this.materialIds.size() > 16) {
            this.materialIds.subList(16, this.materialIds.size()).clear();
        }
    }

    private String getActivePresetName() {
        if (this.presets.isEmpty()) {
            return "";
        }
        int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
        return this.presets.get((int)idx).name;
    }

    private void syncActivePresetFromUi() {
        String nameFromBox;
        if (this.presets.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
        UiPreset active = this.presets.get(idx);
        String string = nameFromBox = this.presetNameBox != null ? this.presetNameBox.method_1882().trim() : active.name;
        if (nameFromBox == null || nameFromBox.isBlank()) {
            nameFromBox = active.name;
        }
        active.name = nameFromBox;
        ArrayList<String> copy = new ArrayList<String>(this.materialIds);
        if (copy.size() > 16) {
            copy = new ArrayList(copy.subList(0, 16));
        }
        active.materials = copy;
    }

    private String generateNewPresetId() {
        int idx = 1;
        while (true) {
            String candidate = "custom_" + idx;
            boolean exists = false;
            for (UiPreset p : this.presets) {
                if (!candidate.equals(p.id)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                return candidate;
            }
            ++idx;
        }
    }

    private void selectPreset(int index) {
        if (index < 0 || index >= this.presets.size()) {
            return;
        }
        this.syncActivePresetFromUi();
        this.activePresetIndex = index;
        this.materialIds.clear();
        this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
        if (this.materialIds.size() > 16) {
            this.materialIds.subList(16, this.materialIds.size()).clear();
        }
        if (this.presetNameBox != null) {
            this.presetNameBox.method_1852(this.getActivePresetName());
        }
        this.updatePresetButtonStates();
    }

    private void updatePresetButtonStates() {
        for (int i = 0; i < this.presetButtons.size(); ++i) {
            class_4185 btn = this.presetButtons.get(i);
            if (btn == null) continue;
            boolean isActive = i == this.activePresetIndex;
            boolean bl = btn.field_22763 = !isActive;
            if (i >= this.presets.size()) continue;
            btn.method_25355((class_2561)class_2561.method_43470((String)this.presets.get((int)i).name));
        }
    }

    private void onNewPreset() {
        this.syncActivePresetFromUi();
        String baseName = class_2561.method_43471((String)"gui.roadweaver.preset_editor.default_name").getString();
        if (baseName == null || baseName.isBlank()) {
            baseName = "Preset";
        }
        String name = baseName + " " + (this.presets.size() + 1);
        String id = this.generateNewPresetId();
        UiPreset p = new UiPreset();
        p.id = id;
        p.name = name;
        p.materials = new ArrayList<String>();
        p.weight = 1;
        this.presets.add(p);
        this.activePresetIndex = this.presets.size() - 1;
        this.materialIds.clear();
        if (this.presetNameBox != null) {
            this.presetNameBox.method_1852(name);
        }
        this.method_25426();
    }

    private void onRenamePreset() {
        if (this.presets.isEmpty()) {
            return;
        }
        if (this.presetNameBox == null) {
            return;
        }
        String name = this.presetNameBox.method_1882().trim();
        if (name.isEmpty()) {
            return;
        }
        this.presets.get((int)this.activePresetIndex).name = name;
        this.updatePresetButtonStates();
    }

    private void onDeletePreset() {
        if (this.presets.isEmpty()) {
            return;
        }
        this.presets.remove(this.activePresetIndex);
        if (this.presets.isEmpty()) {
            UiPreset p = new UiPreset();
            p.id = "custom_1";
            p.name = "Custom 1";
            p.materials = new ArrayList<String>();
            p.weight = 1;
            this.presets.add(p);
            this.activePresetIndex = 0;
            this.materialIds.clear();
        } else {
            if (this.activePresetIndex >= this.presets.size()) {
                this.activePresetIndex = this.presets.size() - 1;
            }
            this.materialIds.clear();
            this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
            if (this.materialIds.size() > 16) {
                this.materialIds.subList(16, this.materialIds.size()).clear();
            }
        }
        if (this.presetNameBox != null) {
            this.presetNameBox.method_1852(this.getActivePresetName());
        }
        this.method_25426();
    }

    private void buildCandidateBlocksFromCreativeTabs() {
        this.allBlocks.clear();
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || mc.field_1724.method_37908() == null) {
            for (class_2248 b : class_7923.field_41175) {
                if (b == class_2246.field_10124) continue;
                this.allBlocks.add(b);
            }
            return;
        }
        class_7699 features = mc.field_1724.field_3944.method_45735();
        boolean hasPermissions = mc.field_1724.method_7338();
        class_5455 registries = mc.field_1724.method_37908().method_30349();
        class_7706.method_47330((class_7699)features, (boolean)hasPermissions, (class_7225.class_7874)registries);
        LinkedHashSet<class_2248> unique = new LinkedHashSet<class_2248>();
        this.addBlocksFromTab(unique, "building_blocks");
        this.addBlocksFromTab(unique, "natural_blocks");
        if (unique.isEmpty()) {
            for (class_2248 b : class_7923.field_41175) {
                if (b == class_2246.field_10124) continue;
                unique.add(b);
            }
        }
        this.allBlocks.addAll(unique);
    }

    private void addBlocksFromTab(Set<class_2248> out, String tabId) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960(tabId));
        class_1761 tab = (class_1761)class_7923.field_44687.method_29107(key);
        if (tab == null) {
            return;
        }
        for (class_1799 stack : tab.method_47313()) {
            class_1747 blockItem;
            class_2248 block;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof class_1747) || (block = (blockItem = (class_1747)class_17922).method_7711()) == class_2246.field_10124) continue;
            out.add(block);
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        super.method_25394(g, mouseX, mouseY, partialTick);
        int centerX = this.field_22789 / 2;
        int leftAreaX = centerX - 140;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        this.renderMaterialsGrid(g, leftAreaX, gridTop, mouseX, mouseY);
        this.renderBlocksGrid(g, rightAreaX, gridTop, mouseX, mouseY);
    }

    private void renderMaterialsGrid(class_332 g, int startX, int startY, int mouseX, int mouseY) {
        int index = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                class_2248 b;
                int x = startX + col * 18;
                int y = startY + row * 18;
                g.method_25294(x, y, x + 18, y + 18, Integer.MIN_VALUE);
                if (index < this.materialIds.size() && (b = this.blockFromId(this.materialIds.get(index))) != null && b != class_2246.field_10124) {
                    class_1799 stack = new class_1799((class_1935)b);
                    g.method_51445(stack, x + 1, y + 1);
                }
                ++index;
            }
        }
    }

    private void renderBlocksGrid(class_332 g, int startX, int startY, int mouseX, int mouseY) {
        int indexBase;
        int rows = this.visibleRightRows;
        int cols = this.visibleRightCols;
        int maxOffset = Math.max(0, (this.filteredBlocks.size() + cols - 1) / cols - rows);
        if (this.blockScrollOffset > maxOffset) {
            this.blockScrollOffset = maxOffset;
        }
        if (this.blockScrollOffset < 0) {
            this.blockScrollOffset = 0;
        }
        int rowOffset = this.blockScrollOffset;
        int index = indexBase = rowOffset * cols;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                g.method_25294(x, y, x + 18, y + 18, Integer.MIN_VALUE);
                if (index < this.filteredBlocks.size()) {
                    class_2248 b = this.filteredBlocks.get(index);
                    class_1799 stack = new class_1799((class_1935)b);
                    g.method_51445(stack, x + 1, y + 1);
                }
                ++index;
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int centerX = this.field_22789 / 2;
        int leftAreaX = centerX - 140;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        if (this.handleClickMaterials(mouseX, mouseY, leftAreaX, gridTop, button)) {
            return true;
        }
        return this.handleClickBlocks(mouseX, mouseY, rightAreaX, gridTop, button);
    }

    private boolean handleClickMaterials(double mouseX, double mouseY, int startX, int startY, int button) {
        int index = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                if (mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
                    if (button == 0 && index < this.materialIds.size()) {
                        this.materialIds.remove(index);
                        return true;
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private boolean handleClickBlocks(double mouseX, double mouseY, int startX, int startY, int button) {
        int indexBase;
        int rowOffset = this.blockScrollOffset;
        int cols = this.visibleRightCols;
        int index = indexBase = rowOffset * cols;
        for (int row = 0; row < this.visibleRightRows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                if (mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
                    if (index < this.filteredBlocks.size() && button == 0) {
                        class_2248 b;
                        class_2960 id;
                        if (this.materialIds.size() < 16 && (id = class_7923.field_41175.method_10221((Object)(b = this.filteredBlocks.get(index)))) != null) {
                            this.materialIds.add(id.toString());
                        }
                        return true;
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int centerX = this.field_22789 / 2;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        int widthPx = this.visibleRightCols * 18;
        int heightPx = this.visibleRightRows * 18;
        int x0 = rightAreaX;
        int y0 = gridTop;
        if (mouseX >= (double)x0 && mouseX < (double)(x0 + widthPx) && mouseY >= (double)y0 && mouseY < (double)(y0 + heightPx)) {
            if (delta > 0.0) {
                --this.blockScrollOffset;
            }
            if (delta < 0.0) {
                ++this.blockScrollOffset;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private class_2248 blockFromId(String id) {
        try {
            class_2960 rl = new class_2960(id);
            return (class_2248)class_7923.field_41175.method_10223(rl);
        }
        catch (Exception e) {
            return class_2246.field_10124;
        }
    }

    private void onSave() {
        if (!this.presets.isEmpty()) {
            String name;
            int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
            UiPreset active = this.presets.get(idx);
            String string = name = this.presetNameBox != null ? this.presetNameBox.method_1882().trim() : active.name;
            if (name == null || name.isBlank()) {
                name = active.name;
            }
            active.name = name;
            active.materials = new ArrayList<String>(this.materialIds);
        }
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>();
        for (UiPreset p : this.presets) {
            if (p.id == null || p.id.isBlank()) continue;
            currentIds.add(p.id);
        }
        for (String id : this.originalPresetIds) {
            if (currentIds.contains(id)) continue;
            PresetService.deletePresetFile(id);
        }
        for (UiPreset p : this.presets) {
            if (p.id == null || p.id.isBlank()) continue;
            PresetService.saveOrUpdatePresetFile(p.id, p.name, p.materials, p.weight <= 0 ? 1 : p.weight);
        }
        PresetService.reload();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void onCancel() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static class UiPreset {
        String id;
        String name;
        List<String> materials = new ArrayList<String>();
        int weight;

        private UiPreset() {
        }
    }
}

