/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.search.StructurePredictor;
import net.shiroha233.roadweaver.search.StructureVerificationService;

public final class MapDataCollector {
    private static final int MAX_DETAILED_ROAD_SPAN_BLOCKS = 7680;

    private MapDataCollector() {
    }

    public static MapSnapshot build(class_3218 level) {
        List<Records.StructureInfo> predicted;
        List<Records.StructureInfo> verified;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        ArrayList<class_2338> structures = loc != null ? new ArrayList<class_2338>(loc.structureLocations()) : new ArrayList();
        ArrayList<Records.StructureConnection> conns = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        ArrayList<Records.StructureInfo> infos = loc != null ? new ArrayList<Records.StructureInfo>(loc.structureInfos()) : new ArrayList();
        ArrayList<List<class_2338>> roads = new ArrayList<List<class_2338>>();
        ModConfig cfg = ConfigService.get();
        class_2338 spawn = level.method_43126();
        int radiusChunks = Math.max(1, cfg.initialPlanRadiusChunks());
        int minX = ((spawn.method_10263() >> 4) - radiusChunks) * 16;
        int maxX = ((spawn.method_10263() >> 4) + radiusChunks) * 16;
        int minZ = ((spawn.method_10260() >> 4) - radiusChunks) * 16;
        int maxZ = ((spawn.method_10260() >> 4) + radiusChunks) * 16;
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minX, minZ, maxX, maxZ);
        for (Records.RoadData rd : roadDataList) {
            List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
            if (segs == null || segs.isEmpty()) continue;
            ArrayList<class_2338> poly = new ArrayList<class_2338>(segs.size());
            for (Records.RoadSegmentPlacement sp : segs) {
                poly.add(sp.middlePos());
            }
            if (poly.size() < 2) continue;
            roads.add(poly);
        }
        if (class_1937.field_25179.equals(level.method_27983()) && cfg.villagePredictionEnabled() && !(verified = StructureVerificationService.verifyPredictedStructures(level, predicted = StructurePredictor.predictOverworldStructuresAroundSpawn(level, cfg.predictRadiusChunks(), cfg.biomePrefilter(), cfg.structureWhitelist(), cfg.structureBlacklist()))).isEmpty()) {
            HashSet<class_2338> existing = new HashSet<class_2338>(structures);
            for (Records.StructureInfo info : verified) {
                class_2338 p = info.pos();
                if (existing.contains(p)) continue;
                structures.add(p);
                infos.add(info);
                existing.add(p);
            }
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }

    public static MapSnapshot build(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int cmaxz;
        int cmaxx;
        int cminz;
        int cminx;
        List<Records.StructureInfo> predicted;
        List<Records.StructureInfo> verified;
        ModConfig cfg;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        ArrayList<class_2338> structures = new ArrayList<class_2338>();
        if (loc != null && loc.structureLocations() != null) {
            for (class_2338 p : loc.structureLocations()) {
                int x = p.method_10263();
                int z = p.method_10260();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                structures.add(p);
            }
        }
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                boolean inb;
                class_2338 a = c.from();
                class_2338 b = c.to();
                boolean ina = a.method_10263() >= minBlockX && a.method_10263() <= maxBlockX && a.method_10260() >= minBlockZ && a.method_10260() <= maxBlockZ;
                boolean bl = inb = b.method_10263() >= minBlockX && b.method_10263() <= maxBlockX && b.method_10260() >= minBlockZ && b.method_10260() <= maxBlockZ;
                if (!ina && !inb) continue;
                conns.add(c);
            }
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>();
        if (loc != null && loc.structureInfos() != null) {
            for (Records.StructureInfo info : loc.structureInfos()) {
                class_2338 p = info.pos();
                int x = p.method_10263();
                int z = p.method_10260();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                infos.add(info);
            }
        }
        if (class_1937.field_25179.equals(level.method_27983()) && (cfg = ConfigService.get()).villagePredictionEnabled() && !(verified = StructureVerificationService.verifyPredictedStructures(level, predicted = StructurePredictor.predictOverworldStructuresInRect(level, cminx = Math.floorDiv(minBlockX, 16), cminz = Math.floorDiv(minBlockZ, 16), cmaxx = Math.floorDiv(maxBlockX, 16), cmaxz = Math.floorDiv(maxBlockZ, 16), cfg.biomePrefilter(), cfg.structureWhitelist(), cfg.structureBlacklist()))).isEmpty()) {
            HashSet<class_2338> existing = new HashSet<class_2338>(structures);
            for (Records.StructureInfo info : verified) {
                class_2338 p = info.pos();
                if (existing.contains(p)) continue;
                int x = p.method_10263();
                int z = p.method_10260();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                structures.add(p);
                infos.add(info);
                existing.add(p);
            }
        }
        ArrayList<List<class_2338>> roads = new ArrayList<List<class_2338>>();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        for (Records.RoadData rd : roadDataList) {
            List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
            if (segs == null || segs.isEmpty()) continue;
            ArrayList<class_2338> poly = new ArrayList<class_2338>(segs.size());
            for (Records.RoadSegmentPlacement sp : segs) {
                class_2338 p = sp.middlePos();
                int x = p.method_10263();
                int z = p.method_10260();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                poly.add(p);
            }
            if (poly.size() < 2) continue;
            roads.add(poly);
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }

    public static MapSnapshot build(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ, int centerX, int centerZ, int radiusBlocks) {
        boolean loadDetailedRoads;
        int cmaxz;
        int cmaxx;
        int cminz;
        int cminx;
        List<Records.StructureInfo> predicted;
        List<Records.StructureInfo> verified;
        ModConfig cfg;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        long r2 = (long)Math.max(0, radiusBlocks) * (long)Math.max(0, radiusBlocks);
        BiPredicate<Integer, Integer> inAOI = (x, z) -> {
            long dz;
            if (r2 <= 0L) {
                return true;
            }
            long dx = (long)x.intValue() - (long)centerX;
            return dx * dx + (dz = (long)z.intValue() - (long)centerZ) * dz <= r2;
        };
        HashSet<class_2338> plannedEndpoints = new HashSet<class_2338>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                plannedEndpoints.add(c.from());
                plannedEndpoints.add(c.to());
            }
        }
        ModConfig cfgAll = ConfigService.get();
        int initialRadiusBlocks = Math.max(1, cfgAll.initialPlanRadiusChunks()) * 16;
        int strideChunks = RoadPlanningService.getStrideTileSizeChunks();
        int dynRadiusChunks = RoadPlanningService.getDynamicPlanRadiusChunks();
        int dynRadiusBlocks = Math.max(1, dynRadiusChunks) * 16;
        long initialR2 = (long)initialRadiusBlocks * (long)initialRadiusBlocks;
        class_2338 spawn = level.method_43126();
        ArrayList<int[]> plannedRects = new ArrayList<int[]>();
        HashSet<Long> rectKeys = new HashSet<Long>();
        Map<Long, Long> centersMap = RoadPlanningService.getPlannedTileCenters(level);
        for (Long key : RoadPlanningService.getPlannedTiles(level)) {
            int centerChunkZ;
            int centerChunkX;
            int kx = (int)(key >> 32);
            int kz = (int)(key & 0xFFFFFFFFL);
            Long cval = centersMap.get(key);
            if (cval != null) {
                centerChunkX = (int)(cval >> 32);
                centerChunkZ = (int)(cval & 0xFFFFFFFFL);
            } else {
                centerChunkX = kx * strideChunks + strideChunks / 2;
                centerChunkZ = kz * strideChunks + strideChunks / 2;
            }
            int cxBlocks = centerChunkX * 16;
            int czBlocks = centerChunkZ * 16;
            int minBx = cxBlocks - dynRadiusBlocks;
            int maxBx = cxBlocks + dynRadiusBlocks;
            int minBz = czBlocks - dynRadiusBlocks;
            int maxBz = czBlocks + dynRadiusBlocks;
            plannedRects.add(new int[]{minBx, minBz, maxBx, maxBz});
            rectKeys.add(key);
        }
        BiPredicate<Integer, Integer> inPlannedCoverage = (x, z) -> {
            long dzs;
            long dxs;
            if (class_1937.field_25179.equals(level.method_27983()) && (dxs = (long)x.intValue() - (long)spawn.method_10263()) * dxs + (dzs = (long)z.intValue() - (long)spawn.method_10260()) * dzs <= initialR2) {
                return true;
            }
            for (int[] r : plannedRects) {
                if (x < r[0] || x > r[2] || z < r[1] || z > r[3]) continue;
                return true;
            }
            return false;
        };
        ArrayList<class_2338> structures = new ArrayList<class_2338>();
        if (loc != null && loc.structureLocations() != null) {
            for (class_2338 p : loc.structureLocations()) {
                int x2 = p.method_10263();
                int z2 = p.method_10260();
                boolean inRect = x2 >= minBlockX && x2 <= maxBlockX && z2 >= minBlockZ && z2 <= maxBlockZ;
                if (!inRect || !plannedEndpoints.contains(p) && !inPlannedCoverage.test(x2, z2) && !inAOI.test(x2, z2)) continue;
                structures.add(p);
            }
        }
        if (connections != null) {
            HashSet<class_2338> existing = new HashSet<class_2338>(structures);
            for (Records.StructureConnection c : connections) {
                class_2338[] eps;
                for (class_2338 ep : eps = new class_2338[]{c.from(), c.to()}) {
                    boolean inRect;
                    int x3 = ep.method_10263();
                    int z3 = ep.method_10260();
                    boolean bl = inRect = x3 >= minBlockX && x3 <= maxBlockX && z3 >= minBlockZ && z3 <= maxBlockZ;
                    if (!inRect || existing.contains(ep)) continue;
                    structures.add(ep);
                    existing.add(ep);
                }
            }
        }
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                boolean inb;
                class_2338 a = c.from();
                class_2338 b = c.to();
                boolean ina = a.method_10263() >= minBlockX && a.method_10263() <= maxBlockX && a.method_10260() >= minBlockZ && a.method_10260() <= maxBlockZ;
                boolean bl = inb = b.method_10263() >= minBlockX && b.method_10263() <= maxBlockX && b.method_10260() >= minBlockZ && b.method_10260() <= maxBlockZ;
                if (!ina && !inb) continue;
                conns.add(c);
            }
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>();
        if (loc != null && loc.structureInfos() != null) {
            for (Records.StructureInfo info : loc.structureInfos()) {
                class_2338 p = info.pos();
                int x4 = p.method_10263();
                int z4 = p.method_10260();
                boolean inRect = x4 >= minBlockX && x4 <= maxBlockX && z4 >= minBlockZ && z4 <= maxBlockZ;
                if (!inRect || !plannedEndpoints.contains(p) && !inPlannedCoverage.test(x4, z4) && !inAOI.test(x4, z4)) continue;
                infos.add(info);
            }
        }
        if (class_1937.field_25179.equals(level.method_27983()) && (cfg = ConfigService.get()).villagePredictionEnabled() && !(verified = StructureVerificationService.verifyPredictedStructures(level, predicted = StructurePredictor.predictOverworldStructuresInRect(level, cminx = Math.floorDiv(minBlockX, 16), cminz = Math.floorDiv(minBlockZ, 16), cmaxx = Math.floorDiv(maxBlockX, 16), cmaxz = Math.floorDiv(maxBlockZ, 16), cfg.biomePrefilter(), cfg.structureWhitelist(), cfg.structureBlacklist()))).isEmpty()) {
            HashSet<class_2338> existing = new HashSet<class_2338>(structures);
            for (Records.StructureInfo info : verified) {
                class_2338 p = info.pos();
                int x5 = p.method_10263();
                int z5 = p.method_10260();
                boolean inRect = x5 >= minBlockX && x5 <= maxBlockX && z5 >= minBlockZ && z5 <= maxBlockZ;
                if (!inRect || existing.contains(p) || !inPlannedCoverage.test(x5, z5) && !inAOI.test(x5, z5)) continue;
                structures.add(p);
                infos.add(info);
                existing.add(p);
            }
        }
        ArrayList<List<class_2338>> roads = new ArrayList<List<class_2338>>();
        int spanX = Math.abs(maxBlockX - minBlockX);
        int spanZ = Math.abs(maxBlockZ - minBlockZ);
        boolean bl = loadDetailedRoads = spanX <= 7680 && spanZ <= 7680;
        if (loadDetailedRoads) {
            List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            for (Records.RoadData rd : roadDataList) {
                List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
                if (segs == null || segs.isEmpty()) continue;
                ArrayList<class_2338> poly = new ArrayList<class_2338>(segs.size());
                for (Records.RoadSegmentPlacement sp : segs) {
                    class_2338 p = sp.middlePos();
                    int x6 = p.method_10263();
                    int z6 = p.method_10260();
                    if (x6 < minBlockX || x6 > maxBlockX || z6 < minBlockZ || z6 > maxBlockZ) continue;
                    poly.add(p);
                }
                if (poly.size() < 2) continue;
                roads.add(poly);
            }
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }
}

