/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.config.ModConfig;

public final class TreeRemovalUtil {
    private TreeRemovalUtil() {
    }

    public static boolean fellTreeAt(class_5281 world, class_2338 logStart, ModConfig cfg) {
        class_2338 down;
        class_2680 downSt;
        boolean startIsTreeCore;
        if (cfg == null) {
            return false;
        }
        int radius = Math.max(2, Math.min(12, cfg.treeRemovalMaxRadius()));
        int maxH = Math.max(8, Math.min(64, cfg.treeRemovalMaxHeight()));
        int maxBlocks = Math.max(64, Math.min(8192, cfg.treeRemovalMaxBlocks()));
        int leavesConfirm = Math.max(0, Math.min(128, cfg.treeLeavesConfirm()));
        class_2680 startState = world.method_8320(logStart);
        boolean bl = startIsTreeCore = startState.method_26164(class_3481.field_15475) || startState.method_27852(class_2246.field_10211) || TreeRemovalUtil.isVineLike(startState) || startState.method_27852(class_2246.field_10302) || startState.method_27852(class_2246.field_28686) || TreeRemovalUtil.isMushroomLike(startState);
        if (!startIsTreeCore) {
            return false;
        }
        class_2338 base = logStart;
        for (int steps = 0; steps < maxH && ((downSt = world.method_8320(down = base.method_10074())).method_26164(class_3481.field_15475) || downSt.method_27852(class_2246.field_10211) || TreeRemovalUtil.isMushroomLike(downSt)); ++steps) {
            base = down;
        }
        int minX = base.method_10263() - radius;
        int maxX = base.method_10263() + radius;
        int minZ = base.method_10260() - radius;
        int maxZ = base.method_10260() + radius;
        int minY = Math.max(world.method_31607(), base.method_10264() - 1);
        int maxY = Math.min(world.method_31600() - 1, base.method_10264() + maxH);
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        int leavesCount = 0;
        boolean hasBamboo = false;
        boolean hasVineLike = false;
        boolean hasCocoa = false;
        boolean hasMushroom = false;
        q.add(base);
        seen.add(base.method_10063());
        while (!q.isEmpty() && toRemove.size() < maxBlocks) {
            class_2338[] neigh;
            boolean coreTreeBlock;
            class_2338 p = (class_2338)q.pollFirst();
            if (p.method_10263() < minX || p.method_10263() > maxX || p.method_10260() < minZ || p.method_10260() > maxZ || p.method_10264() < minY || p.method_10264() > maxY) continue;
            class_2680 st = world.method_8320(p);
            boolean isLog = st.method_26164(class_3481.field_15475);
            boolean isLeaves = st.method_26164(class_3481.field_15503);
            boolean isBamboo = st.method_27852(class_2246.field_10211);
            boolean isVine = TreeRemovalUtil.isVineLike(st);
            boolean isCocoa = st.method_27852(class_2246.field_10302);
            boolean isHangingRoots = st.method_27852(class_2246.field_28686);
            boolean isSnowLayer = st.method_27852(class_2246.field_10477);
            boolean isMushroomStem = st.method_27852(class_2246.field_10556);
            boolean isMushroomCap = st.method_27852(class_2246.field_10240) || st.method_27852(class_2246.field_10580);
            boolean isMushroom = isMushroomStem || isMushroomCap;
            boolean bl2 = coreTreeBlock = isLog || isLeaves || isBamboo || isVine || isCocoa || isHangingRoots || isMushroom;
            if (!coreTreeBlock) {
                if (!isSnowLayer) continue;
                toRemove.add(p);
                continue;
            }
            toRemove.add(p);
            if (isLeaves) {
                ++leavesCount;
            }
            if (isBamboo) {
                hasBamboo = true;
            }
            if (isVine) {
                hasVineLike = true;
            }
            if (isCocoa) {
                hasCocoa = true;
            }
            if (isMushroom) {
                hasMushroom = true;
            }
            for (class_2338 n : neigh = new class_2338[]{p.method_10084(), p.method_10074(), p.method_10095(), p.method_10072(), p.method_10078(), p.method_10067()}) {
                long key = n.method_10063();
                if (!seen.add(key)) continue;
                q.addLast(n);
            }
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        if (!(hasBamboo || hasVineLike || hasCocoa || hasMushroom || leavesCount >= leavesConfirm)) {
            return false;
        }
        for (class_2338 p : toRemove) {
            world.method_8652(p, class_2246.field_10124.method_9564(), 3);
        }
        return true;
    }

    public static boolean isVineLike(class_2680 st) {
        return st.method_27852(class_2246.field_10597) || st.method_27852(class_2246.field_28675) || st.method_27852(class_2246.field_28676) || st.method_27852(class_2246.field_22123) || st.method_27852(class_2246.field_22124) || st.method_27852(class_2246.field_23078) || st.method_27852(class_2246.field_23079);
    }

    public static boolean isMushroomLike(class_2680 st) {
        return st.method_27852(class_2246.field_10556) || st.method_27852(class_2246.field_10240) || st.method_27852(class_2246.field_10580);
    }
}

