/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.surface;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.config.ModConfig;

public final class HeightProfileService {
    private HeightProfileService() {
    }

    public static HeightProfile build(class_5281 world, List<class_2338> middlePositions, class_1923 currentChunk, int averagingRadius, ModConfig cfg, List<Integer> targetY) {
        int lo;
        int hi;
        int y;
        int ii;
        boolean usePersisted;
        int n = middlePositions.size();
        boolean bl = usePersisted = targetY != null && targetY.size() == n;
        if (usePersisted) {
            return new HeightProfile(true, null);
        }
        int[] baseYArr = new int[n];
        for (int ii2 = 0; ii2 < n; ++ii2) {
            ArrayList<Integer> hs = new ArrayList<Integer>();
            for (int jj = ii2 - averagingRadius; jj <= ii2 + averagingRadius; ++jj) {
                class_2338 sp;
                if (jj < 0 || jj >= n || !new class_1923(sp = middlePositions.get(jj)).equals((Object)currentChunk)) continue;
                int yTop = world.method_8624(class_2902.class_2903.field_13203, sp.method_10263(), sp.method_10260());
                hs.add(yTop);
            }
            if (hs.isEmpty()) {
                class_2338 mid = middlePositions.get(ii2);
                if (new class_1923(mid).equals((Object)currentChunk)) {
                    baseYArr[ii2] = world.method_8624(class_2902.class_2903.field_13203, mid.method_10263(), mid.method_10260());
                    continue;
                }
                baseYArr[ii2] = middlePositions.get(ii2).method_10264();
                continue;
            }
            baseYArr[ii2] = (int)Math.round(hs.stream().mapToInt(Integer::intValue).average().orElse(middlePositions.get(ii2).method_10264()));
        }
        if (!cfg.slopeLimitEnabled()) {
            int[] noSmoothed = new int[n];
            for (int ii3 = 0; ii3 < n; ++ii3) {
                noSmoothed[ii3] = baseYArr[ii3];
            }
            return new HeightProfile(false, noSmoothed);
        }
        int[] smoothed = new int[n];
        for (int ii4 = 0; ii4 < n; ++ii4) {
            smoothed[ii4] = baseYArr[ii4];
        }
        int step2 = Math.max(0, Math.min(8, cfg.maxSlopeStepPerTwoSegments()));
        int halfLow = Math.max(0, step2 / 2);
        int halfHigh = Math.max(0, (step2 + 1) / 2);
        for (ii = 1; ii < n; ++ii) {
            y = smoothed[ii];
            if (ii == 1) {
                py = smoothed[ii - 1];
                if (y > py + halfLow) {
                    y = py + halfLow;
                }
                if (y < py - halfLow) {
                    y = py - halfLow;
                }
            } else {
                py = smoothed[ii - 1];
                if (y > py + halfHigh) {
                    y = py + halfHigh;
                }
                if (y < py - halfHigh) {
                    y = py - halfHigh;
                }
                int p2 = smoothed[ii - 2];
                hi = p2 + step2;
                lo = p2 - step2;
                if (y > hi) {
                    y = hi;
                }
                if (y < lo) {
                    y = lo;
                }
            }
            smoothed[ii] = y;
        }
        for (ii = n - 2; ii >= 0; --ii) {
            y = smoothed[ii];
            if (ii == n - 2) {
                ny = smoothed[ii + 1];
                if (y > ny + halfLow) {
                    y = ny + halfLow;
                }
                if (y < ny - halfLow) {
                    y = ny - halfLow;
                }
            } else {
                ny = smoothed[ii + 1];
                if (y > ny + halfHigh) {
                    y = ny + halfHigh;
                }
                if (y < ny - halfHigh) {
                    y = ny - halfHigh;
                }
                int n2 = smoothed[ii + 2];
                hi = n2 + step2;
                lo = n2 - step2;
                if (y > hi) {
                    y = hi;
                }
                if (y < lo) {
                    y = lo;
                }
            }
            smoothed[ii] = y;
        }
        return new HeightProfile(false, smoothed);
    }

    public record HeightProfile(boolean usePersisted, int[] smoothedY) {
    }
}

