/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.planning.DelaunayPlanner;
import net.shiroha233.roadweaver.planning.KNNPlanner;
import net.shiroha233.roadweaver.planning.PlanningUtils;
import net.shiroha233.roadweaver.planning.RNGPlanner;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;
import net.shiroha233.roadweaver.util.ComputeService;

public final class RoadPlanningService {
    private static final ConcurrentHashMap<class_1937, Set<Long>> PLANNED_TILES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_1937, ConcurrentHashMap<Long, Long>> PLANNED_TILE_CENTERS = new ConcurrentHashMap();
    private static final int MAX_PLANNED_KEYS = 200000;

    private RoadPlanningService() {
    }

    private static void prunePlannedIfTooLarge(class_1937 level) {
        HashMap<Long, Long> centers;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        HashSet<Long> keys = new HashSet<Long>(provider.getPlannedTileKeys((class_3218)level));
        if (keys.size() > 200000) {
            Iterator it = keys.iterator();
            for (int remove = keys.size() - 200000; remove > 0 && it.hasNext(); --remove) {
                it.next();
                it.remove();
            }
            provider.setPlannedTileKeys((class_3218)level, keys);
        }
        if ((centers = new HashMap<Long, Long>(provider.getPlannedTileCenters((class_3218)level))).size() > 200000) {
            Iterator it2 = centers.keySet().iterator();
            for (int remove2 = centers.size() - 200000; remove2 > 0 && it2.hasNext(); --remove2) {
                it2.next();
                it2.remove();
            }
            provider.setPlannedTileCenters((class_3218)level, centers);
        }
    }

    public static void initialPlan(class_3218 level) {
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        ModConfig cfg = ConfigService.get();
        int radiusChunks = Math.max(1, cfg.initialPlanRadiusChunks());
        class_2338 spawn = level.method_43126();
        int cx = spawn.method_10263() >> 4;
        int cz = spawn.method_10260() >> 4;
        int minX = (cx - radiusChunks) * 16;
        int maxX = (cx + radiusChunks) * 16;
        int minZ = (cz - radiusChunks) * 16;
        int maxZ = (cz + radiusChunks) * 16;
        RoadPlanningService.planRect(level, minX, minZ, maxX, maxZ);
    }

    public static void planAroundPlayer(class_3222 player) {
        if (player == null) {
            return;
        }
        class_3218 level = player.method_51469();
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        ModConfig cfg = ConfigService.get();
        if (!cfg.dynamicPlanEnabled()) {
            return;
        }
        int radiusChunks = Math.max(1, cfg.dynamicPlanRadiusChunks());
        int stride = Math.max(1, cfg.dynamicPlanStrideChunks());
        int tile = Math.max(8, Math.min(256, stride));
        int pcx = player.method_31476().field_9181;
        int pcz = player.method_31476().field_9180;
        int kx = RoadPlanningService.floorDiv(pcx, tile);
        int kz = RoadPlanningService.floorDiv(pcz, tile);
        long key = (long)kx << 32 ^ (long)kz & 0xFFFFFFFFL;
        WorldDataProvider provider0 = WorldDataProvider.getInstance();
        HashSet<Long> set = new HashSet<Long>(provider0.getPlannedTileKeys(level));
        boolean isNewTile = set.add(key);
        HashMap<Long, Long> centers = new HashMap<Long, Long>(provider0.getPlannedTileCenters(level));
        centers.putIfAbsent(key, (long)pcx << 32 ^ (long)pcz & 0xFFFFFFFFL);
        provider0.setPlannedTileKeys(level, set);
        provider0.setPlannedTileCenters(level, centers);
        if (!isNewTile) {
            return;
        }
        int minX = (pcx - radiusChunks) * 16;
        int maxX = (pcx + radiusChunks) * 16;
        int minZ = (pcz - radiusChunks) * 16;
        int maxZ = (pcz + radiusChunks) * 16;
        RoadPlanningService.prunePlannedIfTooLarge((class_1937)level);
        RoadPlanningService.planRectAsync(level, minX, minZ, maxX, maxZ);
    }

    private static void planRect(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        MapSnapshot snap = MapDataCollector.build(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        ArrayList<class_2338> points = new ArrayList<class_2338>();
        HashSet<Long> seenPos = new HashSet<Long>();
        for (class_2338 p : snap.structures()) {
            class_2338 q = new class_2338(p.method_10263(), 0, p.method_10260());
            long key = PlanningUtils.pos2dKey(q);
            if (!seenPos.add(key)) continue;
            points.add(q);
        }
        if (points.size() < 2) {
            return;
        }
        ModConfig cfg0 = ConfigService.get();
        List<Records.StructureConnection> primaryEdges = cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.DELAUNAY ? DelaunayPlanner.planDelaunay(points, 2048) : (cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.RNG ? RNGPlanner.planRNG(points, 2048) : KNNPlanner.planKNN(points, 2, 2048, 1.8, 40.0, 2));
        if (primaryEdges.isEmpty()) {
            return;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> existing = provider.getStructureConnections(level);
        HashSet<class_2338> inRect = new HashSet<class_2338>(points);
        ArrayList<Records.StructureConnection> existingInRect = new ArrayList<Records.StructureConnection>();
        if (existing != null) {
            for (Records.StructureConnection c : existing) {
                if (!inRect.contains(c.from()) || !inRect.contains(c.to())) continue;
                existingInRect.add(c);
            }
        }
        ArrayList<Records.StructureConnection> base = new ArrayList<Records.StructureConnection>(existingInRect);
        base.addAll(primaryEdges);
        List<Records.StructureConnection> bridges = KNNPlanner.connectComponents(points, base, 1536, 35.0, 3);
        ArrayList<Records.StructureConnection> incoming = new ArrayList<Records.StructureConnection>(primaryEdges);
        incoming.addAll(bridges);
        List<Records.StructureConnection> merged = RoadPlanningService.mergeConnections(existing, incoming);
        if (merged.size() != existing.size()) {
            provider.setStructureConnections(level, merged);
        }
    }

    public static CompletableFuture<Void> initialPlanAsync(class_3218 level) {
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return CompletableFuture.completedFuture(null);
        }
        ModConfig cfg = ConfigService.get();
        int radiusChunks = Math.max(1, cfg.initialPlanRadiusChunks());
        class_2338 spawn = level.method_43126();
        int cx = spawn.method_10263() >> 4;
        int cz = spawn.method_10260() >> 4;
        int minX = (cx - radiusChunks) * 16;
        int maxX = (cx + radiusChunks) * 16;
        int minZ = (cz - radiusChunks) * 16;
        int maxZ = (cz + radiusChunks) * 16;
        return RoadPlanningService.planRectAsync(level, minX, minZ, maxX, maxZ);
    }

    public static CompletableFuture<Void> planRectAsync(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        long epoch = ThreadPoolManager.currentEpoch();
        return ComputeService.supplyAsync(() -> {
            if (Thread.currentThread().isInterrupted()) {
                return new ArrayList();
            }
            if (!ThreadPoolManager.isEpoch(epoch)) {
                return new ArrayList();
            }
            MapSnapshot snap = MapDataCollector.build(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            ArrayList<class_2338> points = new ArrayList<class_2338>();
            HashSet<Long> seenPos = new HashSet<Long>();
            for (class_2338 p : snap.structures()) {
                class_2338 q = new class_2338(p.method_10263(), 0, p.method_10260());
                long key = PlanningUtils.pos2dKey(q);
                if (!seenPos.add(key)) continue;
                points.add(q);
            }
            if (points.size() < 2) {
                return new ArrayList();
            }
            ModConfig cfg0 = ConfigService.get();
            List<Records.StructureConnection> primaryEdges = cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.DELAUNAY ? DelaunayPlanner.planDelaunay(points, 2048) : (cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.RNG ? RNGPlanner.planRNG(points, 2048) : KNNPlanner.planKNN(points, 2, 2048, 1.8, 40.0, 2));
            if (primaryEdges.isEmpty()) {
                return new ArrayList();
            }
            ArrayList<Records.StructureConnection> base = new ArrayList<Records.StructureConnection>(primaryEdges);
            List<Records.StructureConnection> bridges = KNNPlanner.connectComponents(points, base, 1536, 35.0, 3);
            ArrayList<Records.StructureConnection> incoming = new ArrayList<Records.StructureConnection>(primaryEdges);
            incoming.addAll(bridges);
            return incoming;
        }).thenAccept(incoming -> {
            if (incoming == null || incoming.isEmpty()) {
                return;
            }
            if (!ThreadPoolManager.isEpoch(epoch)) {
                return;
            }
            MinecraftServer server = level.method_8503();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                if (!ThreadPoolManager.isEpoch(epoch)) {
                    return;
                }
                WorldDataProvider provider = WorldDataProvider.getInstance();
                List<Records.StructureConnection> existing = provider.getStructureConnections(level);
                List<Records.StructureConnection> merged = RoadPlanningService.mergeConnections(existing, incoming);
                if (merged.size() != (existing == null ? 0 : existing.size())) {
                    provider.setStructureConnections(level, merged);
                }
            });
        });
    }

    private static List<Records.StructureConnection> mergeConnections(List<Records.StructureConnection> existing, List<Records.StructureConnection> incoming) {
        long k;
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<Records.StructureConnection> out = new ArrayList<Records.StructureConnection>();
        if (existing != null) {
            for (Records.StructureConnection c : existing) {
                k = PlanningUtils.edgeKey(c.from(), c.to());
                if (!seen.add(k)) continue;
                out.add(c);
            }
        }
        for (Records.StructureConnection c : incoming) {
            k = PlanningUtils.edgeKey(c.from(), c.to());
            if (!seen.add(k)) continue;
            out.add(new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.PLANNED));
        }
        return out;
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }

    public static Set<Long> getPlannedTiles(class_3218 level) {
        Set<Long> s = WorldDataProvider.getInstance().getPlannedTileKeys(level);
        return s == null ? Set.of() : Set.copyOf(s);
    }

    public static Map<Long, Long> getPlannedTileCenters(class_3218 level) {
        Map<Long, Long> m = WorldDataProvider.getInstance().getPlannedTileCenters(level);
        if (m == null || m.isEmpty()) {
            return Map.of();
        }
        return Map.copyOf(m);
    }

    public static int getStrideTileSizeChunks() {
        ModConfig cfg = ConfigService.get();
        int stride = Math.max(1, cfg.dynamicPlanStrideChunks());
        return Math.max(8, Math.min(256, stride));
    }

    public static int getDynamicPlanRadiusChunks() {
        ModConfig cfg = ConfigService.get();
        return Math.max(1, cfg.dynamicPlanRadiusChunks());
    }

    public static void resetAll() {
        PLANNED_TILES.clear();
        PLANNED_TILE_CENTERS.clear();
    }
}

