/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6830;
import net.minecraft.class_6832;
import net.minecraft.class_6833;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructureVerificationService {
    private StructureVerificationService() {
    }

    public static List<Records.StructureInfo> verifyPredictedStructures(class_3218 level, List<Records.StructureInfo> predicted) {
        class_6830 scanAccess;
        if (predicted == null || predicted.isEmpty()) {
            return List.of();
        }
        class_3215 source = level.method_14178();
        if (!(source instanceof class_3215)) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        class_3215 chunkCache = source;
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        try {
            scanAccess = chunkCache.method_39777();
        }
        catch (Throwable t) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        class_5455 registryAccess = level.method_30349();
        class_2794 generator = chunkCache.method_12129();
        class_7138 randomState = chunkCache.method_41248();
        class_1966 biomeSource = generator.method_12098();
        long seed = level.method_8412();
        class_6832 checker = new class_6832(scanAccess, registryAccess, server.method_27727(), level.method_27983(), generator, randomState, (class_5539)level, biomeSource, seed, server.method_3855());
        class_2378 structureRegistry = registryAccess.method_30530(class_7924.field_41246);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Records.StructureInfo info : predicted) {
            class_6833 checkResult;
            String idStr = info.structureId();
            if (idStr == null || idStr.isEmpty()) {
                result.add(info);
                continue;
            }
            class_2960 rl = class_2960.method_12829((String)idStr);
            if (rl == null) {
                result.add(info);
                continue;
            }
            class_3195 structure = (class_3195)structureRegistry.method_10223(rl);
            if (structure == null) {
                result.add(info);
                continue;
            }
            class_1923 chunkPos = new class_1923(info.pos().method_10263() >> 4, info.pos().method_10260() >> 4);
            try {
                checkResult = checker.method_39831(chunkPos, structure, false);
            }
            catch (Throwable t) {
                result.add(info);
                continue;
            }
            if (checkResult == class_6833.field_36239) {
                result.add(info);
                continue;
            }
            if (checkResult != class_6833.field_36241) continue;
            result.add(info);
        }
        return result;
    }
}

