/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.pipeline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.blend.BlendPlan;
import net.shiroha233.roadweaver.structures.blend.TerrainBlender;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public final class StructurePlacer {
    private StructurePlacer() {
    }

    public static StructureInstance place(class_3218 level, StructureBlueprint bp, class_2960 variantTemplateId, class_2338 anchor, class_2470 rotation, class_2415 mirror, class_238 preBounds, BlendProfile blend) {
        class_2960 id = StructurePlacer.normalizeTemplateId(variantTemplateId);
        class_3485 mgr = level.method_8503().method_27727();
        Optional opt = mgr.method_15094(id);
        if (opt.isEmpty()) {
            opt = mgr.method_15094(variantTemplateId);
        }
        if (opt.isEmpty()) {
            class_238 b = preBounds != null ? preBounds : new class_238(anchor).method_1009(8.0, 5.0, 8.0);
            return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.method_27983().method_29177(), anchor, b, level.method_8510());
        }
        class_3499 tpl = (class_3499)opt.get();
        class_2382 raw = tpl.method_15160();
        class_2382 size = StructurePlacer.rotatedSize(raw, rotation);
        class_2338 min = anchor;
        class_2338 max = anchor.method_10069(size.method_10263() - 1, size.method_10264() - 1, size.method_10260() - 1);
        class_238 bounds = new class_238(min, max);
        if (blend != null) {
            class_238 horiz = new class_238((double)min.method_10263(), (double)level.method_31607(), (double)min.method_10260(), (double)max.method_10263(), (double)level.method_31600(), (double)max.method_10260());
            BlendPlan plan = TerrainBlender.plan((class_5281)level, horiz, blend);
            TerrainBlender.apply((class_5281)level, plan);
        }
        StructurePlacer.buildTrayFoundation(level, min, max);
        class_3492 settings = new class_3492().method_15123(rotation).method_15125(mirror);
        tpl.method_15172((class_5425)level, anchor, anchor, settings, level.method_8409(), 2);
        return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.method_27983().method_29177(), anchor, bounds, level.method_8510());
    }

    private static class_2960 normalizeTemplateId(class_2960 in) {
        String path = in.method_12832();
        if (path.startsWith("structures/")) {
            return new class_2960(in.method_12836(), path.substring("structures/".length()));
        }
        return in;
    }

    private static class_2382 rotatedSize(class_2382 s, class_2470 r) {
        return switch (r) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467, class_2470.field_11464 -> s;
            case class_2470.field_11463, class_2470.field_11465 -> new class_2382(s.method_10260(), s.method_10264(), s.method_10263());
        };
    }

    private static void buildTrayFoundation(class_3218 level, class_2338 min, class_2338 max) {
        boolean insideFootprint;
        int z;
        int x;
        int yTop = min.method_10264();
        int yMid = yTop - 1;
        int yBot = yTop - 2;
        int expand = 3;
        int cx0 = min.method_10263() - expand;
        int cz0 = min.method_10260() - expand;
        int cx1 = max.method_10263() + expand;
        int cz1 = max.method_10260() + expand;
        int chamfer = 3;
        int fx0 = min.method_10263();
        int fz0 = min.method_10260();
        int fx1 = max.method_10263();
        int fz1 = max.method_10260();
        for (x = cx0; x <= cx1; ++x) {
            for (z = cz0; z <= cz1; ++z) {
                if (!StructurePlacer.insideChamfered(x, z, cx0, cz0, cx1, cz1, chamfer)) continue;
                boolean bl = insideFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                if (insideFootprint) continue;
                level.method_8652(new class_2338(x, yTop, z), class_2246.field_10219.method_9564(), 3);
                level.method_8652(new class_2338(x, yMid, z), class_2246.field_10566.method_9564(), 3);
                level.method_8652(new class_2338(x, yBot, z), class_2246.field_10566.method_9564(), 3);
            }
        }
        for (x = cx0; x <= cx1; ++x) {
            for (z = cz0; z <= cz1; ++z) {
                if (!StructurePlacer.insideChamfered(x, z, cx0, cz0, cx1, cz1, chamfer)) continue;
                boolean bl = insideFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                if (insideFootprint) continue;
                boolean edge = false;
                if (!StructurePlacer.insideChamfered(x - 1, z, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x + 1, z, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x, z - 1, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x, z + 1, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                }
                if (!edge) continue;
                StructurePlacer.fillDownToSurface(level, new class_2338(x, yBot - 1, z));
            }
        }
    }

    private static boolean insideChamfered(int x, int z, int minX, int minZ, int maxX, int maxZ, int c) {
        if (x < minX || x > maxX || z < minZ || z > maxZ) {
            return false;
        }
        if (x - minX + (z - minZ) < c) {
            return false;
        }
        if (maxX - x + (z - minZ) < c) {
            return false;
        }
        if (x - minX + (maxZ - z) < c) {
            return false;
        }
        return maxX - x + (maxZ - z) >= c;
    }

    private static void fillDownToSurface(class_3218 level, class_2338 start) {
        int top = level.method_8624(class_2902.class_2903.field_13203, start.method_10263(), start.method_10260());
        for (int y = start.method_10264(); y >= Math.max(level.method_31607(), top); --y) {
            level.method_8652(new class_2338(start.method_10263(), y, start.method_10260()), class_2246.field_10566.method_9564(), 3);
        }
    }
}

