/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads;

import net.countered.settlementroads.client.gui.ClothConfigScreen;
import net.countered.settlementroads.config.neoforge.NeoForgeJsonConfig;
import net.countered.settlementroads.datagen.SettlementRoadsDataGenerator;
import net.countered.settlementroads.events.ModEventHandler;
import net.countered.settlementroads.features.config.RoadFeatureRegistry;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="roadweaver")
public class SettlementRoads {
    public static final String MOD_ID = "roadweaver";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public SettlementRoads(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Initializing roadWeaver (NeoForge)...");
        NeoForgeJsonConfig.load();
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(client, parent) -> ClothConfigScreen.createConfigScreen(parent)));
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(SettlementRoadsDataGenerator::gatherData);
        RoadFeatureRegistry.registerFeatures();
        ModEventHandler.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("RoadWeaver common setup completed");
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

