/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.neoforge.WorldDataHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="roadweaver", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SettlementRoadsClient {
    private static KeyMapping debugMapKey;

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        debugMapKey = new KeyMapping("key.roadweaver.debug_map", 72, "category.roadweaver");
        event.register(debugMapKey);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    private static void handleDebugMapKey(Minecraft client) {
        if (client.screen instanceof RoadDebugScreen) {
            client.execute(() -> client.setScreen(null));
            return;
        }
        if (client.getSingleplayerServer() == null) {
            return;
        }
        ServerLevel world = client.getSingleplayerServer().overworld();
        if (world == null) {
            return;
        }
        try {
            Records.StructureLocationData structureData = WorldDataHelper.getStructureLocations(world);
            List<Records.StructureConnection> connections = WorldDataHelper.getConnectedStructures(world);
            List<Records.RoadData> roads = WorldDataHelper.getRoadDataList(world);
            ArrayList<Records.StructureInfo> structureInfos = structureData != null ? new ArrayList<Records.StructureInfo>(structureData.structureInfos()) : new ArrayList();
            client.execute(() -> client.setScreen((Screen)new RoadDebugScreen(structureInfos, connections, roads)));
        }
        catch (Exception e) {
            client.execute(() -> client.setScreen((Screen)new RoadDebugScreen(new ArrayList<Records.StructureInfo>(), new ArrayList<Records.StructureConnection>(), new ArrayList<Records.RoadData>())));
        }
    }

    @EventBusSubscriber(modid="roadweaver", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            Minecraft client = Minecraft.getInstance();
            while (debugMapKey.consumeClick()) {
                SettlementRoadsClient.handleDebugMapKey(client);
            }
        }
    }
}

