/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.client.gui.StructureColorManager;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;

public class MapRenderer {
    private static final int RADIUS = 5;
    private static final int TARGET_GRID_PX = 80;
    private final Map<String, Integer> statusColors;
    private final RoadDebugScreen.ScreenBounds bounds;
    private final StructureColorManager colorManager;

    public MapRenderer(Map<String, Integer> statusColors, RoadDebugScreen.ScreenBounds bounds, StructureColorManager colorManager) {
        this.statusColors = statusColors;
        this.bounds = bounds;
        this.colorManager = colorManager;
    }

    public LODLevel getLODLevel(double zoom) {
        if (zoom > 3.0) {
            return LODLevel.HIGH;
        }
        if (zoom > 1.0) {
            return LODLevel.MEDIUM;
        }
        if (zoom > 0.3) {
            return LODLevel.LOW;
        }
        return LODLevel.MINIMAL;
    }

    public RoadLODLevel getRoadLODLevel(double baseScale, double zoom) {
        double blocksPerPixel = 1.0 / (baseScale * zoom);
        double blocksPerGrid = blocksPerPixel * 80.0;
        if (blocksPerGrid < 300.0) {
            return RoadLODLevel.FINEST;
        }
        if (blocksPerGrid < 800.0) {
            return RoadLODLevel.EIGHTH;
        }
        if (blocksPerGrid < 1600.0) {
            return RoadLODLevel.SIXTEENTH;
        }
        if (blocksPerGrid < 3200.0) {
            return RoadLODLevel.THIRTY_SECOND;
        }
        if (blocksPerGrid < 6400.0) {
            return RoadLODLevel.SIXTY_FOURTH;
        }
        if (blocksPerGrid < 12800.0) {
            return RoadLODLevel.ONE_TWENTY_EIGHTH;
        }
        if (blocksPerGrid < 25600.0) {
            return RoadLODLevel.TWO_FIFTY_SIXTH;
        }
        if (blocksPerGrid < 50000.0) {
            return RoadLODLevel.FIVE_TWELVE;
        }
        return RoadLODLevel.NONE;
    }

    public void drawRoadPaths(GuiGraphics ctx, List<Records.RoadData> roads, LODLevel lod, double baseScale, double zoom, WorldToScreenConverter converter) {
        if (roads == null || roads.isEmpty() || lod == LODLevel.MINIMAL) {
            return;
        }
        RoadLODLevel roadLOD = this.getRoadLODLevel(baseScale, zoom);
        if (roadLOD == RoadLODLevel.NONE) {
            return;
        }
        int roadColor = this.statusColors.get("road") & 0xFFFFFF | Integer.MIN_VALUE;
        for (Records.RoadData roadData : roads) {
            List<Records.RoadSegmentPlacement> segments = roadData.roadSegmentList();
            if (segments == null || segments.size() < 2) continue;
            this.drawRoadPathWithLOD(ctx, segments, roadColor, roadLOD, converter);
        }
    }

    private void drawRoadPathWithLOD(GuiGraphics ctx, List<Records.RoadSegmentPlacement> segments, int color, RoadLODLevel roadLOD, WorldToScreenConverter converter) {
        int step;
        switch (roadLOD.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 8;
                break;
            }
            case 2: {
                int n = 16;
                break;
            }
            case 3: {
                int n = 32;
                break;
            }
            case 4: {
                int n = 64;
                break;
            }
            case 5: {
                int n = 128;
                break;
            }
            case 6: {
                int n = 256;
                break;
            }
            case 7: {
                int n = 512;
                break;
            }
            case 8: {
                int n = step = Integer.MAX_VALUE;
            }
        }
        if (step >= segments.size()) {
            return;
        }
        RoadDebugScreen.ScreenPos prevPos = null;
        for (int i = 0; i < segments.size(); i += step) {
            BlockPos pos = segments.get(i).middlePos();
            RoadDebugScreen.ScreenPos currentPos = converter.worldToScreen(pos.getX(), pos.getZ());
            if (prevPos != null && i > 0 && this.bounds.isLineInBounds(prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y())) {
                RenderUtils.drawLine(ctx, prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y(), color);
            }
            prevPos = currentPos;
        }
    }

    public void drawConnections(GuiGraphics ctx, List<Records.StructureConnection> connections, List<Records.RoadData> roads, LODLevel lod, WorldToScreenConverter converter) {
        if (connections == null || connections.isEmpty() || lod == LODLevel.MINIMAL) {
            return;
        }
        for (Records.StructureConnection connection : connections) {
            if (connection.status() == Records.ConnectionStatus.COMPLETED) continue;
            RoadDebugScreen.ScreenPos fromPos = converter.worldToScreen(connection.from().getX(), connection.from().getZ());
            RoadDebugScreen.ScreenPos toPos = converter.worldToScreen(connection.to().getX(), connection.to().getZ());
            if (!this.bounds.isLineInBounds(fromPos.x(), fromPos.y(), toPos.x(), toPos.y())) continue;
            int color = this.getConnectionColor(connection);
            RenderUtils.drawDashedLine(ctx, fromPos.x(), fromPos.y(), toPos.x(), toPos.y(), color);
        }
    }

    private int getConnectionColor(Records.StructureConnection connection) {
        return switch (connection.status()) {
            case Records.ConnectionStatus.PLANNED -> this.statusColors.get("planned");
            case Records.ConnectionStatus.GENERATING -> this.statusColors.get("generating");
            case Records.ConnectionStatus.FAILED -> this.statusColors.get("failed");
            default -> this.statusColors.get("completed");
        };
    }

    public void drawStructures(GuiGraphics ctx, List<Records.StructureInfo> structureInfos, BlockPos hoveredStructure, BlockPos manualFirst, LODLevel lod, WorldToScreenConverter converter) {
        if (structureInfos == null || structureInfos.isEmpty()) {
            return;
        }
        int adaptiveRadius = this.getAdaptiveNodeRadius(lod, 3.0);
        for (Records.StructureInfo info : structureInfos) {
            BlockPos structure = info.pos();
            String structureId = info.structureId();
            int structureColor = this.colorManager.getColorForStructure(structureId);
            RoadDebugScreen.ScreenPos pos = converter.worldToScreen(structure.getX(), structure.getZ());
            if (!this.bounds.isInBounds(pos.x(), pos.y(), adaptiveRadius + 6)) continue;
            boolean isHovered = structure.equals((Object)hoveredStructure);
            boolean isManualSelected = structure.equals((Object)manualFirst);
            int radius = isHovered ? adaptiveRadius + 2 : adaptiveRadius;
            switch (lod.ordinal()) {
                case 0: {
                    if (isManualSelected) {
                        long time = System.currentTimeMillis();
                        float pulse = (float)(Math.sin((double)time / 200.0) * 0.5 + 0.5);
                        int pulseAlpha = (int)(96.0f + pulse * 64.0f);
                        int glowColor = pulseAlpha << 24 | 0xFFD700;
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 4, glowColor);
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 2, -2130716928);
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -10496);
                        RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -22016);
                        int crossSize = radius + 3;
                        ctx.fill(pos.x() - crossSize, pos.y() - 1, pos.x() + crossSize, pos.y() + 1, -10496);
                        ctx.fill(pos.x() - 1, pos.y() - crossSize, pos.x() + 1, pos.y() + crossSize, -10496);
                        break;
                    }
                    int glowColor = structureColor & 0xFFFFFF | 0x40000000;
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 1, glowColor);
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, structureColor);
                    int outlineColor = this.darkenColor(structureColor);
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, outlineColor);
                    int highlightSize = Math.max(1, radius / 3);
                    ctx.fill(pos.x() - highlightSize, pos.y() - highlightSize, pos.x() + highlightSize + 1, pos.y() + highlightSize + 1, -2130706433);
                    break;
                }
                case 1: {
                    if (isManualSelected) {
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 1, -2130716928);
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, -10496);
                        RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -22016);
                    } else {
                        RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, structureColor);
                        RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, this.darkenColor(structureColor));
                    }
                    if (radius < 3) break;
                    ctx.fill(pos.x() - 1, pos.y() - 1, pos.x() + 1, pos.y() + 1, 0x60FFFFFF);
                    break;
                }
                case 2: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, structureColor);
                    if (radius < 4) break;
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, this.darkenColor(structureColor));
                    break;
                }
                case 3: {
                    if (adaptiveRadius >= 2) {
                        ctx.fill(pos.x() - 1, pos.y() - 1, pos.x() + 2, pos.y() + 2, structureColor);
                        break;
                    }
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), adaptiveRadius, structureColor);
                }
            }
        }
    }

    private int darkenColor(int color) {
        int r = (color >> 16 & 0xFF) * 2 / 3;
        int g = (color >> 8 & 0xFF) * 2 / 3;
        int b = (color & 0xFF) * 2 / 3;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public void drawPlayerMarker(GuiGraphics ctx, LODLevel lod, double zoom, WorldToScreenConverter converter) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return;
        }
        double px = mc.player.getX();
        double pz = mc.player.getZ();
        RoadDebugScreen.ScreenPos p = converter.worldToScreen(px, pz);
        int playerRadius = Math.max(3, this.getAdaptiveNodeRadius(lod, zoom) + 1);
        if (!this.bounds.isInBounds(p.x(), p.y(), playerRadius + 10)) {
            return;
        }
        int fill = -1618884;
        int glow = 1088900156;
        int outline = -7131873;
        float yaw = mc.player.getYRot();
        double angle = Math.toRadians(yaw + 90.0f);
        int arrowLength = playerRadius + Math.max(3, (int)(4.0 * Math.min(zoom / 3.0, 1.5)));
        double tx = (double)p.x() + Math.cos(angle) * (double)arrowLength;
        double ty = (double)p.y() + Math.sin(angle) * (double)arrowLength;
        switch (lod.ordinal()) {
            case 0: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius + 1, 1088900156);
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                int highlightSize = Math.max(1, playerRadius / 4);
                ctx.fill(p.x() - highlightSize, p.y() - highlightSize, p.x() + highlightSize + 1, p.y() + highlightSize + 1, -1426063361);
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), tx, ty, -1);
                break;
            }
            case 1: 
            case 2: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), tx, ty, -1);
                break;
            }
            case 3: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), Math.max(2, playerRadius), -1618884);
                int shortArrow = playerRadius + 2;
                double stx = (double)p.x() + Math.cos(angle) * (double)shortArrow;
                double sty = (double)p.y() + Math.sin(angle) * (double)shortArrow;
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), stx, sty, -1);
            }
        }
    }

    private int getAdaptiveNodeRadius(LODLevel lod, double zoom) {
        double baseRadius = 5.0;
        double zoomFactor = Math.max(0.3, Math.min(1.2, 1.0 + Math.log10(zoom) * 0.15));
        double scaledRadius = baseRadius * zoomFactor;
        double lodMultiplier = switch (lod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.9;
            case 1 -> 1.0;
            case 2 -> 0.8;
            case 3 -> 0.6;
        };
        return Math.max(2, (int)Math.round(scaledRadius * lodMultiplier));
    }

    public static enum LODLevel {
        HIGH,
        MEDIUM,
        LOW,
        MINIMAL;

    }

    public static enum RoadLODLevel {
        FINEST,
        EIGHTH,
        SIXTEENTH,
        THIRTY_SECOND,
        SIXTY_FOURTH,
        ONE_TWENTY_EIGHTH,
        TWO_FIFTY_SIXTH,
        FIVE_TWELVE,
        NONE;

    }

    public static interface WorldToScreenConverter {
        public RoadDebugScreen.ScreenPos worldToScreen(double var1, double var3);
    }
}

