/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.countered.settlementroads.client.gui.ClothConfigScreen;
import net.countered.settlementroads.client.gui.GridRenderer;
import net.countered.settlementroads.client.gui.MapRenderer;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.StructureColorManager;
import net.countered.settlementroads.client.gui.UIRenderer;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class RoadDebugScreen
extends Screen {
    private static final int PADDING = 20;
    private final List<Records.StructureInfo> structureInfos;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;
    private final StructureColorManager colorManager;
    private final Map<String, Integer> statusColors = Map.of("structure", -14176672, "planned", -865972, "generating", -1671646, "completed", -14176672, "failed", -1618884, "road", -13330213);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 3.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private double lastZoom = 1.0;
    private double lastOffsetX = 0.0;
    private double lastOffsetY = 0.0;
    private BlockPos hoveredStructure = null;
    private String hoveredStructureId = null;
    private boolean manualMode = false;
    private BlockPos manualFirst = null;
    private String toastMessage = null;
    private long toastExpireMs = 0L;
    private double mouseDownX = 0.0;
    private double mouseDownY = 0.0;
    private boolean hasDragged = false;
    private BlockPos pendingTeleport = null;
    private long teleportConfirmExpireMs = 0L;
    private final MapRenderer mapRenderer;
    private final GridRenderer gridRenderer;
    private final UIRenderer uiRenderer;
    private final ScreenBounds bounds;
    private Button manualButton;
    private Button configButton;
    private Button refreshButton;

    public RoadDebugScreen(List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        super((Component)Component.translatable((String)"gui.roadweaver.debug_map.title"));
        this.structureInfos = structureInfos != null ? new ArrayList<Records.StructureInfo>(structureInfos) : new ArrayList();
        this.connections = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        this.roads = roads != null ? new ArrayList<Records.RoadData>(roads) : new ArrayList();
        this.colorManager = new StructureColorManager();
        if (!this.structureInfos.isEmpty()) {
            this.minX = this.structureInfos.stream().mapToInt(info -> info.pos().getX()).min().orElse(0);
            this.maxX = this.structureInfos.stream().mapToInt(info -> info.pos().getX()).max().orElse(0);
            this.minZ = this.structureInfos.stream().mapToInt(info -> info.pos().getZ()).min().orElse(0);
            this.maxZ = this.structureInfos.stream().mapToInt(info -> info.pos().getZ()).max().orElse(0);
        }
        this.bounds = new ScreenBounds();
        this.mapRenderer = new MapRenderer(this.statusColors, this.bounds, this.colorManager);
        this.gridRenderer = new GridRenderer();
        this.uiRenderer = new UIRenderer(this.statusColors, this.colorManager);
    }

    protected void init() {
        super.init();
        int configButtonW = 50;
        int configButtonH = 16;
        int configButtonX = this.width - configButtonW - 8;
        int configButtonY = 8;
        this.configButton = Button.builder((Component)Component.translatable((String)"gui.roadweaver.config"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(ClothConfigScreen.createConfigScreen(this));
            }
        }).bounds(configButtonX, configButtonY, configButtonW, configButtonH).build();
        this.addRenderableWidget((GuiEventListener)this.configButton);
        int refreshButtonW = 50;
        int refreshButtonH = 16;
        int refreshButtonX = configButtonX - refreshButtonW - 4;
        int refreshButtonY = 8;
        this.refreshButton = Button.builder((Component)Component.translatable((String)"gui.roadweaver.debug_map.refresh"), button -> this.refreshData()).bounds(refreshButtonX, refreshButtonY, refreshButtonW, refreshButtonH).build();
        this.addRenderableWidget((GuiEventListener)this.refreshButton);
        int buttonW = 110;
        int buttonH = 16;
        int buttonX = 8;
        int buttonY = this.height - buttonH - 8;
        this.manualButton = Button.builder((Component)this.getManualModeLabel(), b -> this.toggleManualMode()).bounds(buttonX, buttonY, buttonW, buttonH).build();
        this.addRenderableWidget((GuiEventListener)this.manualButton);
    }

    private Component getManualModeLabel() {
        MutableComponent state = Component.translatable((String)(this.manualMode ? "gui.roadweaver.common.on" : "gui.roadweaver.common.off"));
        return Component.translatable((String)"gui.roadweaver.debug_map.manual_mode", (Object[])new Object[]{state});
    }

    private void toggleManualMode() {
        this.manualMode = !this.manualMode;
        this.manualFirst = null;
        if (this.manualButton != null) {
            this.manualButton.setMessage(this.getManualModeLabel());
        }
        String msg = Component.translatable((String)(this.manualMode ? "toast.roadweaver.manual_mode_on" : "toast.roadweaver.manual_mode_off")).getString();
        this.toast(msg, 2000L);
    }

    private void refreshData() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getSingleplayerServer() == null) {
            return;
        }
        ServerLevel world = mc.getSingleplayerServer().overworld();
        if (world == null) {
            return;
        }
        try {
            Records.StructureLocationData data = WorldDataProvider.getInstance().getStructureLocations(world);
            List<Records.StructureConnection> newConnections = WorldDataProvider.getInstance().getStructureConnections(world);
            List<Records.RoadData> newRoads = WorldDataProvider.getInstance().getRoadDataList(world);
            int failedCount = 0;
            if (newConnections != null) {
                ArrayList<Records.StructureConnection> filteredConnections = new ArrayList<Records.StructureConnection>();
                for (Records.StructureConnection conn : newConnections) {
                    if (conn.status() == Records.ConnectionStatus.FAILED) {
                        ++failedCount;
                        continue;
                    }
                    filteredConnections.add(conn);
                }
                if (failedCount > 0) {
                    WorldDataProvider.getInstance().setStructureConnections(world, filteredConnections);
                    newConnections = filteredConnections;
                }
            }
            this.structureInfos.clear();
            if (data != null && data.structureInfos() != null) {
                this.structureInfos.addAll(data.structureInfos());
            }
            this.connections.clear();
            if (newConnections != null) {
                this.connections.addAll(newConnections);
            }
            this.roads.clear();
            if (newRoads != null) {
                this.roads.addAll(newRoads);
            }
            if (!this.structureInfos.isEmpty()) {
                this.minX = this.structureInfos.stream().mapToInt(info -> info.pos().getX()).min().orElse(0);
                this.maxX = this.structureInfos.stream().mapToInt(info -> info.pos().getX()).max().orElse(0);
                this.minZ = this.structureInfos.stream().mapToInt(info -> info.pos().getZ()).min().orElse(0);
                this.maxZ = this.structureInfos.stream().mapToInt(info -> info.pos().getZ()).max().orElse(0);
            }
            this.layoutDirty = true;
            Object message = Component.translatable((String)"gui.roadweaver.debug_map.refreshed").getString();
            if (failedCount > 0) {
                message = (String)message + " (" + Component.translatable((String)"gui.roadweaver.debug_map.removed_failed", (Object[])new Object[]{failedCount}).getString() + ")";
            }
            this.toast((String)message, 2000L);
        }
        catch (Exception e) {
            this.toast("Refresh failed: " + e.getMessage(), 2000L);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private void computeLayout() {
        if (this.structureInfos.isEmpty()) {
            this.baseScale = 1.0;
            return;
        }
        int w = this.width - 40;
        int h = this.height - 40;
        if (w <= 0 || h <= 0) {
            return;
        }
        int worldW = Math.max(1, this.maxX - this.minX);
        int worldH = Math.max(1, this.maxZ - this.minZ);
        double scaleX = (double)w / (double)worldW;
        double scaleY = (double)h / (double)worldH;
        this.baseScale = Math.min(scaleX, scaleY) * 0.8;
        if (this.firstLayout) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                double playerX = mc.player.getX();
                double playerZ = mc.player.getZ();
                double playerScreenX = (playerX - (double)this.minX) * this.baseScale * this.zoom;
                double playerScreenZ = (playerZ - (double)this.minZ) * this.baseScale * this.zoom;
                this.offsetX = (double)w / 2.0 - playerScreenX;
                this.offsetY = (double)h / 2.0 - playerScreenZ;
            } else {
                this.offsetX = ((double)w - (double)worldW * this.baseScale * this.zoom) / 2.0;
                this.offsetY = ((double)h - (double)worldH * this.baseScale * this.zoom) / 2.0;
            }
            this.firstLayout = false;
        }
        this.layoutDirty = false;
    }

    private void updateUIBounds() {
        this.bounds.update(20, this.width - 20, 20, this.height - 20);
    }

    private ScreenPos worldToScreen(double worldX, double worldZ) {
        int x = 20 + (int)((worldX - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int y = 20 + (int)((worldZ - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(x, y);
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        if (this.layoutDirty || this.lastWidth != this.width || this.lastHeight != this.height || this.lastZoom != this.zoom || this.lastOffsetX != this.offsetX || this.lastOffsetY != this.offsetY) {
            this.computeLayout();
            this.updateUIBounds();
            this.lastWidth = this.width;
            this.lastHeight = this.height;
            this.lastZoom = this.zoom;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.layoutDirty = false;
        }
        ctx.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        MapRenderer.LODLevel lod = this.mapRenderer.getLODLevel(this.zoom);
        MapRenderer.WorldToScreenConverter converter = this::worldToScreen;
        if (lod != MapRenderer.LODLevel.MINIMAL) {
            this.gridRenderer.drawGrid(ctx, lod, this.width, this.height, 20, this.baseScale, this.zoom, this.offsetX, this.offsetY, this.minX, this.minZ, this.bounds);
        }
        this.mapRenderer.drawRoadPaths(ctx, this.roads, lod, this.baseScale, this.zoom, converter);
        this.mapRenderer.drawConnections(ctx, this.connections, this.roads, lod, converter);
        this.mapRenderer.drawStructures(ctx, this.structureInfos, this.hoveredStructure, this.manualFirst, lod, converter);
        this.mapRenderer.drawPlayerMarker(ctx, lod, this.zoom, converter);
        List<Records.StructureInfo> visibleStructures = this.getVisibleStructures(converter);
        this.uiRenderer.drawTitle(ctx, this.width);
        this.uiRenderer.drawStatsPanel(ctx, this.width, this.structureInfos, this.connections, this.roads, this.zoom, this.baseScale);
        this.uiRenderer.drawLegendPanel(ctx, this.height, visibleStructures);
        ctx.pose().pushPose();
        ctx.pose().translate(0.0f, 0.0f, 100.0f);
        super.render(ctx, mouseX, mouseY, delta);
        ctx.pose().popPose();
        if (this.hoveredStructure != null && this.hoveredStructureId != null) {
            this.uiRenderer.drawTooltip(ctx, this.hoveredStructure, this.hoveredStructureId, mouseX, mouseY, this.width);
        }
        this.updateHoveredStructure(mouseX, mouseY);
        if (this.toastMessage != null && System.currentTimeMillis() < this.toastExpireMs) {
            this.drawToast(ctx, this.toastMessage);
        }
    }

    private void drawToast(GuiGraphics ctx, String message) {
        Font font = Minecraft.getInstance().font;
        int tw = font.width(message);
        int x = 10;
        int y = 10;
        RenderUtils.drawPanel(ctx, x - 4, y - 4, x + tw + 6, y + 12, -1073741824, -10066330);
        ctx.drawString(font, message, x, y, -1, false);
    }

    private void toast(String msg, long durationMs) {
        this.toastMessage = msg;
        this.toastExpireMs = System.currentTimeMillis() + durationMs;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft != null && this.minecraft.options.keyMappings != null) {
            for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
                if (!keyMapping.getName().equals("key.roadweaver.debug_map") || !keyMapping.matches(keyCode, scanCode)) continue;
                this.onClose();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.dragging && button == 0) {
            double totalDrag = Math.abs(mouseX - this.mouseDownX) + Math.abs(mouseY - this.mouseDownY);
            if (totalDrag > 3.0) {
                this.hasDragged = true;
            }
            this.offsetX += dragX;
            this.offsetY += dragY;
            this.layoutDirty = true;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double old = this.zoom;
        this.zoom = verticalAmount > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.zoom = Math.max(0.1, Math.min(10.0, this.zoom));
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.layoutDirty = true;
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        this.mouseDownX = mouseX;
        this.mouseDownY = mouseY;
        this.hasDragged = false;
        this.dragging = true;
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.dragging) {
            Records.StructureInfo clickedInfo;
            this.dragging = false;
            if (!this.hasDragged && (clickedInfo = this.findClickedStructure(mouseX, mouseY)) != null) {
                BlockPos clicked = clickedInfo.pos();
                if (this.manualMode) {
                    this.handleManualClick(clicked);
                } else if (this.pendingTeleport != null && this.pendingTeleport.equals((Object)clicked) && System.currentTimeMillis() < this.teleportConfirmExpireMs) {
                    this.teleportTo(clicked);
                    this.pendingTeleport = null;
                } else {
                    this.pendingTeleport = clicked;
                    this.teleportConfirmExpireMs = System.currentTimeMillis() + 3000L;
                    String confirm = Component.translatable((String)"toast.roadweaver.teleport_confirm", (Object[])new Object[]{clicked.getX(), clicked.getZ()}).getString();
                    this.toast(confirm, 3000L);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateHoveredStructure(int mouseX, int mouseY) {
        Records.StructureInfo info = this.findClickedStructure(mouseX, mouseY);
        if (info != null) {
            this.hoveredStructure = info.pos();
            this.hoveredStructureId = info.structureId();
        } else {
            this.hoveredStructure = null;
            this.hoveredStructureId = null;
        }
    }

    private Records.StructureInfo findClickedStructure(double mouseX, double mouseY) {
        for (Records.StructureInfo info : this.structureInfos) {
            BlockPos structure = info.pos();
            ScreenPos pos = this.worldToScreen(structure.getX(), structure.getZ());
            double dx = (double)pos.x - mouseX;
            double dy = (double)pos.y - mouseY;
            if (!(Math.sqrt(dx * dx + dy * dy) <= 7.0)) continue;
            return info;
        }
        return null;
    }

    private void handleManualClick(BlockPos clicked) {
        if (this.manualFirst == null) {
            this.manualFirst = clicked;
            String pick = Component.translatable((String)"toast.roadweaver.manual_pick_start", (Object[])new Object[]{clicked.getX(), clicked.getZ()}).getString();
            this.toast(pick, 2000L);
        } else if (this.manualFirst.equals((Object)clicked)) {
            this.manualFirst = null;
            String cancel = Component.translatable((String)"toast.roadweaver.manual_cancelled").getString();
            this.toast(cancel, 2000L);
        } else {
            BlockPos first = this.manualFirst;
            this.manualFirst = null;
            this.createManualConnection(first, clicked);
        }
    }

    private void createManualConnection(BlockPos from, BlockPos to) {
        Minecraft client = Minecraft.getInstance();
        IntegratedServer server = client.getSingleplayerServer();
        if (server == null) {
            this.toast(Component.translatable((String)"toast.roadweaver.manual_multiplayer_not_supported").getString(), 2500L);
            return;
        }
        Records.StructureConnection newConn = new Records.StructureConnection(from, to, Records.ConnectionStatus.PLANNED, true);
        server.execute(() -> RoadDebugScreen.lambda$createManualConnection$12((MinecraftServer)server, from, to, newConn));
        this.connections.removeIf(conn -> (conn.from().equals((Object)from) && conn.to().equals((Object)to) || conn.from().equals((Object)to) && conn.to().equals((Object)from)) && conn.status() == Records.ConnectionStatus.FAILED);
        this.connections.add(newConn);
        this.toast(Component.translatable((String)"toast.roadweaver.manual_created").getString(), 2000L);
    }

    private void teleportTo(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.getSingleplayerServer() == null) {
            return;
        }
        IntegratedServer server = mc.getSingleplayerServer();
        String command = "/tp " + mc.player.getName().getString() + " " + pos.getX() + " ~ " + pos.getZ();
        server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), command);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private List<Records.StructureInfo> getVisibleStructures(MapRenderer.WorldToScreenConverter converter) {
        ArrayList<Records.StructureInfo> visible = new ArrayList<Records.StructureInfo>();
        for (Records.StructureInfo info : this.structureInfos) {
            BlockPos pos = info.pos();
            ScreenPos screenPos = converter.worldToScreen(pos.getX(), pos.getZ());
            if (screenPos.x < -50 || screenPos.x > this.width + 50 || screenPos.y < -50 || screenPos.y > this.height + 50) continue;
            visible.add(info);
        }
        return visible;
    }

    private static /* synthetic */ void lambda$createManualConnection$12(MinecraftServer server, BlockPos from, BlockPos to, Records.StructureConnection newConn) {
        ServerLevel world = server.overworld();
        WorldDataProvider provider = WorldDataProvider.getInstance();
        ArrayList<Records.StructureConnection> list = new ArrayList<Records.StructureConnection>(Optional.ofNullable(provider.getStructureConnections(world)).orElseGet(ArrayList::new));
        list.removeIf(conn -> (conn.from().equals((Object)from) && conn.to().equals((Object)to) || conn.from().equals((Object)to) && conn.to().equals((Object)from)) && conn.status() == Records.ConnectionStatus.FAILED);
        list.add(newConn);
        provider.setStructureConnections(world, list);
        StructureConnector.getQueueForWorld(world).add(newConn);
    }

    public static class ScreenBounds {
        private int left;
        private int right;
        private int top;
        private int bottom;

        public void update(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isInBounds(int x, int y, int margin) {
            return x >= this.left - margin && x <= this.right + margin && y >= this.top - margin && y <= this.bottom + margin;
        }

        public boolean isLineInBounds(int x1, int y1, int x2, int y2) {
            return !(x1 < this.left && x2 < this.left || x1 > this.right && x2 > this.right || y1 < this.top && y2 < this.top) && (y1 <= this.bottom || y2 <= this.bottom);
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public int top() {
            return this.top;
        }

        public int bottom() {
            return this.bottom;
        }
    }

    public record ScreenPos(int x, int y) {
    }
}

