/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.BenchDecoration;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.GlorietteDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.RoadFenceDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.decoration.SwingDecoration;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    public static final Set<Block> dontPlaceHere = new HashSet<Block>();
    public static int chunksForLocatingCounter;
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROAD_FEATURE_KEY;
    public static final ResourceKey<PlacedFeature> ROAD_FEATURE_PLACED_KEY;
    public static final Feature<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RoadFeatureConfig> context) {
        if (RoadPathCalculator.heightCache.size() > 100000) {
            RoadPathCalculator.heightCache.clear();
        }
        WorldGenLevel level = context.level();
        ServerLevel serverLevel = level.getLevel();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverLevel);
        if (structureLocationData == null) {
            return false;
        }
        List<BlockPos> villageLocations = structureLocationData.structureLocations();
        if (chunksForLocatingCounter % 50 == 0) {
            LOGGER.info("RoadFeature.place() called, counter: {}, structures: {}", (Object)chunksForLocatingCounter, (Object)villageLocations.size());
        }
        this.tryFindNewStructureConnection(villageLocations, serverLevel);
        HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
        this.runRoadLogic(level, context, roadDecorationCache);
        RoadStructures.tryPlaceDecorations(roadDecorationCache);
        return true;
    }

    private void tryFindNewStructureConnection(List<BlockPos> villageLocations, ServerLevel serverLevel) {
        int triggerDistance = ConfigProvider.get().structureSearchTriggerDistance();
        if (++chunksForLocatingCounter > triggerDistance) {
            LOGGER.info("\ud83d\udd0d Triggering new structure search (counter reached {}), current structures: {}", (Object)triggerDistance, (Object)villageLocations.size());
            serverLevel.getServer().execute(() -> StructureConnector.cacheNewConnection(serverLevel, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(WorldGenLevel level, FeaturePlaceContext<RoadFeatureConfig> context, Set<Decoration> roadDecorationPlacementPositions) {
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        ServerLevel serverLevel = level.getLevel();
        int averagingRadius = config.averagingRadius();
        List<Records.RoadData> roadDataList = dataProvider.getRoadDataList(serverLevel);
        if (roadDataList == null) {
            return;
        }
        ChunkPos currentChunkPos = new ChunkPos(context.origin());
        HashSet<BlockPos> posAlreadyContainsSegment = new HashSet<BlockPos>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segmentList = data.roadSegmentList();
            List<BlockPos> middlePositions = segmentList.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segmentList.size() - 2; ++i) {
                ChunkPos middleChunkPos;
                if (posAlreadyContainsSegment.contains(middlePositions.get(i))) continue;
                Records.RoadSegmentPlacement segment = segmentList.get(i);
                BlockPos segmentMiddlePos = segment.middlePos();
                if (++segmentIndex < 60 || segmentIndex > segmentList.size() - 60 || !(middleChunkPos = new ChunkPos(segmentMiddlePos)).equals((Object)currentChunkPos)) continue;
                BlockPos prevPos = middlePositions.get(i - 2);
                BlockPos nextPos = middlePositions.get(i + 2);
                ArrayList<Double> heights = new ArrayList<Double>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    BlockPos samplePos = middlePositions.get(j);
                    double y = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, samplePos.getX(), samplePos.getZ());
                    heights.add(y);
                }
                int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(segmentMiddlePos.getY()));
                BlockPos averagedPos = new BlockPos(segmentMiddlePos.getX(), averageY, segmentMiddlePos.getZ());
                RandomSource random = context.random();
                if (!config.placeWaypoints()) {
                    for (BlockPos widthBlock : segment.positions()) {
                        BlockPos correctedYPos = new BlockPos(widthBlock.getX(), averageY, widthBlock.getZ());
                        this.placeOnSurface(level, correctedYPos, materials, roadType, random);
                    }
                }
                this.addDecoration(level, roadDecorationPlacementPositions, averagedPos, segmentIndex, nextPos, prevPos, middlePositions, roadType, random, config);
                posAlreadyContainsSegment.add(segmentMiddlePos);
            }
        }
    }

    private static void tryPlaceDecorations(Set<Decoration> decorations) {
        RoadStructures.tryPlaceDecorations(decorations);
    }

    private void addDecoration(WorldGenLevel level, Set<Decoration> roadDecorationPlacementPositions, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middleBlockPositions, int roadType, RandomSource random, IModConfig config) {
        boolean isEnd;
        int dz;
        BlockPos surfacePos = placePos.atY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, placePos.getX(), placePos.getZ()));
        BlockState blockStateAtPos = level.getBlockState(surfacePos.below());
        if (config.placeWaypoints()) {
            if (segmentIndex % 25 == 0) {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(surfacePos, level));
            }
            return;
        }
        int dx = nextPos.getX() - prevPos.getX();
        double length = Math.sqrt(dx * dx + (dz = nextPos.getZ() - prevPos.getZ()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        Vec3i directionVector = new Vec3i(normDx, 0, normDz);
        Vec3i orthogonalVector = new Vec3i(-directionVector.getZ(), 0, directionVector.getX());
        boolean bl = isEnd = segmentIndex != middleBlockPositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middleBlockPositions.size() - 65) {
            BlockPos shiftedPos = isEnd ? placePos.offset(orthogonalVector.multiply(2)) : placePos.offset(orthogonalVector.multiply(-2));
            roadDecorationPlacementPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, level, isEnd, String.valueOf(middleBlockPositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftRoadSide = random.nextBoolean();
            BlockPos shiftedPos = leftRoadSide ? placePos.offset(orthogonalVector.multiply(2)) : placePos.offset(orthogonalVector.multiply(-2));
            if (Math.abs((shiftedPos = shiftedPos.atY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, shiftedPos.getX(), shiftedPos.getZ()))).getY() - placePos.getY()) > 1) {
                return;
            }
            if (roadType == 0) {
                roadDecorationPlacementPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, level, leftRoadSide));
            } else {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(shiftedPos, level));
            }
        } else if (config.placeRoadFences() && segmentIndex % 15 == 0) {
            boolean leftRoadSide = random.nextBoolean();
            BlockPos shiftedPos = leftRoadSide ? placePos.offset(orthogonalVector.multiply(2)) : placePos.offset(orthogonalVector.multiply(-2));
            if (Math.abs((shiftedPos = shiftedPos.atY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, shiftedPos.getX(), shiftedPos.getZ()))).getY() - placePos.getY()) > 1) {
                return;
            }
            int fenceLength = random.nextInt(1, 4);
            roadDecorationPlacementPositions.add(new RoadFenceDecoration(shiftedPos, orthogonalVector, level, leftRoadSide, fenceLength));
        } else if (segmentIndex % 80 == 0) {
            ArrayList<String> availableStructures = new ArrayList<String>();
            if (config.placeSwings()) {
                availableStructures.add("swing");
            }
            if (config.placeBenches()) {
                availableStructures.add("bench");
            }
            if (config.placeGloriettes()) {
                availableStructures.add("gloriette");
            }
            if (availableStructures.isEmpty()) {
                return;
            }
            String chosenStructure = (String)availableStructures.get(random.nextInt(availableStructures.size()));
            boolean leftRoadSide = random.nextBoolean();
            int distanceFromRoad = config.structureDistanceFromRoad();
            BlockPos shiftedPos = leftRoadSide ? placePos.offset(orthogonalVector.multiply(distanceFromRoad)) : placePos.offset(orthogonalVector.multiply(-distanceFromRoad));
            if (Math.abs((shiftedPos = shiftedPos.atY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, shiftedPos.getX(), shiftedPos.getZ()))).getY() - placePos.getY()) > 2) {
                return;
            }
            switch (chosenStructure) {
                case "swing": {
                    roadDecorationPlacementPositions.add(new SwingDecoration(shiftedPos, orthogonalVector, level));
                    break;
                }
                case "bench": {
                    roadDecorationPlacementPositions.add(new BenchDecoration(shiftedPos, orthogonalVector, level));
                    break;
                }
                case "gloriette": {
                    roadDecorationPlacementPositions.add(new GlorietteDecoration(shiftedPos, orthogonalVector, level));
                }
            }
        }
    }

    private void placeOnSurface(WorldGenLevel level, BlockPos placePos, List<BlockState> material, int natural, RandomSource random) {
        BlockPos topPos;
        BlockState blockStateAtPos;
        IModConfig config = ConfigProvider.get();
        double naturalBlockChance = 0.5;
        BlockPos surfacePos = placePos;
        if (natural == 1 || config.averagingRadius() == 0) {
            surfacePos = new BlockPos(placePos.getX(), level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, placePos.getX(), placePos.getZ()), placePos.getZ());
        }
        if ((blockStateAtPos = level.getBlockState((topPos = new BlockPos(surfacePos.getX(), level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, surfacePos.getX(), surfacePos.getZ()), surfacePos.getZ())).below())).equals(Blocks.WATER.defaultBlockState())) {
            level.setBlock(topPos, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (natural == 0 || random.nextDouble() < naturalBlockChance) {
            this.placeRoadBlock(level, blockStateAtPos, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(WorldGenLevel level, BlockState blockStateAtPos, BlockPos surfacePos, List<BlockState> materials, RandomSource deterministicRandom) {
        BlockState blockStateUp;
        if (!this.placeAllowedCheck(blockStateAtPos.getBlock()) || !level.getBlockState(surfacePos.below()).canOcclude() && !level.getBlockState(surfacePos.below(2)).canOcclude()) {
            return;
        }
        BlockState material = materials.get(deterministicRandom.nextInt(materials.size()));
        level.setBlock(surfacePos.below(), material, 3);
        for (int i = 0; !(i >= 3 || (blockStateUp = level.getBlockState(surfacePos.above(i))).getBlock().equals(Blocks.AIR) || blockStateUp.is(BlockTags.LOGS) || blockStateUp.is(BlockTags.FENCES)); ++i) {
            level.setBlock(surfacePos.above(i), Blocks.AIR.defaultBlockState(), 3);
        }
        BlockPos belowPos1 = surfacePos.below(2);
        BlockState belowState1 = level.getBlockState(belowPos1);
        if (belowState1.getBlock().equals(Blocks.GRASS_BLOCK)) {
            level.setBlock(belowPos1, Blocks.DIRT.defaultBlockState(), 3);
        }
    }

    private boolean placeAllowedCheck(Block blockToCheck) {
        return !dontPlaceHere.contains(blockToCheck) && !blockToCheck.defaultBlockState().is(BlockTags.LEAVES) && !blockToCheck.defaultBlockState().is(BlockTags.LOGS) && !blockToCheck.defaultBlockState().is(BlockTags.UNDERWATER_BONEMEALS) && !blockToCheck.defaultBlockState().is(BlockTags.WOODEN_FENCES) && !blockToCheck.defaultBlockState().is(BlockTags.PLANKS);
    }

    static {
        dontPlaceHere.add(Blocks.PACKED_ICE);
        dontPlaceHere.add(Blocks.ICE);
        dontPlaceHere.add(Blocks.BLUE_ICE);
        dontPlaceHere.add(Blocks.TALL_SEAGRASS);
        dontPlaceHere.add(Blocks.MANGROVE_ROOTS);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"road_feature"));
        ROAD_FEATURE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"road_feature_placed"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

