/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.RoadPlacementRules;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public abstract class Decoration {
    private BlockPos placePos;
    private final WorldGenLevel world;

    public Decoration(BlockPos placePos, WorldGenLevel world) {
        this.placePos = placePos;
        this.world = world;
    }

    public abstract void place();

    protected final boolean placeAllowed() {
        boolean belowInvalid;
        BlockPos surfacePos;
        BlockPos placePos = this.getPos();
        this.placePos = surfacePos = placePos.atY(this.world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, placePos.getX(), placePos.getZ()));
        BlockState blockStateBelow = this.world.getBlockState(surfacePos.below());
        boolean bl = belowInvalid = blockStateBelow.is(Blocks.WATER) || blockStateBelow.is(Blocks.LAVA) || blockStateBelow.is(BlockTags.LOGS) || RoadPlacementRules.dontPlaceHere.contains(blockStateBelow.getBlock());
        return !belowInvalid;
    }

    public BlockPos getPos() {
        return this.placePos;
    }

    public WorldGenLevel getWorld() {
        return this.world;
    }
}

