/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.roadlogic.RoadDirection;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadPathCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final int NEIGHBOR_DISTANCE = 4;
    public static final Map<Long, Integer> heightCache = new ConcurrentHashMap<Long, Integer>();

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos start, BlockPos end, int width, ServerLevel serverWorld, int maxSteps) {
        IModConfig cfg = ConfigProvider.get();
        return RoadPathCalculator.calculateAStarRoadPath(start, end, width, serverWorld, maxSteps, cfg.maxHeightDifference(), cfg.maxTerrainStability(), false);
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos start, BlockPos end, int width, ServerLevel serverWorld, int maxSteps, int maxHeightDifference, int maxTerrainStability) {
        return RoadPathCalculator.calculateAStarRoadPath(start, end, width, serverWorld, maxSteps, maxHeightDifference, maxTerrainStability, false);
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos start, BlockPos end, int width, ServerLevel serverWorld, int maxSteps, int maxHeightDifference, int maxTerrainStability, boolean ignoreWater) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fScore));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        HashMap<BlockPos, List<BlockPos>> interpolatedSegments = new HashMap<BlockPos, List<BlockPos>>();
        int startX = RoadPathCalculator.snapToGrid(start.getX(), 4);
        int startZ = RoadPathCalculator.snapToGrid(start.getZ(), 4);
        int endX = RoadPathCalculator.snapToGrid(end.getX(), 4);
        int endZ = RoadPathCalculator.snapToGrid(end.getZ(), 4);
        start = new BlockPos(startX, start.getY(), startZ);
        end = new BlockPos(endX, end.getY(), endZ);
        BlockPos startGround = new BlockPos(start.getX(), RoadPathCalculator.heightSampler(start.getX(), start.getZ(), serverWorld), start.getZ());
        BlockPos endGround = new BlockPos(end.getX(), RoadPathCalculator.heightSampler(end.getX(), end.getZ(), serverWorld), end.getZ());
        Node startNode = new Node(startGround, null, 0.0, RoadPathCalculator.heuristic(startGround, endGround));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = 4;
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        while (!openSet.isEmpty() && maxSteps-- > 0) {
            Node current = openSet.poll();
            if (current.pos.offset(0, -current.pos.getY(), 0).distManhattan((Vec3i)endGround.offset(0, -endGround.getY(), 0)) < 8) {
                LOGGER.debug("Found path! {}", (Object)current.pos);
                return RoadPathCalculator.reconstructPath(current, width, interpolatedSegments);
            }
            closedSet.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] offset : neighborOffsets) {
                BlockPos neighborXZ = current.pos.offset(offset[0], 0, offset[1]);
                int y = RoadPathCalculator.heightSampler(neighborXZ.getX(), neighborXZ.getZ(), serverWorld);
                BlockPos neighborPos = new BlockPos(neighborXZ.getX(), y, neighborXZ.getZ());
                if (closedSet.contains(neighborPos)) continue;
                Holder<Biome> biomeHolder = RoadPathCalculator.biomeSampler(neighborPos, serverWorld);
                boolean isWater = biomeHolder.is(BiomeTags.IS_RIVER) || biomeHolder.is(BiomeTags.IS_OCEAN) || biomeHolder.is(BiomeTags.IS_DEEP_OCEAN);
                int biomeCost = isWater && !ignoreWater ? 50 : 0;
                int elevation = Math.abs(y - current.pos.getY());
                if (elevation > maxHeightDifference) continue;
                int offsetSum = Math.abs(Math.abs(offset[0])) + Math.abs(offset[1]);
                double stepCost = offsetSum == 8 ? 1.5 : 1.0;
                int terrainStabilityCost = RoadPathCalculator.calculateTerrainStability(neighborPos, y, serverWorld);
                if (terrainStabilityCost > maxTerrainStability) continue;
                int yLevelCost = y == serverWorld.getSeaLevel() ? 20 : 0;
                double tentativeG = current.gScore + stepCost + (double)(elevation * 40) + (double)(biomeCost * 8) + (double)(yLevelCost * 8) + (double)(terrainStabilityCost * 16);
                Node neighbor = (Node)allNodes.get(neighborPos);
                if (neighbor != null && !(tentativeG < neighbor.gScore)) continue;
                double h = RoadPathCalculator.heuristic(neighborPos, endGround);
                neighbor = new Node(neighborPos, current, tentativeG, tentativeG + h);
                allNodes.put(neighborPos, neighbor);
                openSet.add(neighbor);
                ArrayList<BlockPos> segmentPoints = new ArrayList<BlockPos>();
                for (int i = 1; i < 4; ++i) {
                    int interpX = current.pos.getX() + offset[0] * i / 4;
                    int interpZ = current.pos.getZ() + offset[1] * i / 4;
                    BlockPos interpolated = new BlockPos(interpX, current.pos.getY(), interpZ);
                    segmentPoints.add(interpolated);
                }
                interpolatedSegments.put(neighborPos, segmentPoints);
            }
        }
        return Collections.emptyList();
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        int dx = a.getX() - b.getX();
        int dz = a.getZ() - b.getZ();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 30.0;
    }

    private static int calculateTerrainStability(BlockPos neighborPos, int y, ServerLevel serverWorld) {
        int cost = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = neighborPos.relative(direction);
            int testY = RoadPathCalculator.heightSampler(testPos.getX(), testPos.getZ(), serverWorld);
            int elevation = Math.abs(y - testY);
            cost += elevation;
        }
        return cost;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, Map<BlockPos, List<BlockPos>> interpolatedPathMap) {
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        Node current = endNode;
        while (current != null) {
            pathNodes.add(current);
            current = current.parent;
        }
        Collections.reverse(pathNodes);
        LinkedHashMap<BlockPos, Set<BlockPos>> roadSegments = new LinkedHashMap<BlockPos, Set<BlockPos>>();
        HashSet<BlockPos> widthCache = new HashSet<BlockPos>();
        for (Node node : pathNodes) {
            BlockPos pos = node.pos;
            List interpolated = interpolatedPathMap.getOrDefault(pos, Collections.emptyList());
            RoadDirection roadDirection = RoadDirection.X_AXIS;
            if (!interpolated.isEmpty()) {
                BlockPos firstInterpolated = (BlockPos)interpolated.get(0);
                int dx = pos.getX() - firstInterpolated.getX();
                int dz = pos.getZ() - firstInterpolated.getZ();
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    roadDirection = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    roadDirection = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    roadDirection = RoadDirection.Z_AXIS;
                }
                for (BlockPos interp : interpolated) {
                    Set<BlockPos> widthSetInterp = RoadPathCalculator.generateWidth(interp, width / 2, widthCache, roadDirection);
                    roadSegments.put(interp, widthSetInterp);
                }
            }
            Set<BlockPos> widthSet = RoadPathCalculator.generateWidth(pos, width / 2, widthCache, roadDirection);
            roadSegments.put(pos, widthSet);
        }
        ArrayList<Records.RoadSegmentPlacement> result = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry entry : roadSegments.entrySet()) {
            result.add(new Records.RoadSegmentPlacement((BlockPos)entry.getKey(), new ArrayList<BlockPos>((Collection)entry.getValue())));
        }
        return result;
    }

    private static int heightSampler(int x, int z, ServerLevel serverWorld) {
        long key = RoadPathCalculator.hashXZ(x, z);
        return heightCache.computeIfAbsent(key, k -> {
            int seaLevel = serverWorld.getSeaLevel();
            int oceanFloorHeight = serverWorld.getChunkSource().getGenerator().getBaseHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)serverWorld, serverWorld.getChunkSource().randomState());
            int worldSurfaceHeight = serverWorld.getChunkSource().getGenerator().getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)serverWorld, serverWorld.getChunkSource().randomState());
            if (worldSurfaceHeight <= seaLevel && oceanFloorHeight < seaLevel) {
                return seaLevel;
            }
            return worldSurfaceHeight;
        });
    }

    private static Holder<Biome> biomeSampler(BlockPos pos, ServerLevel serverWorld) {
        return serverWorld.getBiome(pos);
    }

    private static int snapToGrid(int value, int gridSize) {
        return Math.floorDiv(value, gridSize) * gridSize;
    }

    private static Set<BlockPos> generateWidth(BlockPos center, int radius, Set<BlockPos> widthPositionsCache, RoadDirection direction) {
        HashSet<BlockPos> segmentWidthPositions = new HashSet<BlockPos>();
        int centerX = center.getX();
        int centerZ = center.getZ();
        int y = 0;
        if (direction == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos pos = new BlockPos(centerX, y, centerZ + dz);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else if (direction == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                BlockPos pos = new BlockPos(centerX + dx, y, centerZ);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos;
                    if (direction == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || direction == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || widthPositionsCache.contains(pos = new BlockPos(centerX + dx, y, centerZ + dz))) continue;
                    widthPositionsCache.add(pos);
                    segmentWidthPositions.add(pos);
                }
            }
        }
        return segmentWidthPositions;
    }

    private static class Node {
        BlockPos pos;
        Node parent;
        double gScore;
        double fScore;

        Node(BlockPos pos, Node parent, double gScore, double fScore) {
            this.pos = pos;
            this.parent = parent;
            this.gScore = gScore;
            this.fScore = fScore;
        }
    }
}

