/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocatorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    private StructureLocatorImpl() {
    }

    public static void locateConfiguredStructure(ServerLevel level, int locateCount, boolean locateAtPlayer) {
        if (locateCount <= 0) {
            return;
        }
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData locationData = dataProvider.getStructureLocations(level);
        if (locationData == null) {
            locationData = new Records.StructureLocationData(new ArrayList<BlockPos>());
        }
        ArrayList<BlockPos> knownLocations = new ArrayList<BlockPos>(locationData.structureLocations());
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>(locationData.structureInfos());
        HashSet<BlockPos> newlyFound = new HashSet<BlockPos>();
        Optional<HolderSet<Structure>> targetStructures = StructureLocatorImpl.resolveStructureTargets(level, config.structuresToLocate());
        if (targetStructures.isEmpty()) {
            LOGGER.warn("RoadWeaver: \u65e0\u6cd5\u89e3\u6790\u7ed3\u6784\u76ee\u6807\u5217\u8868\uff0c\u8df3\u8fc7\u5b9a\u4f4d\u3002");
            return;
        }
        List<BlockPos> centers = StructureLocatorImpl.collectSearchCenters(level, locateAtPlayer);
        int radius = Math.max(config.structureSearchRadius(), 1);
        LOGGER.debug("RoadWeaver: locating up to {} structure(s) - centers={}, radius={}, atPlayer={}", new Object[]{locateCount, centers.size(), radius, locateAtPlayer});
        for (BlockPos center : centers) {
            if (locateCount <= 0) break;
            Pair result = level.getChunkSource().getGenerator().findNearestMapStructure(level, targetStructures.get(), center, radius, true);
            if (result == null) continue;
            BlockPos structurePos = (BlockPos)result.getFirst();
            Holder structureHolder = (Holder)result.getSecond();
            if (StructureLocatorImpl.containsBlockPos(knownLocations, structurePos)) continue;
            knownLocations.add(structurePos);
            newlyFound.add(structurePos);
            String structureId = structureHolder.unwrapKey().map(key -> key.location().toString()).orElse("unknown");
            structureInfos.add(new Records.StructureInfo(structurePos, structureId));
            --locateCount;
        }
        if (!newlyFound.isEmpty()) {
            dataProvider.setStructureLocations(level, new Records.StructureLocationData(knownLocations, structureInfos));
            LOGGER.debug("RoadWeaver: \u5b9a\u4f4d\u5230 {} \u4e2a\u65b0\u7ed3\u6784: {}", (Object)newlyFound.size(), newlyFound);
        }
    }

    private static Optional<HolderSet<Structure>> resolveStructureTargets(ServerLevel level, String identifiers) {
        String[] tokens;
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        ArrayList holders = new ArrayList();
        if (identifiers == null || identifiers.isBlank()) {
            return Optional.empty();
        }
        for (String raw : tokens = identifiers.split("[;,\\s]+")) {
            if (raw == null) continue;
            String token = raw.trim().replace("\r", "").replace("\n", "");
            token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
            if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                token = token.substring(1);
            }
            if ((token = token.replace('\uff03', '#').replace('\u201c', ' ').replace('\u201d', ' ').replace('\u300c', ' ').replace('\u300d', ' ').replace('\u300e', ' ').replace('\u300f', ' ').replace('\u300a', ' ').replace('\u300b', ' ').trim()).isBlank()) continue;
            int hashIdx = token.indexOf(35);
            if (hashIdx >= 0) {
                String tagToken = token.substring(hashIdx + 1).trim();
                try {
                    ResourceLocation tagId = ResourceLocation.parse((String)tagToken);
                    TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)tagId);
                    registry.getTag(tag).ifPresentOrElse(named -> {
                        for (Holder h : named) {
                            holders.add(h);
                        }
                    }, () -> LOGGER.warn("RoadWeaver: structure tag not found: #{}", (Object)tagToken));
                }
                catch (Exception ex) {
                    LOGGER.warn("RoadWeaver: invalid structure tag token skipped: #{} (raw='{}')", (Object)tagToken, (Object)raw);
                }
                continue;
            }
            try {
                String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                if (cleaned.contains("*")) {
                    String pattern = cleaned.replace("*", "");
                    int matchCount = 0;
                    for (Map.Entry entry : registry.entrySet()) {
                        String structureId = ((ResourceKey)entry.getKey()).location().toString();
                        if (!structureId.startsWith(pattern)) continue;
                        registry.getHolder((ResourceKey)entry.getKey()).ifPresent(holders::add);
                        ++matchCount;
                    }
                    if (matchCount > 0) {
                        LOGGER.info("RoadWeaver: \u901a\u914d\u7b26 '{}' \u5339\u914d\u5230 {} \u4e2a\u7ed3\u6784", (Object)cleaned, (Object)matchCount);
                        continue;
                    }
                    LOGGER.warn("RoadWeaver: \u901a\u914d\u7b26 '{}' \u672a\u5339\u914d\u5230\u4efb\u4f55\u7ed3\u6784", (Object)cleaned);
                    continue;
                }
                ResourceLocation id = ResourceLocation.parse((String)cleaned);
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)id);
                registry.getHolder(key).ifPresentOrElse(holders::add, () -> LOGGER.warn("RoadWeaver: structure id not found: {}", (Object)cleaned));
            }
            catch (Exception ex) {
                LOGGER.warn("RoadWeaver: invalid structure id token skipped: {} (raw='{}')", (Object)token, (Object)raw);
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(HolderSet.direct(holders));
    }

    private static Optional<HolderSet<Structure>> resolveStructureTargets(ServerLevel level, List<String> identifiersList) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        ArrayList holders = new ArrayList();
        if (identifiersList == null || identifiersList.isEmpty()) {
            return Optional.empty();
        }
        for (String line : identifiersList) {
            String[] tokens;
            String norm;
            if (line == null || (norm = line.replace('\r', ' ').replace('\n', ' ').trim()).isEmpty()) continue;
            for (String raw : tokens = norm.split("[;,\\s]+")) {
                String token;
                if (raw == null || (token = raw.trim()).isEmpty()) continue;
                token = token.replace("\r", "").replace("\n", "");
                token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
                if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                    token = token.substring(1);
                }
                if ((token = token.replace('\uff03', '#').replace('\u201c', ' ').replace('\u201d', ' ').replace('\u300c', ' ').replace('\u300d', ' ').replace('\u300e', ' ').replace('\u300f', ' ').replace('\u300a', ' ').replace('\u300b', ' ').trim()).isEmpty()) continue;
                int hashIdx = token.indexOf(35);
                if (hashIdx >= 0) {
                    String tagToken = token.substring(hashIdx + 1).trim();
                    try {
                        ResourceLocation tagId = ResourceLocation.parse((String)tagToken);
                        TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)tagId);
                        registry.getTag(tag).ifPresentOrElse(named -> {
                            for (Holder h : named) {
                                holders.add(h);
                            }
                        }, () -> LOGGER.warn("RoadWeaver: structure tag not found: #{}", (Object)tagToken));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("RoadWeaver: invalid structure tag token skipped: #{} (line='{}')", (Object)tagToken, (Object)line);
                    }
                    continue;
                }
                try {
                    String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                    if (cleaned.contains("*")) {
                        String pattern = cleaned.replace("*", "");
                        int matchCount = 0;
                        for (Map.Entry entry : registry.entrySet()) {
                            String structureId = ((ResourceKey)entry.getKey()).location().toString();
                            if (!structureId.startsWith(pattern)) continue;
                            registry.getHolder((ResourceKey)entry.getKey()).ifPresent(holders::add);
                            ++matchCount;
                        }
                        if (matchCount > 0) {
                            LOGGER.info("RoadWeaver: \u901a\u914d\u7b26 '{}' \u5339\u914d\u5230 {} \u4e2a\u7ed3\u6784", (Object)cleaned, (Object)matchCount);
                            continue;
                        }
                        LOGGER.warn("RoadWeaver: \u901a\u914d\u7b26 '{}' \u672a\u5339\u914d\u5230\u4efb\u4f55\u7ed3\u6784", (Object)cleaned);
                        continue;
                    }
                    ResourceLocation id = ResourceLocation.parse((String)cleaned);
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)id);
                    registry.getHolder(key).ifPresentOrElse(holders::add, () -> LOGGER.warn("RoadWeaver: structure id not found: {}", (Object)cleaned));
                }
                catch (Exception ex) {
                    LOGGER.warn("RoadWeaver: invalid structure id token skipped: {} (line='{}')", (Object)token, (Object)line);
                }
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(HolderSet.direct(holders));
    }

    private static List<BlockPos> collectSearchCenters(ServerLevel level, boolean locateAtPlayer) {
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>();
        if (locateAtPlayer) {
            for (ServerPlayer player : level.players()) {
                centers.add(player.blockPosition());
            }
        }
        BlockPos spawn = level.getSharedSpawnPos();
        if (centers.isEmpty()) {
            int[] muls;
            centers.add(spawn);
            int r = Math.max(ConfigProvider.get().structureSearchRadius(), 1);
            for (int m : muls = new int[]{3, 6}) {
                int d = r * m;
                centers.add(spawn.offset(d, 0, 0));
                centers.add(spawn.offset(-d, 0, 0));
                centers.add(spawn.offset(0, 0, d));
                centers.add(spawn.offset(0, 0, -d));
                centers.add(spawn.offset(d, 0, d));
                centers.add(spawn.offset(-d, 0, d));
                centers.add(spawn.offset(d, 0, -d));
                centers.add(spawn.offset(-d, 0, -d));
            }
        }
        return centers;
    }

    private static boolean containsBlockPos(List<BlockPos> list, BlockPos pos) {
        for (BlockPos existing : list) {
            if (!existing.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }
}

