/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.persistence.neoforge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.SettlementRoads;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class WorldDataHelper {
    private static final String STRUCTURE_LOCATIONS_NAME = "roadweaver_structure_locations";
    private static final String CONNECTED_STRUCTURES_NAME = "roadweaver_connected_structures";
    private static final String ROAD_DATA_NAME = "roadweaver_road_data";

    public static Records.StructureLocationData getStructureLocations(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        StructureLocationsData data = (StructureLocationsData)storage.computeIfAbsent(new SavedData.Factory(() -> new StructureLocationsData(new ArrayList<BlockPos>()), (tag, provider) -> StructureLocationsData.load(tag)), STRUCTURE_LOCATIONS_NAME);
        return data.data;
    }

    public static void setStructureLocations(ServerLevel level, Records.StructureLocationData data) {
        DimensionDataStorage storage = level.getDataStorage();
        StructureLocationsData savedData = (StructureLocationsData)storage.computeIfAbsent(new SavedData.Factory(() -> new StructureLocationsData(data), (tag, provider) -> StructureLocationsData.load(tag)), STRUCTURE_LOCATIONS_NAME);
        savedData.data = data;
        savedData.setDirty();
    }

    public static List<Records.StructureConnection> getConnectedStructures(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        ConnectedStructuresData data = (ConnectedStructuresData)storage.computeIfAbsent(new SavedData.Factory(() -> new ConnectedStructuresData(new ArrayList<Records.StructureConnection>()), (tag, provider) -> ConnectedStructuresData.load(tag)), CONNECTED_STRUCTURES_NAME);
        return data.connections;
    }

    public static void setConnectedStructures(ServerLevel level, List<Records.StructureConnection> connections) {
        DimensionDataStorage storage = level.getDataStorage();
        ConnectedStructuresData data = (ConnectedStructuresData)storage.computeIfAbsent(new SavedData.Factory(() -> new ConnectedStructuresData(connections), (tag, provider) -> ConnectedStructuresData.load(tag)), CONNECTED_STRUCTURES_NAME);
        data.connections = connections;
        data.setDirty();
    }

    public static List<Records.RoadData> getRoadDataList(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        RoadDataStorage data = (RoadDataStorage)storage.computeIfAbsent(new SavedData.Factory(() -> new RoadDataStorage(new ArrayList<Records.RoadData>()), (tag, provider) -> RoadDataStorage.load(tag)), ROAD_DATA_NAME);
        return data.roadDataList;
    }

    public static void setRoadDataList(ServerLevel level, List<Records.RoadData> roadDataList) {
        DimensionDataStorage storage = level.getDataStorage();
        RoadDataStorage data = (RoadDataStorage)storage.computeIfAbsent(new SavedData.Factory(() -> new RoadDataStorage(roadDataList), (tag, provider) -> RoadDataStorage.load(tag)), ROAD_DATA_NAME);
        data.roadDataList = roadDataList;
        data.setDirty();
    }

    private static class StructureLocationsData
    extends SavedData {
        private Records.StructureLocationData data;

        public StructureLocationsData(Records.StructureLocationData data) {
            this.data = data;
        }

        public StructureLocationsData(List<BlockPos> locations) {
            this.data = new Records.StructureLocationData(locations);
        }

        public static StructureLocationsData load(CompoundTag tag) {
            Records.StructureLocationData data = Records.StructureLocationData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("data")).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to load structure locations: {}", error)).orElse(new Records.StructureLocationData(new ArrayList<BlockPos>()));
            return new StructureLocationsData(data);
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            Records.StructureLocationData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.data).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to save structure locations: {}", error)).ifPresent(nbt -> tag.put("data", nbt));
            return tag;
        }
    }

    private static class ConnectedStructuresData
    extends SavedData {
        private List<Records.StructureConnection> connections;

        public ConnectedStructuresData(List<Records.StructureConnection> connections) {
            this.connections = connections;
        }

        public static ConnectedStructuresData load(CompoundTag tag) {
            Codec codec = Codec.list(Records.StructureConnection.CODEC);
            List connections = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("data")).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to load connected structures: {}", error)).orElse(new ArrayList());
            return new ConnectedStructuresData(connections);
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            Codec codec = Codec.list(Records.StructureConnection.CODEC);
            codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.connections).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to save connected structures: {}", error)).ifPresent(nbt -> tag.put("data", nbt));
            return tag;
        }
    }

    private static class RoadDataStorage
    extends SavedData {
        private List<Records.RoadData> roadDataList;

        public RoadDataStorage(List<Records.RoadData> roadDataList) {
            this.roadDataList = roadDataList;
        }

        public static RoadDataStorage load(CompoundTag tag) {
            Codec codec = Codec.list(Records.RoadData.CODEC);
            List roadDataList = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("data")).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to load road data: {}", error)).orElse(new ArrayList());
            return new RoadDataStorage(roadDataList);
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            Codec codec = Codec.list(Records.RoadData.CODEC);
            codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.roadDataList).resultOrPartial(error -> SettlementRoads.getLogger().error("Failed to save road data: {}", error)).ifPresent(nbt -> tag.put("data", nbt));
            return tag;
        }
    }
}

