/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RoadDebugScreen
extends class_437 {
    private static final int RADIUS = 5;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private final List<class_2338> structures;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;
    private final Map<class_2338, ScreenPos> screenPositions = new HashMap<class_2338, ScreenPos>();
    private final Map<String, Integer> statusColors = Map.of("structure", -14176672, "planned", -865972, "generating", -1671646, "completed", -14176672, "failed", -1618884, "road", -13330213);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 3.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private double lastZoom = 1.0;
    private double lastOffsetX = 0.0;
    private double lastOffsetY = 0.0;
    private static final double LOD_DISTANCE_1 = 0.3;
    private static final double LOD_DISTANCE_2 = 1.0;
    private static final double LOD_DISTANCE_3 = 3.0;
    private static final double ROAD_LOD_FINEST = 300.0;
    private static final double ROAD_LOD_64TH = 300.0;
    private static final double ROAD_LOD_128TH = 500.0;
    private static final double ROAD_LOD_256TH = 1000.0;
    private static final double ROAD_LOD_512TH = 2000.0;
    private static final double ROAD_LOD_1024TH = 5000.0;
    private static final double ROAD_LOD_NONE = 10000.0;
    private int uiLeft;
    private int uiRight;
    private int uiTop;
    private int uiBottom;
    private boolean uiBoundsDirty = true;
    private final Map<Integer, String> gridLabelCache = new HashMap<Integer, String>();
    private static final int[][] CIRCLE_CACHE = new int[20][];

    public RoadDebugScreen(List<class_2338> structures, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.debug_map.title"));
        this.structures = structures != null ? new ArrayList<class_2338>(structures) : new ArrayList();
        this.connections = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        List<Records.RoadData> list = this.roads = roads != null ? new ArrayList<Records.RoadData>(roads) : new ArrayList();
        if (!this.structures.isEmpty()) {
            this.minX = this.structures.stream().mapToInt(class_2382::method_10263).min().orElse(0);
            this.maxX = this.structures.stream().mapToInt(class_2382::method_10263).max().orElse(0);
            this.minZ = this.structures.stream().mapToInt(class_2382::method_10260).min().orElse(0);
            this.maxZ = this.structures.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.layoutDirty || this.lastWidth != this.field_22789 || this.lastHeight != this.field_22790 || this.lastZoom != this.zoom || this.lastOffsetX != this.offsetX || this.lastOffsetY != this.offsetY) {
            this.computeLayout();
            this.updateUIBounds();
            this.lastWidth = this.field_22789;
            this.lastHeight = this.field_22790;
            this.lastZoom = this.zoom;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.layoutDirty = false;
            this.uiBoundsDirty = false;
        }
        this.drawPanel(ctx, 20, 20, this.field_22789 - 20, this.field_22790 - 20, -535818224, -13882324);
        LODLevel lodLevel = this.getLODLevel();
        if (lodLevel != LODLevel.MINIMAL) {
            this.drawGrid(ctx);
        }
        this.drawRoadPathsLOD(ctx, lodLevel);
        if (lodLevel != LODLevel.MINIMAL) {
            for (Records.StructureConnection conn : this.connections) {
                if (conn.status() == Records.ConnectionStatus.COMPLETED) continue;
                ScreenPos a = this.screenPositions.get(conn.from());
                ScreenPos b = this.screenPositions.get(conn.to());
                if (a == null || b == null || !this.isLineInUIBounds(a.x, a.y, b.x, b.y)) continue;
                int color = switch (conn.status()) {
                    default -> throw new MatchException(null, null);
                    case Records.ConnectionStatus.PLANNED -> -10496;
                    case Records.ConnectionStatus.GENERATING -> -29696;
                    case Records.ConnectionStatus.COMPLETED -> this.statusColors.get("completed");
                    case Records.ConnectionStatus.FAILED -> -48060;
                };
                RoadDebugScreen.drawLine(ctx, a.x, a.y, b.x, b.y, color);
            }
        }
        class_2338 hovered = null;
        for (class_2338 pos : this.structures) {
            int nodeRadius;
            ScreenPos p = this.screenPositions.get(pos);
            if (p == null || !this.isInUIBounds(p.x, p.y, (nodeRadius = this.getAdaptiveNodeRadius(lodLevel)) + 2)) continue;
            this.drawStructureNodeLOD(ctx, p.x, p.y, lodLevel);
            if (!(RoadDebugScreen.dist2(p.x, p.y, mouseX, mouseY) <= (double)((nodeRadius + 2) * (nodeRadius + 2)))) continue;
            hovered = pos;
        }
        this.drawPlayerMarkerLOD(ctx, lodLevel);
        this.drawTitle(ctx);
        this.drawStatsPanel(ctx);
        if (lodLevel == LODLevel.HIGH || lodLevel == LODLevel.MEDIUM) {
            this.drawLegendPanel(ctx);
            this.drawScalePanel(ctx);
        }
        if (hovered != null) {
            this.drawTooltip(ctx, hovered, mouseX, mouseY);
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private LODLevel getLODLevel() {
        if (this.zoom > 3.0) {
            return LODLevel.HIGH;
        }
        if (this.zoom > 1.0) {
            return LODLevel.MEDIUM;
        }
        if (this.zoom > 0.3) {
            return LODLevel.LOW;
        }
        return LODLevel.MINIMAL;
    }

    private RoadLODLevel getRoadLODLevel() {
        double blocksPerPixel = 1.0 / (this.baseScale * this.zoom);
        double blocksPerGrid = blocksPerPixel * 80.0;
        if (blocksPerGrid < 300.0) {
            return RoadLODLevel.FINEST;
        }
        if (blocksPerGrid < 500.0) {
            return RoadLODLevel.SIXTY_FOURTH;
        }
        if (blocksPerGrid < 1000.0) {
            return RoadLODLevel.ONE_TWENTY_EIGHTH;
        }
        if (blocksPerGrid < 2000.0) {
            return RoadLODLevel.TWO_FIFTY_SIXTH;
        }
        if (blocksPerGrid < 5000.0) {
            return RoadLODLevel.FIVE_TWELVE;
        }
        if (blocksPerGrid < 10000.0) {
            return RoadLODLevel.ONE_THOUSAND_TWENTY_FOURTH;
        }
        return RoadLODLevel.NONE;
    }

    private void updateUIBounds() {
        this.uiLeft = 20;
        this.uiRight = this.field_22789 - 20;
        this.uiTop = 20;
        this.uiBottom = this.field_22790 - 20;
    }

    private boolean isInUIBounds(int x, int y, int margin) {
        return x >= this.uiLeft - margin && x <= this.uiRight + margin && y >= this.uiTop - margin && y <= this.uiBottom + margin;
    }

    private boolean isLineInUIBounds(int x1, int y1, int x2, int y2) {
        return !(x1 < this.uiLeft && x2 < this.uiLeft || x1 > this.uiRight && x2 > this.uiRight || y1 < this.uiTop && y2 < this.uiTop) && (y1 <= this.uiBottom || y2 <= this.uiBottom);
    }

    private void drawRoadPathsLOD(class_332 ctx, LODLevel lod) {
        if (this.roads == null || this.roads.isEmpty()) {
            return;
        }
        if (lod == LODLevel.MINIMAL) {
            return;
        }
        RoadLODLevel roadLOD = this.getRoadLODLevel();
        if (roadLOD == RoadLODLevel.NONE) {
            return;
        }
        int roadColor = this.statusColors.get("road") & 0xFFFFFF | Integer.MIN_VALUE;
        boolean needsRoughCheck = roadLOD == RoadLODLevel.FIVE_TWELVE || roadLOD == RoadLODLevel.ONE_THOUSAND_TWENTY_FOURTH || roadLOD == RoadLODLevel.NONE;
        for (Records.RoadData roadData : this.roads) {
            List<Records.RoadSegmentPlacement> segments = roadData.roadSegmentList();
            if (segments == null || segments.size() < 2) continue;
            if (needsRoughCheck && segments.size() > 1) {
                class_2338 start = segments.get(0).middlePos();
                class_2338 end = segments.get(segments.size() - 1).middlePos();
                ScreenPos startScreen = this.worldToScreen(start.method_10263(), start.method_10260());
                ScreenPos endScreen = this.worldToScreen(end.method_10263(), end.method_10260());
                if (!this.isInUIBounds(startScreen.x, startScreen.y, 200) && !this.isInUIBounds(endScreen.x, endScreen.y, 200)) continue;
            }
            this.drawRoadPathWithRoadLOD(ctx, segments, roadColor, roadLOD);
        }
    }

    public boolean method_25422() {
        return true;
    }

    protected void method_57734(float delta) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        class_2338 clicked = this.findClickedStructure(mouseX, mouseY);
        if (clicked != null) {
            this.teleportTo(clicked);
            return true;
        }
        this.dragging = true;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            this.layoutDirty = true;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        double old = this.zoom;
        this.zoom = vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.zoom = Math.max(0.1, Math.min(10.0, this.zoom));
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.layoutDirty = true;
        this.uiBoundsDirty = true;
        return true;
    }

    private void drawTitle(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        class_5250 title = class_2561.method_43471((String)"gui.roadweaver.debug_map.title");
        int tw = font.method_27525((class_5348)title);
        int x = (this.field_22789 - tw) / 2;
        int y = 28;
        this.drawPanel(ctx, x - 10, y - 5, x + tw + 10, y + 14, -1073741824, -11890462);
        ctx.method_51439(font, (class_2561)title, x, y, -1, true);
    }

    private void drawStatsPanel(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        int planned = 0;
        int generating = 0;
        int completed = 0;
        int failed = 0;
        for (Records.StructureConnection conn : this.connections) {
            switch (conn.status()) {
                case PLANNED: {
                    ++planned;
                    break;
                }
                case GENERATING: {
                    ++generating;
                    break;
                }
                case COMPLETED: {
                    ++completed;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        String[] labels = new String[]{"\u7ed3\u6784: " + this.structures.size(), "\u8ba1\u5212\u4e2d: " + planned, "\u751f\u6210\u4e2d: " + generating, "\u5df2\u5b8c\u6210: " + completed, "\u5931\u8d25: " + failed, "\u9053\u8def: " + this.roads.size(), "\u7f29\u653e: " + String.format("%.1fx", this.zoom)};
        int[] colors = new int[]{-1, -10496, -29696, -13710223, -48060, -13330213, -4340793};
        int maxWidth = 0;
        for (String label : labels) {
            maxWidth = Math.max(maxWidth, font.method_1727(label));
        }
        int panelWidth = maxWidth + 20;
        int panelHeight = labels.length * 14 + 10;
        int x = this.field_22789 - 20 - panelWidth - 5;
        int y = 50;
        this.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int textY = y + 5;
        for (int i = 0; i < labels.length; ++i) {
            ctx.method_25294(x + 5, textY + 2, x + 10, textY + 7, colors[i]);
            ctx.method_49601(x + 5, textY + 2, 5, 5, -2130706433);
            ctx.method_51433(font, labels[i], x + 13, textY, colors[i], true);
            textY += 14;
        }
    }

    private void drawScalePanel(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)((double)spacing * this.baseScale * this.zoom);
        String text = spacing + " \u65b9\u5757";
        int textWidth = font.method_1727(text);
        int panelWidth = Math.max(lengthPx + 20, textWidth + 20);
        int panelHeight = 35;
        int x = this.field_22789 - 20 - panelWidth - 5;
        int y = this.field_22790 - 20 - panelHeight - 5;
        this.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int scaleX = x + (panelWidth - lengthPx) / 2;
        int scaleY = y + panelHeight - 10;
        RoadDebugScreen.fillH(ctx, scaleX, scaleX + lengthPx, scaleY, -1);
        RoadDebugScreen.fillV(ctx, scaleX, scaleY - 4, scaleY + 4, -1);
        RoadDebugScreen.fillV(ctx, scaleX + lengthPx, scaleY - 4, scaleY + 4, -1);
        ctx.method_51433(font, text, x + (panelWidth - textWidth) / 2, y + 8, -1, true);
    }

    private void drawLegendPanel(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        String[] labels = new String[]{"\u7ed3\u6784", "\u8ba1\u5212\u4e2d", "\u751f\u6210\u4e2d", "\u5931\u8d25", "\u9053\u8def"};
        int[] colors = new int[]{-13710223, -10496, -29696, -48060, -13330213};
        int maxWidth = 0;
        for (String label : labels) {
            maxWidth = Math.max(maxWidth, font.method_1727(label));
        }
        int panelWidth = maxWidth + 30;
        int panelHeight = labels.length * 16 + 10;
        int x = 25;
        int y = 50;
        this.drawPanel(ctx, x, y, x + panelWidth, y + panelHeight, -805306368, -13350562);
        int itemY = y + 5;
        for (int i = 0; i < labels.length; ++i) {
            RoadDebugScreen.fillCircle(ctx, x + 10, itemY + 4, 4, colors[i]);
            RoadDebugScreen.drawCircleOutline(ctx, x + 10, itemY + 4, 4, -2130706433);
            ctx.method_51433(font, labels[i], x + 20, itemY, -1, true);
            itemY += 16;
        }
    }

    private void computeLayout() {
        if (this.structures.isEmpty()) {
            return;
        }
        int w = Math.max(1, this.field_22789 - 40);
        int h = Math.max(1, this.field_22790 - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ) * 0.9;
        if (this.firstLayout) {
            double scale = this.baseScale * this.zoom;
            class_310 mc = class_310.method_1551();
            double px = mc != null && mc.field_1724 != null ? mc.field_1724.method_23317() : (double)this.minX;
            double pz = mc != null && mc.field_1724 != null ? mc.field_1724.method_23321() : (double)this.minZ;
            double centerX = (double)w / 2.0;
            double centerY = (double)h / 2.0;
            this.offsetX = centerX - (px - (double)this.minX) * scale;
            this.offsetY = centerY - (pz - (double)this.minZ) * scale;
            this.firstLayout = false;
        }
        if (this.screenPositions.isEmpty() || this.layoutDirty) {
            this.screenPositions.clear();
            for (class_2338 pos : this.structures) {
                double sx = (double)(pos.method_10263() - this.minX) * this.baseScale * this.zoom + this.offsetX;
                double sy = (double)(pos.method_10260() - this.minZ) * this.baseScale * this.zoom + this.offsetY;
                this.screenPositions.put(pos, new ScreenPos(20 + (int)sx, 20 + (int)sy));
            }
        }
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private class_2338 findClickedStructure(double mouseX, double mouseY) {
        for (class_2338 pos : this.structures) {
            ScreenPos p = this.screenPositions.get(pos);
            if (p == null || !(RoadDebugScreen.dist2(p.x, p.y, mouseX, mouseY) <= 25.0)) continue;
            return pos;
        }
        return null;
    }

    private void teleportTo(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.method_1576() != null) {
            mc.method_1576().execute(() -> {
                class_3222 sp = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667());
                if (sp != null) {
                    sp.method_5859((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
                }
            });
        }
    }

    private ScreenPos worldToScreen(double wx, double wz) {
        int sx = 20 + (int)((wx - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int sy = 20 + (int)((wz - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(sx, sy);
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private void drawSmallLabel(class_332 ctx, String s, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        ctx.method_51439(font, (class_2561)class_2561.method_43470((String)s), x, y, -1, true);
    }

    private void drawPanel(class_332 ctx, int x1, int y1, int x2, int y2, int bgColor, int borderColor) {
        ctx.method_25294(x1, y1, x2, y2, bgColor);
        ctx.method_49601(x1, y1, x2 - x1, y2 - y1, borderColor);
        ctx.method_25292(x1 + 1, x2 - 2, y1 + 1, 0x40FFFFFF);
        ctx.method_25301(x1 + 1, y1 + 1, y2 - 2, 0x40FFFFFF);
    }

    private void drawTooltip(class_332 ctx, class_2338 pos, int mouseX, int mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        String[] lines = new String[]{"\u5750\u6807: " + pos.method_10263() + ", " + pos.method_10260(), "\u9ad8\u5ea6: Y " + pos.method_10264(), "\u70b9\u51fb\u4f20\u9001"};
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, font.method_1727(line));
        }
        int tooltipWidth = maxWidth + 12;
        int tooltipHeight = lines.length * 11 + 6;
        int tx = mouseX + 10;
        int ty = mouseY + 10;
        if (tx + tooltipWidth > this.field_22789 - 5) {
            tx = mouseX - tooltipWidth - 10;
        }
        if (ty + tooltipHeight > this.field_22790 - 5) {
            ty = mouseY - tooltipHeight - 10;
        }
        this.drawPanel(ctx, tx, ty, tx + tooltipWidth, ty + tooltipHeight, -268435456, -11890462);
        int textY = ty + 3;
        for (String line : lines) {
            ctx.method_51433(font, line, tx + 6, textY, -1, false);
            textY += 11;
        }
    }

    private static void fillH(class_332 ctx, int x0, int x1, int y, int argb) {
        if (x1 < x0) {
            int t = x0;
            x0 = x1;
            x1 = t;
        }
        ctx.method_25294(x0, y, x1, y + 1, argb);
    }

    private static void fillV(class_332 ctx, int x, int y0, int y1, int argb) {
        if (y1 < y0) {
            int t = y0;
            y0 = y1;
            y1 = t;
        }
        ctx.method_25294(x, y0, x + 1, y1, argb);
    }

    private static void drawLine(class_332 ctx, int x0, int y0, int x1, int y1, int argb) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            ctx.method_25294(x, y, x + 1, y + 1, argb);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static void fillCircle(class_332 ctx, int cx, int cy, int r, int argb) {
        if (r < CIRCLE_CACHE.length) {
            int[] spans = CIRCLE_CACHE[r];
            for (int dy = -r; dy <= r; ++dy) {
                int span = spans[dy + r];
                ctx.method_25294(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
            }
        } else {
            for (int dy = -r; dy <= r; ++dy) {
                int span = (int)Math.round(Math.sqrt(r * r - dy * dy));
                ctx.method_25294(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
            }
        }
    }

    private static void drawCircleOutline(class_332 ctx, int cx, int cy, int r, int argb) {
        int x = r;
        int y = 0;
        int err = 0;
        while (x >= y) {
            RoadDebugScreen.plot8(ctx, cx, cy, x, y, argb);
            ++y;
            if (err <= 0) {
                err += 2 * y + 1;
            }
            if (err <= 0) continue;
            err -= 2 * --x + 1;
        }
    }

    private static void plot8(class_332 ctx, int cx, int cy, int x, int y, int argb) {
        ctx.method_25294(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
        ctx.method_25294(cx + y, cy + x, cx + y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - y, cy + x, cx - y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - x, cy + y, cx - x + 1, cy + y + 1, argb);
        ctx.method_25294(cx - x, cy - y, cx - x + 1, cy - y + 1, argb);
        ctx.method_25294(cx - y, cy - x, cx - y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + y, cy - x, cx + y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + x, cy - y, cx + x + 1, cy - y + 1, argb);
    }

    private void drawStructureNodeLOD(class_332 ctx, int x, int y, LODLevel lod) {
        int adaptiveRadius = this.getAdaptiveNodeRadius(lod);
        if (adaptiveRadius < 2) {
            ctx.method_25294(x - 1, y - 1, x + 2, y + 2, -13710223);
            return;
        }
        switch (lod.ordinal()) {
            case 0: {
                RoadDebugScreen.fillCircle(ctx, x, y, adaptiveRadius + 1, 816047669);
                RoadDebugScreen.fillCircle(ctx, x, y, adaptiveRadius, -13710223);
                RoadDebugScreen.drawCircleOutline(ctx, x, y, adaptiveRadius, -14777271);
                int highlightSize = Math.max(1, adaptiveRadius / 4);
                ctx.method_25294(x - highlightSize, y - highlightSize, x + highlightSize + 1, y + highlightSize + 1, -1426063361);
                break;
            }
            case 1: {
                RoadDebugScreen.fillCircle(ctx, x, y, adaptiveRadius, -13710223);
                RoadDebugScreen.drawCircleOutline(ctx, x, y, adaptiveRadius, -14777271);
                ctx.method_25294(x - 1, y - 1, x + 1, y + 1, -1996488705);
                break;
            }
            case 2: {
                RoadDebugScreen.fillCircle(ctx, x, y, adaptiveRadius, -13710223);
                if (adaptiveRadius < 3) break;
                RoadDebugScreen.drawCircleOutline(ctx, x, y, adaptiveRadius, -14777271);
                break;
            }
            case 3: {
                if (adaptiveRadius <= 2) {
                    ctx.method_25294(x - 1, y - 1, x + 2, y + 2, -13710223);
                    break;
                }
                RoadDebugScreen.fillCircle(ctx, x, y, adaptiveRadius, -13710223);
            }
        }
    }

    private int getAdaptiveNodeRadius(LODLevel lod) {
        double baseRadius = 5.0;
        double zoomFactor = Math.max(0.3, Math.min(1.2, 1.0 + Math.log10(this.zoom) * 0.15));
        double scaledRadius = baseRadius * zoomFactor;
        double lodMultiplier = switch (lod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.9;
            case 1 -> 1.0;
            case 2 -> 0.8;
            case 3 -> 0.6;
        };
        return Math.max(2, (int)Math.round(scaledRadius * lodMultiplier));
    }

    private void drawPlayerMarkerLOD(class_332 ctx, LODLevel lod) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || this.structures.isEmpty()) {
            return;
        }
        double px = mc.field_1724.method_23317();
        double pz = mc.field_1724.method_23321();
        ScreenPos p = this.worldToScreen(px, pz);
        int playerRadius = Math.max(3, this.getAdaptiveNodeRadius(lod) + 1);
        if (!this.isInUIBounds(p.x, p.y, playerRadius + 6)) {
            return;
        }
        int fill = -1618884;
        int glow = 1088900156;
        int outline = -7131873;
        switch (lod.ordinal()) {
            case 0: {
                RoadDebugScreen.fillCircle(ctx, p.x, p.y, playerRadius + 1, 1088900156);
                RoadDebugScreen.fillCircle(ctx, p.x, p.y, playerRadius, -1618884);
                RoadDebugScreen.drawCircleOutline(ctx, p.x, p.y, playerRadius, -7131873);
                int highlightSize = Math.max(1, playerRadius / 4);
                ctx.method_25294(p.x - highlightSize, p.y - highlightSize, p.x + highlightSize + 1, p.y + highlightSize + 1, -1426063361);
                float yaw = mc.field_1724.method_36454();
                double angle = Math.toRadians(yaw) + 1.5707963267948966;
                int arrowLength = playerRadius + 3;
                int tx = p.x + (int)Math.round(Math.cos(angle) * (double)arrowLength);
                int ty = p.y + (int)Math.round(Math.sin(angle) * (double)arrowLength);
                RoadDebugScreen.drawLine(ctx, p.x, p.y, tx, ty, -1);
                break;
            }
            case 1: {
                RoadDebugScreen.fillCircle(ctx, p.x, p.y, playerRadius, -1618884);
                RoadDebugScreen.drawCircleOutline(ctx, p.x, p.y, playerRadius, -7131873);
                ctx.method_25294(p.x - 1, p.y - 1, p.x + 1, p.y + 1, -1996488705);
                break;
            }
            case 2: {
                RoadDebugScreen.fillCircle(ctx, p.x, p.y, playerRadius, -1618884);
                if (playerRadius < 4) break;
                RoadDebugScreen.drawCircleOutline(ctx, p.x, p.y, playerRadius, -7131873);
                break;
            }
            case 3: {
                RoadDebugScreen.fillCircle(ctx, p.x, p.y, Math.max(2, playerRadius), -1618884);
            }
        }
    }

    private void drawRoadPathWithRoadLOD(class_332 ctx, List<Records.RoadSegmentPlacement> segments, int color, RoadLODLevel roadLOD) {
        int step;
        switch (roadLOD.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 64;
                break;
            }
            case 2: {
                int n = 128;
                break;
            }
            case 3: {
                int n = 256;
                break;
            }
            case 4: {
                int n = 512;
                break;
            }
            case 5: {
                int n = 1024;
                break;
            }
            case 6: {
                int n = step = Integer.MAX_VALUE;
            }
        }
        if (step >= segments.size()) {
            return;
        }
        ScreenPos prevPos = null;
        int drawnSegments = 0;
        int maxSegments = 10000;
        for (int i = 0; i < segments.size() && drawnSegments < maxSegments; i += step) {
            class_2338 pos = segments.get(i).middlePos();
            ScreenPos currentPos = this.worldToScreen(pos.method_10263(), pos.method_10260());
            if (!this.isInUIBounds(currentPos.x, currentPos.y, 100)) {
                prevPos = currentPos;
                continue;
            }
            if (prevPos != null && i > 0 && this.isLineInUIBounds(prevPos.x, prevPos.y, currentPos.x, currentPos.y)) {
                RoadDebugScreen.drawLine(ctx, prevPos.x, prevPos.y, currentPos.x, currentPos.y, color);
                ++drawnSegments;
            }
            prevPos = currentPos;
        }
    }

    private void drawGrid(class_332 ctx) {
        String label;
        LODLevel lod = this.getLODLevel();
        if (lod == LODLevel.MINIMAL) {
            return;
        }
        int w = this.field_22789 - 40;
        int h = this.field_22790 - 40;
        double worldX0 = (double)this.minX + -this.offsetX / (this.baseScale * this.zoom);
        double worldZ0 = (double)this.minZ + -this.offsetY / (this.baseScale * this.zoom);
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / (this.baseScale * this.zoom);
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / (this.baseScale * this.zoom);
        int spacing = this.computeGridSpacing();
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int maxGridLines = switch (lod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 100;
            case 1 -> 50;
            case 2 -> 25;
            case 3 -> 0;
        };
        boolean showLabels = lod == LODLevel.HIGH || lod == LODLevel.MEDIUM;
        int gridLineCount = 0;
        int x = startWX;
        while ((double)x <= worldX1 && gridLineCount < maxGridLines) {
            int sx = 20 + (int)(((double)x - worldX0) * this.baseScale * this.zoom);
            if (sx >= this.uiLeft && sx <= this.uiRight) {
                RoadDebugScreen.fillV(ctx, sx, this.uiTop, this.uiBottom, 0x40444444);
                if (showLabels) {
                    label = this.gridLabelCache.computeIfAbsent(x, String::valueOf);
                    this.drawSmallLabel(ctx, label, sx + 2, this.uiTop + 2);
                }
                ++gridLineCount;
            }
            x += spacing;
        }
        gridLineCount = 0;
        int z = startWZ;
        while ((double)z <= worldZ1 && gridLineCount < maxGridLines) {
            int sz = 20 + (int)(((double)z - worldZ0) * this.baseScale * this.zoom);
            if (sz >= this.uiTop && sz <= this.uiBottom) {
                RoadDebugScreen.fillH(ctx, this.uiLeft, this.uiRight, sz, 0x40444444);
                if (showLabels) {
                    label = this.gridLabelCache.computeIfAbsent(z, String::valueOf);
                    this.drawSmallLabel(ctx, label, this.uiLeft + 2, sz + 2);
                }
                ++gridLineCount;
            }
            z += spacing;
        }
    }

    static {
        for (int r = 0; r < 20; ++r) {
            RoadDebugScreen.CIRCLE_CACHE[r] = new int[r * 2 + 1];
            for (int dy = -r; dy <= r; ++dy) {
                RoadDebugScreen.CIRCLE_CACHE[r][dy + r] = (int)Math.round(Math.sqrt(r * r - dy * dy));
            }
        }
    }

    private static enum LODLevel {
        HIGH,
        MEDIUM,
        LOW,
        MINIMAL;

    }

    private record ScreenPos(int x, int y) {
    }

    private static enum RoadLODLevel {
        FINEST,
        SIXTY_FOURTH,
        ONE_TWENTY_EIGHTH,
        TWO_FIFTY_SIXTH,
        FIVE_TWELVE,
        ONE_THOUSAND_TWENTY_FOURTH,
        NONE;

    }
}

