/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.shiroha233.roadweaver.client.map.GridRenderer;
import net.shiroha233.roadweaver.client.map.RenderUtils;
import net.shiroha233.roadweaver.helpers.Records;

final class MapRenderers {
    private MapRenderers() {
    }

    static void renderGrid(class_332 g, class_327 font, int mapX, int mapY, int mapW, int mapH, int innerPad, double viewMinX, double viewMaxX, double viewMinZ, double viewMaxZ, int colorGrid, int gridTargetPx, int colorText) {
        GridRenderer.render(g, font, mapX, mapY, mapW, mapH, innerPad, viewMinX, viewMaxX, viewMinZ, viewMaxZ, colorGrid, gridTargetPx, colorText);
    }

    static void renderStructures(class_332 g, List<class_2338> points, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, BiPredicate<Integer, Integer> isInViewWorld, int size, int color, int left, int top, int right, int bottom) {
        for (class_2338 p : points) {
            int bx = p.method_10263();
            int bz = p.method_10260();
            if (!isInViewWorld.test(bx, bz)) continue;
            int x = toScreenX.applyAsInt(bx);
            int y = toScreenY.applyAsInt(bz);
            RenderUtils.drawPoint(g, x, y, size, color, left, top, right, bottom);
        }
    }

    static void renderConnections(class_332 g, List<Records.StructureConnection> connections, SegmentInView segmentInView, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, int thickness, int colorPlanned, int colorGenerating, int colorCompleted, int colorFailed, int left, int top, int right, int bottom) {
        for (Records.StructureConnection c : connections) {
            int tz;
            int tx;
            int fz;
            int fx = c.from().method_10263();
            if (!segmentInView.test(fx, fz = c.from().method_10260(), tx = c.to().method_10263(), tz = c.to().method_10260())) continue;
            int x1 = toScreenX.applyAsInt(fx);
            int y1 = toScreenY.applyAsInt(fz);
            int x2 = toScreenX.applyAsInt(tx);
            int y2 = toScreenY.applyAsInt(tz);
            switch (c.status()) {
                case PLANNED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorPlanned, thickness, left, top, right, bottom);
                    break;
                }
                case GENERATING: {
                    RenderUtils.drawThickDashedLine(g, x1, y1, x2, y2, colorGenerating, thickness, 8, 6, left, top, right, bottom);
                    break;
                }
                case COMPLETED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorCompleted, thickness, left, top, right, bottom);
                    break;
                }
                case FAILED: {
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, colorFailed, thickness, left, top, right, bottom);
                }
            }
        }
    }

    static void renderRoadPolylines(class_332 g, List<List<class_2338>> polylines, SegmentInView segmentInView, IntUnaryOperator toScreenX, IntUnaryOperator toScreenY, int thickness, int color, int left, int top, int right, int bottom, int lodStepBlocks) {
        for (List<class_2338> pl : polylines) {
            int z2w;
            int x2w;
            int z1w;
            int x1w;
            if (pl == null || pl.size() < 2) continue;
            class_2338 keep = pl.get(0);
            for (int i = 1; i < pl.size(); ++i) {
                int z2w2;
                int x2w2;
                int z1w2;
                int adz;
                class_2338 curr = pl.get(i);
                int dx = curr.method_10263() - keep.method_10263();
                int dz = curr.method_10260() - keep.method_10260();
                int adx = Math.abs(dx);
                int manhattan = adx + (adz = Math.abs(dz));
                if (manhattan < lodStepBlocks) continue;
                int x1w2 = keep.method_10263();
                if (segmentInView.test(x1w2, z1w2 = keep.method_10260(), x2w2 = curr.method_10263(), z2w2 = curr.method_10260())) {
                    int x1 = toScreenX.applyAsInt(x1w2);
                    int y1 = toScreenY.applyAsInt(z1w2);
                    int x2 = toScreenX.applyAsInt(x2w2);
                    int y2 = toScreenY.applyAsInt(z2w2);
                    RenderUtils.drawThickLine(g, x1, y1, x2, y2, color, thickness, left, top, right, bottom);
                }
                keep = curr;
            }
            class_2338 tail = pl.get(pl.size() - 1);
            if (tail == keep || !segmentInView.test(x1w = keep.method_10263(), z1w = keep.method_10260(), x2w = tail.method_10263(), z2w = tail.method_10260())) continue;
            int x1 = toScreenX.applyAsInt(x1w);
            int y1 = toScreenY.applyAsInt(z1w);
            int x2 = toScreenX.applyAsInt(x2w);
            int y2 = toScreenY.applyAsInt(z2w);
            RenderUtils.drawThickLine(g, x1, y1, x2, y2, color, thickness, left, top, right, bottom);
        }
    }

    static void renderLegend(class_332 g, class_327 font, int rightBound, int startY, int gap, int colorText, int colorStruct, int colorPlanned, int colorGenerating, int colorCompleted, int colorFailed, int structuresCount, int plannedCount, int generatingCount, int completedCount, int failedCount) {
        int y = startY;
        class_5250 l1 = class_2561.method_43471((String)"gui.roadweaver.map.legend.structures").method_27693(": ").method_27693(Integer.toString(structuresCount));
        int w1 = font.method_27525((class_5348)l1);
        int x1 = rightBound - w1;
        int sr = x1 - gap;
        g.method_25294(sr - 5, y + 1, sr, y + 6, colorStruct);
        g.method_51439(font, (class_2561)l1, x1, y, colorText, false);
        class_5250 l2 = class_2561.method_43471((String)"gui.roadweaver.map.legend.planned").method_27693(": ").method_27693(Integer.toString(plannedCount));
        int w2 = font.method_27525((class_5348)l2);
        int x2 = rightBound - w2;
        sr = x2 - gap;
        g.method_25294(sr - 28, (y += 16) + 2, sr, y + 7, colorPlanned);
        g.method_51439(font, (class_2561)l2, x2, y, colorText, false);
        class_5250 l3 = class_2561.method_43471((String)"gui.roadweaver.map.legend.generating").method_27693(": ").method_27693(Integer.toString(generatingCount));
        int w3 = font.method_27525((class_5348)l3);
        int x3 = rightBound - w3;
        sr = x3 - gap;
        int cy = (y += 16) + 4;
        RenderUtils.drawThickDashedLine(g, sr - 28, cy, sr, cy, colorGenerating, 5, 8, 6, sr - 28, y + 1, sr, y + 8);
        g.method_51439(font, (class_2561)l3, x3, y, colorText, false);
        class_5250 l4 = class_2561.method_43471((String)"gui.roadweaver.map.legend.completed").method_27693(": ").method_27693(Integer.toString(completedCount));
        int w4 = font.method_27525((class_5348)l4);
        int x4 = rightBound - w4;
        sr = x4 - gap;
        g.method_25294(sr - 28, (y += 16) + 2, sr, y + 7, colorCompleted);
        g.method_51439(font, (class_2561)l4, x4, y, colorText, false);
        class_5250 l5 = class_2561.method_43471((String)"gui.roadweaver.map.legend.failed").method_27693(": ").method_27693(Integer.toString(failedCount));
        int w5 = font.method_27525((class_5348)l5);
        int x5 = rightBound - w5;
        sr = x5 - gap;
        g.method_25294(sr - 28, (y += 16) + 2, sr, y + 7, colorFailed);
        g.method_51439(font, (class_2561)l5, x5, y, colorText, false);
    }

    static void drawPlayerArrow(class_332 g, int sx, int sy, float yawDeg, int tipLen, int baseLen, int baseHalfWidth, int color, int left, int top, int right, int bottom, double pxPerBlockX, double pxPerBlockZ) {
        double vz;
        double dirY;
        double rx = Math.toRadians(yawDeg);
        double vx = -Math.sin(rx);
        double dirX = vx * pxPerBlockX;
        double mag = Math.hypot(dirX, dirY = (vz = Math.cos(rx)) * pxPerBlockZ);
        if (mag < 1.0E-6) {
            dirX = 1.0;
            dirY = 0.0;
            mag = 1.0;
        }
        double px = (double)sx + (dirX /= mag) * (double)tipLen;
        double py = (double)sy + (dirY /= mag) * (double)tipLen;
        double bx = (double)sx - dirX * (double)baseLen;
        double by = (double)sy - dirY * (double)baseLen;
        double perpX = -dirY;
        double perpY = dirX;
        double bx1 = bx + perpX * (double)baseHalfWidth;
        double by1 = by + perpY * (double)baseHalfWidth;
        double bx2 = bx - perpX * (double)baseHalfWidth;
        double by2 = by - perpY * (double)baseHalfWidth;
        int ipx = (int)Math.round(px);
        int ipy = (int)Math.round(py);
        int ibx1 = (int)Math.round(bx1);
        int iby1 = (int)Math.round(by1);
        int ibx2 = (int)Math.round(bx2);
        int iby2 = (int)Math.round(by2);
        int outline = -1;
        RenderUtils.fillTriangle(g, ipx - 1, ipy, ibx1 - 1, iby1, ibx2 - 1, iby2, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx + 1, ipy, ibx1 + 1, iby1, ibx2 + 1, iby2, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy - 1, ibx1, iby1 - 1, ibx2, iby2 - 1, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy + 1, ibx1, iby1 + 1, ibx2, iby2 + 1, outline, left, top, right, bottom);
        RenderUtils.fillTriangle(g, ipx, ipy, ibx1, iby1, ibx2, iby2, color, left, top, right, bottom);
    }

    static interface SegmentInView {
        public boolean test(int var1, int var2, int var3, int var4);
    }
}

