/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.bridge;

import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeBuilder {
    private static final class_2680 DECK = class_2246.field_10056.method_9564();
    private static final class_2680 RAIL = class_2246.field_10252.method_9564();
    private static final class_2680 PIER = class_2246.field_10056.method_9564();

    private BridgeBuilder() {
    }

    public static void placeSegment(class_5281 world, Records.RoadSegmentPlacement seg, class_2338 middle, class_2338 prev, class_2338 next, int roadWidth, int deckY, int segmentIndex, class_5819 random, ModConfig cfg, boolean placePier, boolean placeRail) {
        int interval;
        int radius = Math.max(1, roadWidth / 2);
        int sx = Integer.compare(next.method_10263() - prev.method_10263(), 0);
        int sz = Integer.compare(next.method_10260() - prev.method_10260(), 0);
        int ox = -sz;
        int oz = sx;
        BridgeBuilder.plotLine(prev.method_10263(), prev.method_10260(), middle.method_10263(), middle.method_10260(), (x, z) -> {
            for (int off = -radius; off <= radius; ++off) {
                int px = x + off * ox;
                int pz = z + off * oz;
                world.method_8652(new class_2338(px, deckY, pz), DECK, 3);
                if (sx == 0 || sz == 0) continue;
                world.method_8652(new class_2338(px + sx, deckY, pz), DECK, 3);
                world.method_8652(new class_2338(px, deckY, pz + sz), DECK, 3);
            }
        });
        for (class_2338 w : seg.positions()) {
            world.method_8652(new class_2338(w.method_10263(), deckY, w.method_10260()), DECK, 3);
        }
        if (placeRail && cfg.bridgeRailingEnabled()) {
            int leftOutX = -ox;
            int leftOutZ = -oz;
            BridgeBuilder.plotLine(prev.method_10263() + -radius * ox, prev.method_10260() + -radius * oz, middle.method_10263() + -radius * ox, middle.method_10260() + -radius * oz, (x, z) -> {
                if (!BridgeBuilder.hasDeck(world, x, deckY, z)) {
                    return;
                }
                if (BridgeBuilder.hasDeck(world, x + leftOutX, deckY, z + leftOutZ)) {
                    return;
                }
                if (!BridgeBuilder.hasDeck(world, x + sx, deckY, z + sz) && !BridgeBuilder.hasDeck(world, x - sx, deckY, z - sz)) {
                    return;
                }
                if (BridgeBuilder.deckNeighborCount(world, x, deckY, z) <= 1) {
                    return;
                }
                world.method_8652(new class_2338(x, deckY + 1, z), RAIL, 3);
            });
            int rightOutX = ox;
            int rightOutZ = oz;
            BridgeBuilder.plotLine(prev.method_10263() + radius * ox, prev.method_10260() + radius * oz, middle.method_10263() + radius * ox, middle.method_10260() + radius * oz, (x, z) -> {
                if (!BridgeBuilder.hasDeck(world, x, deckY, z)) {
                    return;
                }
                if (BridgeBuilder.hasDeck(world, x + rightOutX, deckY, z + rightOutZ)) {
                    return;
                }
                if (!BridgeBuilder.hasDeck(world, x + sx, deckY, z + sz) && !BridgeBuilder.hasDeck(world, x - sx, deckY, z - sz)) {
                    return;
                }
                if (BridgeBuilder.deckNeighborCount(world, x, deckY, z) <= 1) {
                    return;
                }
                world.method_8652(new class_2338(x, deckY + 1, z), RAIL, 3);
            });
        }
        if (placePier && segmentIndex % (interval = Math.max(3, cfg.bridgePierInterval())) == 0) {
            BridgeBuilder.placePierUnder(world, middle.method_10263(), middle.method_10260(), deckY - 1, cfg.bridgePierMaxHeight(), cfg.bridgePierWidth());
        }
    }

    private static boolean hasDeck(class_5281 world, int x, int y, int z) {
        return world.method_8320(new class_2338(x, y, z)).method_26204() == DECK.method_26204();
    }

    private static int deckNeighborCount(class_5281 world, int x, int y, int z) {
        int c = 0;
        if (BridgeBuilder.hasDeck(world, x + 1, y, z)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x - 1, y, z)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x, y, z + 1)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x, y, z - 1)) {
            ++c;
        }
        return c;
    }

    private static void plotLine(int x0, int z0, int x1, int z1, LineConsumer consumer) {
        int dx = Math.abs(x1 - x0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int err = dx - dz;
        int x = x0;
        int z = z0;
        while (true) {
            consumer.accept(x, z);
            if (x == x1 && z == z1) break;
            int e2 = 2 * err;
            if (e2 > -dz) {
                err -= dz;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            z += sz;
        }
    }

    private static void placePierUnder(class_5281 world, int x, int z, int fromY, int maxHeight, int pierWidth) {
        int minY = world.method_31607();
        int half = Math.max(0, pierWidth - 1);
        for (int dx = -half; dx <= half; ++dx) {
            for (int dz = -half; dz <= half; ++dz) {
                class_2338 cur;
                int y = fromY;
                for (int h = 0; y >= minY && h < maxHeight && !world.method_8320(cur = new class_2338(x + dx, y, z + dz)).method_26206((class_1922)world, cur, class_2350.field_11036); --y, ++h) {
                    world.method_8652(cur, PIER, 3);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface LineConsumer {
        public void accept(int var1, int var2);
    }
}

