/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.RoadFeatureCompat;

public final class SurfacePlacementUtil {
    private SurfacePlacementUtil() {
    }

    public static void placeOnSurface(class_5281 world, class_2338 placePos, List<class_2680> material, int roadType, class_5819 random, ModConfig cfg) {
        boolean doPlace;
        double naturalBlockChance = 1.0;
        class_2338 surfacePos = placePos;
        class_2338 belowTop = surfacePos.method_10074();
        class_2680 blockStateAtPos = world.method_8320(belowTop);
        boolean bl = doPlace = roadType == 0 || random.method_43058() < naturalBlockChance;
        if (doPlace) {
            SurfacePlacementUtil.placeRoadBlock(world, blockStateAtPos, surfacePos, material, random, cfg);
        } else {
            SurfacePlacementUtil.clearAboveColumn(world, surfacePos, cfg);
        }
    }

    public static void placeRoadBlock(class_5281 world, class_2680 blockBelow, class_2338 surfacePos, List<class_2680> materials, class_5819 random, ModConfig cfg) {
        if (!SurfacePlacementUtil.placeAllowedCheck(blockBelow.method_26204())) {
            return;
        }
        class_2680 chosen = materials.get(random.method_43048(materials.size()));
        int MAX_CAUSEWAY_DEPTH = Math.max(0, Math.min(12, cfg == null ? 1 : cfg.causewayMaxDepth()));
        class_2338 below1 = surfacePos.method_10074();
        class_2338 below2 = surfacePos.method_10087(2);
        boolean sturdy1 = world.method_8320(below1).method_26206((class_1922)world, below1, class_2350.field_11036);
        boolean sturdy2 = world.method_8320(below2).method_26206((class_1922)world, below2, class_2350.field_11036);
        if (!sturdy1 && !sturdy2) {
            class_2338 fillStart;
            class_2338 cursor = below2;
            class_2338 base = null;
            for (int depth = 0; cursor.method_10264() > world.method_31607() && depth < MAX_CAUSEWAY_DEPTH; ++depth) {
                if (world.method_8320(cursor).method_26206((class_1922)world, cursor, class_2350.field_11036)) {
                    base = cursor;
                    break;
                }
                cursor = cursor.method_10074();
            }
            class_2338 class_23382 = fillStart = base != null ? base.method_10084() : below1.method_10087(Math.min(MAX_CAUSEWAY_DEPTH - 1, Math.max(0, below1.method_10264() - world.method_31607())));
            if (fillStart.method_10264() < world.method_31607()) {
                fillStart = new class_2338(fillStart.method_10263(), world.method_31607(), fillStart.method_10260());
            }
            class_2338 pos = fillStart;
            while (pos.method_10264() <= below1.method_10264()) {
                world.method_8652(pos, chosen, 3);
                pos = pos.method_10084();
            }
        } else {
            world.method_8652(below1, chosen, 3);
        }
        SurfacePlacementUtil.clearAboveColumn(world, surfacePos, cfg);
        class_2338 belowPos1 = surfacePos.method_10087(2);
        class_2680 belowState1 = world.method_8320(belowPos1);
        if (belowState1.method_27852(class_2246.field_10219)) {
            world.method_8652(belowPos1, class_2246.field_10566.method_9564(), 3);
        }
    }

    public static void clearAboveColumn(class_5281 world, class_2338 surfacePos, ModConfig cfg) {
        boolean tunnel = cfg != null && cfg.tunnelEnabled();
        int maxH = tunnel ? Math.max(2, Math.min(16, cfg.tunnelClearHeight())) : 3;
        for (int i = 0; i < maxH; ++i) {
            class_2338 up = surfacePos.method_10086(i);
            class_2680 st = world.method_8320(up);
            if (st.method_26215() || cfg != null && cfg.removeWholeTreeOnPath() && (st.method_26164(class_3481.field_15475) || st.method_27852(class_2246.field_10211) || SurfacePlacementUtil.isVineLike(st) || st.method_27852(class_2246.field_10302)) && SurfacePlacementUtil.fellTreeAt(world, up, cfg)) continue;
            if (tunnel) {
                if (!st.method_26164(class_3481.field_15503) && !st.method_26164(class_3481.field_15475) && st.method_26225()) continue;
                world.method_8652(up, class_2246.field_10124.method_9564(), 3);
                continue;
            }
            if (st.method_26164(class_3481.field_15475) || st.method_26164(class_3481.field_16584)) break;
            world.method_8652(up, class_2246.field_10124.method_9564(), 3);
        }
    }

    private static boolean fellTreeAt(class_5281 world, class_2338 logStart, ModConfig cfg) {
        class_2338 down;
        class_2680 downSt;
        if (cfg == null) {
            return false;
        }
        int radius = Math.max(2, Math.min(12, cfg.treeRemovalMaxRadius()));
        int maxH = Math.max(8, Math.min(64, cfg.treeRemovalMaxHeight()));
        int maxBlocks = Math.max(64, Math.min(8192, cfg.treeRemovalMaxBlocks()));
        int leavesConfirm = Math.max(0, Math.min(128, cfg.treeLeavesConfirm()));
        class_2680 startState = world.method_8320(logStart);
        if (!(startState.method_26164(class_3481.field_15475) || startState.method_27852(class_2246.field_10211) || SurfacePlacementUtil.isVineLike(startState) || startState.method_27852(class_2246.field_10302) || startState.method_27852(class_2246.field_28686))) {
            return false;
        }
        class_2338 base = logStart;
        for (int steps = 0; steps < maxH && ((downSt = world.method_8320(down = base.method_10074())).method_26164(class_3481.field_15475) || downSt.method_27852(class_2246.field_10211)); ++steps) {
            base = down;
        }
        int minX = base.method_10263() - radius;
        int maxX = base.method_10263() + radius;
        int minZ = base.method_10260() - radius;
        int maxZ = base.method_10260() + radius;
        int minY = Math.max(world.method_31607(), base.method_10264() - 1);
        int maxY = Math.min(world.method_31600() - 1, base.method_10264() + maxH);
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        int leavesCount = 0;
        boolean hasBamboo = false;
        boolean hasVineLike = false;
        boolean hasCocoa = false;
        q.add(base);
        seen.add(base.method_10063());
        while (!q.isEmpty() && toRemove.size() < maxBlocks) {
            class_2338[] neigh;
            class_2338 p = (class_2338)q.pollFirst();
            if (p.method_10263() < minX || p.method_10263() > maxX || p.method_10260() < minZ || p.method_10260() > maxZ || p.method_10264() < minY || p.method_10264() > maxY) continue;
            class_2680 st = world.method_8320(p);
            boolean isLog = st.method_26164(class_3481.field_15475);
            boolean isLeaves = st.method_26164(class_3481.field_15503);
            boolean isBamboo = st.method_27852(class_2246.field_10211);
            boolean isVine = SurfacePlacementUtil.isVineLike(st);
            boolean isCocoa = st.method_27852(class_2246.field_10302);
            boolean isHangingRoots = st.method_27852(class_2246.field_28686);
            if (!isLog && !isLeaves && !isBamboo && !isVine && !isCocoa && !isHangingRoots) continue;
            toRemove.add(p);
            if (isLeaves) {
                ++leavesCount;
            }
            if (isBamboo) {
                hasBamboo = true;
            }
            if (isVine) {
                hasVineLike = true;
            }
            if (isCocoa) {
                hasCocoa = true;
            }
            for (class_2338 n : neigh = new class_2338[]{p.method_10084(), p.method_10074(), p.method_10095(), p.method_10072(), p.method_10078(), p.method_10067()}) {
                long key = n.method_10063();
                if (!seen.add(key)) continue;
                q.addLast(n);
            }
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        if (!(hasBamboo || hasVineLike || hasCocoa || leavesCount >= leavesConfirm)) {
            return false;
        }
        for (class_2338 p : toRemove) {
            world.method_8652(p, class_2246.field_10124.method_9564(), 3);
        }
        return true;
    }

    private static boolean isVineLike(class_2680 st) {
        return st.method_27852(class_2246.field_10597) || st.method_27852(class_2246.field_28675) || st.method_27852(class_2246.field_28676) || st.method_27852(class_2246.field_22123) || st.method_27852(class_2246.field_22124) || st.method_27852(class_2246.field_23078) || st.method_27852(class_2246.field_23079);
    }

    private static boolean placeAllowedCheck(class_2248 block) {
        return !RoadFeatureCompat.dontPlaceHere(block) && !block.method_9564().method_26164(class_3481.field_15503) && !block.method_9564().method_26164(class_3481.field_15475) && !block.method_9564().method_26164(class_3481.field_15496) && !block.method_9564().method_26164(class_3481.field_17619) && !block.method_9564().method_26164(class_3481.field_15471);
    }
}

