/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.roadlogic.BasicAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.helpers.Records;

public final class RoadPathCalculator {
    public static final Map<Long, Integer> heightCache = new ConcurrentHashMap<Long, Integer>();
    public static final Map<Long, Boolean> waterCache = new ConcurrentHashMap<Long, Boolean>();
    public static final Map<Long, Integer> oceanFloorCache = new ConcurrentHashMap<Long, Integer>();
    public static final Map<Long, Boolean> nearWaterCache = new ConcurrentHashMap<Long, Boolean>();
    public static final Map<Long, Boolean> columnWaterCache = new ConcurrentHashMap<Long, Boolean>();
    private static final int MAX_CACHE_ENTRIES = 200000;

    private RoadPathCalculator() {
    }

    static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static void pruneCachesIfTooLarge() {
        if (heightCache.size() > 200000) {
            heightCache.clear();
        }
        if (waterCache.size() > 200000) {
            waterCache.clear();
        }
        if (oceanFloorCache.size() > 200000) {
            oceanFloorCache.clear();
        }
        if (nearWaterCache.size() > 200000) {
            nearWaterCache.clear();
        }
        if (columnWaterCache.size() > 200000) {
            columnWaterCache.clear();
        }
    }

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(class_2338 startIn, class_2338 endIn, int width, class_3218 level, int maxSteps) {
        int dGrid = RoadPathCalculator.getNeighborDistance();
        int sx = RoadPathCalculator.snapToGrid(startIn.method_10263(), dGrid);
        int sz = RoadPathCalculator.snapToGrid(startIn.method_10260(), dGrid);
        int ex = RoadPathCalculator.snapToGrid(endIn.method_10263(), dGrid);
        int ez = RoadPathCalculator.snapToGrid(endIn.method_10260(), dGrid);
        class_2338 start = new class_2338(sx, startIn.method_10264(), sz);
        class_2338 end = new class_2338(ex, endIn.method_10264(), ez);
        class_2338 startGround = new class_2338(start.method_10263(), RoadPathCalculator.heightSampler(start.method_10263(), start.method_10260(), level), start.method_10260());
        class_2338 endGround = new class_2338(end.method_10263(), RoadPathCalculator.heightSampler(end.method_10263(), end.method_10260(), level), end.method_10260());
        List<Records.RoadSegmentPlacement> land = BasicAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps);
        return land;
    }

    static int calculateTerrainStability(class_2338 pos, int y, class_3218 level) {
        int cost = 0;
        if (Math.abs(RoadPathCalculator.heightSampler(pos.method_10263() + 1, pos.method_10260(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.method_10263() - 1, pos.method_10260(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.method_10263(), pos.method_10260() + 1, level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(pos.method_10263(), pos.method_10260() - 1, level) - y) > 0) {
            ++cost;
        }
        return cost;
    }

    static int heightSampler(int x, int z, class_3218 level) {
        RoadPathCalculator.pruneCachesIfTooLarge();
        long key = RoadPathCalculator.hashXZ(x, z);
        return heightCache.computeIfAbsent(key, k -> {
            class_7138 rs = level.method_14178().method_46642().method_46713();
            return level.method_14178().method_12129().method_16397(x, z, class_2902.class_2903.field_13194, (class_5539)level, rs);
        });
    }

    static boolean isWaterLike(int x, int z, class_3218 level) {
        RoadPathCalculator.pruneCachesIfTooLarge();
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean v = waterCache.get(key);
        if (v != null) {
            return v;
        }
        class_6880 biome = level.method_23753(new class_2338(x, 0, z));
        boolean res = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508);
        waterCache.put(key, res);
        return res;
    }

    static int oceanFloorSampler(int x, int z, class_3218 level) {
        RoadPathCalculator.pruneCachesIfTooLarge();
        long key = RoadPathCalculator.hashXZ(x, z);
        return oceanFloorCache.computeIfAbsent(key, k -> {
            class_7138 rs = level.method_14178().method_46642().method_46713();
            return level.method_14178().method_12129().method_16397(x, z, class_2902.class_2903.field_13195, (class_5539)level, rs);
        });
    }

    static boolean isNearWaterLike(int x, int z, class_3218 level) {
        int[][] neighborOffsets;
        RoadPathCalculator.pruneCachesIfTooLarge();
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean cached = nearWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int d = RoadPathCalculator.getNeighborDistance();
        for (int[] off : neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}}) {
            int nx = x + off[0];
            int nz = z + off[1];
            if (!RoadPathCalculator.isWaterLike(nx, nz, level)) continue;
            nearWaterCache.put(key, true);
            return true;
        }
        nearWaterCache.put(key, false);
        return false;
    }

    static boolean isColumnWater(int x, int z, class_3218 level) {
        class_2338 check;
        boolean res;
        RoadPathCalculator.pruneCachesIfTooLarge();
        long key = RoadPathCalculator.hashXZ(x, z);
        Boolean cached = columnWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int ws = RoadPathCalculator.heightSampler(x, z, level);
        int of = RoadPathCalculator.oceanFloorSampler(x, z, level);
        int sea = level.method_8615();
        boolean bl = res = ws > of && ws >= sea;
        if (res && level.method_8477(check = new class_2338(x, Math.max(sea - 1, ws - 1), z))) {
            res = level.method_8316(check).method_15767(class_3486.field_15517);
        }
        columnWaterCache.put(key, res);
        return res;
    }

    static int snapToGrid(int v, int gridSize) {
        return Math.floorDiv(v, gridSize) * gridSize;
    }

    static Set<class_2338> generateWidth(class_2338 center, int radius, Set<class_2338> cache, RoadDirection dir) {
        HashSet<class_2338> set = new HashSet<class_2338>();
        int cx = center.method_10263();
        int cz = center.method_10260();
        int y = 0;
        if (dir == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2338 p = new class_2338(cx, y, cz + dz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else if (dir == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                class_2338 p = new class_2338(cx + dx, y, cz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 p;
                    if (dir == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || dir == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || !cache.add(p = new class_2338(cx + dx, y, cz + dz))) continue;
                    set.add(p);
                }
            }
        }
        return set;
    }

    public static List<Records.RoadSpan> extractSpans(List<Records.RoadSegmentPlacement> segments, class_3218 level) {
        int len;
        ArrayList<Records.RoadSpan> spans = new ArrayList<Records.RoadSpan>();
        if (segments == null || segments.isEmpty()) {
            return spans;
        }
        ArrayList<class_2338> centers = new ArrayList<class_2338>(segments.size());
        for (Records.RoadSegmentPlacement seg : segments) {
            centers.add(seg.middlePos());
        }
        boolean inWater = false;
        int waterStart = -1;
        for (int i = 0; i < centers.size(); ++i) {
            class_2338 p = (class_2338)centers.get(i);
            boolean water = RoadPathCalculator.isColumnWater(p.method_10263(), p.method_10260(), level);
            if (water && !inWater) {
                inWater = true;
                waterStart = i;
                continue;
            }
            if (water || !inWater) continue;
            int startIdx = Math.max(0, waterStart - 1);
            int endIdx = i;
            class_2338 start = (class_2338)centers.get(startIdx);
            class_2338 end = (class_2338)centers.get(Math.min(endIdx, centers.size() - 1));
            spans.add(new Records.RoadSpan(start, end, Records.SpanType.BRIDGE));
            inWater = false;
            waterStart = -1;
        }
        int SLOPE_ABS_THRESHOLD = 4;
        int RUN_MIN_LENGTH = 3;
        int runStart = -1;
        for (int i = 1; i < centers.size(); ++i) {
            boolean steep;
            class_2338 a = (class_2338)centers.get(i - 1);
            class_2338 b = (class_2338)centers.get(i);
            int ya = RoadPathCalculator.heightSampler(a.method_10263(), a.method_10260(), level);
            int yb = RoadPathCalculator.heightSampler(b.method_10263(), b.method_10260(), level);
            int dy = Math.abs(yb - ya);
            boolean bl = steep = dy >= 4;
            if (steep) {
                if (runStart >= 0) continue;
                runStart = i - 1;
                continue;
            }
            if (runStart < 0) continue;
            int len2 = i - runStart;
            if (len2 >= 3) {
                class_2338 s = (class_2338)centers.get(runStart);
                class_2338 e = (class_2338)centers.get(i);
                spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
            }
            runStart = -1;
        }
        if (runStart >= 0 && (len = centers.size() - runStart) >= 3) {
            class_2338 s = (class_2338)centers.get(runStart);
            class_2338 e = (class_2338)centers.get(centers.size() - 1);
            spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
        }
        return spans;
    }

    public static void clearCaches() {
        heightCache.clear();
        waterCache.clear();
        oceanFloorCache.clear();
        nearWaterCache.clear();
        columnWaterCache.clear();
    }
}

