/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.generation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.generation.RoadGenerationService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.planning.RoadPlanningService;

public final class InitialGenManager {
    private static volatile boolean active;
    private static volatile int total;
    private static volatile int done;
    private static volatile int planned;
    private static volatile int generating;
    private static volatile int failed;

    private InitialGenManager() {
    }

    public static boolean isActive() {
        return active;
    }

    public static int getTotal() {
        return total;
    }

    public static int getDone() {
        return done;
    }

    public static int getPlanned() {
        return planned;
    }

    public static int getGenerating() {
        return generating;
    }

    public static int getFailed() {
        return failed;
    }

    public static void begin(class_3218 level) {
        if (level == null || !class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        active = true;
        total = 0;
        done = 0;
        planned = 0;
        generating = 0;
        failed = 0;
        RoadGenerationService.onServerStarted();
        RoadPlanningService.initialPlan(level);
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> conns = provider.getStructureConnections(level);
        total = conns == null ? 0 : conns.size();
        InitialGenManager.update(level);
    }

    public static void blockUntilDone(class_3218 level) {
        if (!active) {
            return;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> list = provider.getStructureConnections(level);
        if (list != null) {
            for (Records.StructureConnection c : new ArrayList<Records.StructureConnection>(list)) {
                if (c.status() != Records.ConnectionStatus.PLANNED) continue;
                RoadGenerationService.generateInline(level, c);
                InitialGenManager.update(level);
            }
        }
        RoadPathCalculator.clearCaches();
        active = false;
    }

    public static void update(class_3218 level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> conns = provider.getStructureConnections(level);
        if (conns == null) {
            total = 0;
            planned = 0;
            generating = 0;
            done = 0;
            failed = 0;
            return;
        }
        int p = 0;
        int g = 0;
        int c = 0;
        int f = 0;
        for (Records.StructureConnection sc : conns) {
            Records.ConnectionStatus s = sc.status();
            if (s == Records.ConnectionStatus.PLANNED) {
                ++p;
                continue;
            }
            if (s == Records.ConnectionStatus.GENERATING) {
                ++g;
                continue;
            }
            if (s == Records.ConnectionStatus.COMPLETED) {
                ++c;
                continue;
            }
            if (s != Records.ConnectionStatus.FAILED) continue;
            ++f;
        }
        total = conns.size();
        planned = p;
        generating = g;
        done = c;
        failed = f;
    }
}

